/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.upgrade;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.metadata.usergroup.UserGroup;
import org.apache.kylin.tool.util.MetadataUtil;
import org.apache.kylin.tool.util.ScreenPrintUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateUserGroupCLI
extends ExecutableApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateUserGroupCLI.class);
    private static final Option OPTION_METADATA_DIR = OptionBuilder.getInstance().hasArg().withArgName("metadata_dir").withDescription("metadata dir.").isRequired(true).withLongOpt("metadata_dir").create("d");
    private static final Option OPTION_EXEC = OptionBuilder.getInstance().hasArg(false).withArgName("exec").withDescription("exec the upgrade.").isRequired(false).withLongOpt("exec").create("e");

    public static void main(String[] args) {
        log.info("Start upgrade user group metadata.");
        try {
            UpdateUserGroupCLI tool = new UpdateUserGroupCLI();
            tool.execute(args);
        }
        catch (Exception e) {
            log.error("Upgrade user group metadata failed.", (Throwable)e);
            ScreenPrintUtil.systemExitWhenMainThread(1);
        }
        log.info("Upgrade user group metadata successfully.");
        ScreenPrintUtil.systemExitWhenMainThread(0);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_METADATA_DIR);
        options.addOption(OPTION_EXEC);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String metadataUrl = MetadataUtil.getMetadataUrl(optionsHelper.getOptionValue(OPTION_METADATA_DIR));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)metadataUrl));
        File userGroupFile = new File(metadataUrl, "/_global/user_group");
        if (!userGroupFile.exists()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.USERGROUP_NOT_EXIST, "User group metadata doesn't exist.");
        }
        if (userGroupFile.isDirectory()) {
            ScreenPrintUtil.printlnGreen("user group metadata upgrade succeeded.");
            log.info("Succeed to upgrade user group metadata.");
            return;
        }
        ScreenPrintUtil.printlnGreen("found user group metadata need to be upgraded.");
        if (optionsHelper.hasOption(OPTION_EXEC)) {
            UserGroup4Dot1 userGroups = (UserGroup4Dot1)JsonUtil.readValue((File)userGroupFile, UserGroup4Dot1.class);
            FileUtils.forceDelete((File)userGroupFile);
            userGroupFile.mkdirs();
            for (String groupName : userGroups.getGroups()) {
                File out = new File(userGroupFile, groupName);
                UserGroup userGroup = new UserGroup(groupName);
                JsonUtil.writeValue((File)out, (Object)userGroup);
            }
            ScreenPrintUtil.printlnGreen("user group metadata upgrade succeeded.");
            log.info("Succeed to upgrade user group metadata.");
        }
    }

    private static class UserGroup4Dot1 {
        @JsonProperty(value="groups")
        List<String> groups;

        @Generated
        public UserGroup4Dot1() {
        }

        @Generated
        public List<String> getGroups() {
            return this.groups;
        }

        @Generated
        public void setGroups(List<String> groups) {
            this.groups = groups;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserGroup4Dot1)) {
                return false;
            }
            UserGroup4Dot1 other = (UserGroup4Dot1)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$groups = this.getGroups();
            List<String> other$groups = other.getGroups();
            return !(this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UserGroup4Dot1;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $groups = this.getGroups();
            result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UpdateUserGroupCLI.UserGroup4Dot1(groups=" + this.getGroups() + ")";
        }
    }
}

