/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.upgrade;

import com.google.common.base.Preconditions;
import io.kyligence.kap.shaded.curator.org.apache.curator.shaded.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.tool.util.MetadataUtil;
import org.apache.kylin.tool.util.ScreenPrintUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateModelCLI
extends ExecutableApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateModelCLI.class);
    private static final Option OPTION_METADATA_DIR = OptionBuilder.getInstance().hasArg().withArgName("metadata_dir").withDescription("metadata dir.").isRequired(true).withLongOpt("metadata_dir").create("d");
    private static final Option OPTION_EXEC = OptionBuilder.getInstance().hasArg(false).withArgName("exec").withDescription("exec the upgrade.").isRequired(false).withLongOpt("exec").create("e");

    public static void main(String[] args) {
        UpdateModelCLI updateModelCLI = new UpdateModelCLI();
        try {
            updateModelCLI.execute(args);
        }
        catch (Exception e) {
            log.error("Failed to exec UpdateModelCLI", (Throwable)e);
            ScreenPrintUtil.systemExitWhenMainThread(1);
        }
        log.info("Upgrade model finished.");
        ScreenPrintUtil.systemExitWhenMainThread(0);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_METADATA_DIR);
        options.addOption(OPTION_EXEC);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String metadataUrl = MetadataUtil.getMetadataUrl(optionsHelper.getOptionValue(OPTION_METADATA_DIR));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)metadataUrl));
        KylinConfig systemKylinConfig = KylinConfig.getInstanceFromEnv();
        systemKylinConfig.setMetadataUrl(metadataUrl);
        log.info("Start to upgrade all model.");
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        ArrayList globalUpdateModelList = Lists.newArrayList();
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)kylinConfig);
        projectManager.listAllProjects().forEach(projectInstance -> {
            NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)kylinConfig, (String)projectInstance.getName());
            NDataModelManager dataModelManager = NDataModelManager.getInstance((KylinConfig)kylinConfig, (String)projectInstance.getName());
            List updateModelList = dataModelManager.listAllModels().stream().filter(nDataModel -> !nDataModel.isBroken()).filter(nDataModel -> !indexPlanManager.getIndexPlan(nDataModel.getUuid()).isBroken()).map(arg_0 -> ((NDataModelManager)dataModelManager).copyForWrite(arg_0)).peek(model -> {
                IndexPlan indexPlan = indexPlanManager.getIndexPlan(model.getUuid());
                Set tableIndexDimensions = indexPlan.getIndexes().stream().filter(indexEntity -> indexEntity.getId() >= 20000000000L).flatMap(indexEntity -> indexEntity.getDimensions().stream()).collect(Collectors.toSet());
                long count = model.getAllNamedColumns().stream().filter(namedColumn -> {
                    if (!namedColumn.isDimension() && tableIndexDimensions.contains(namedColumn.getId())) {
                        namedColumn.setStatus(NDataModel.ColumnStatus.DIMENSION);
                        return true;
                    }
                    return false;
                }).count();
                log.info("Project: {}, model: {}, add model dimension size: {}", new Object[]{projectInstance.getName(), model.getAlias(), count});
            }).collect(Collectors.toList());
            globalUpdateModelList.addAll(updateModelList);
        });
        ScreenPrintUtil.printlnGreen(String.format(Locale.ROOT, "found %d models need to be modified.", globalUpdateModelList.size()));
        if (optionsHelper.hasOption(OPTION_EXEC)) {
            Map<String, List<NDataModel>> modelsGroupByProject = globalUpdateModelList.stream().collect(Collectors.groupingBy(NDataModel::getProject));
            modelsGroupByProject.forEach((project, models) -> UnitOfWork.doInTransactionWithRetry(() -> {
                models.forEach(model -> NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).updateDataModelDesc(model));
                return null;
            }, (String)project));
            ScreenPrintUtil.printlnGreen("model dimensions upgrade succeeded.");
        }
        log.info("Succeed to upgrade all model.");
    }
}

