/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.upgrade;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.kyligence.kap.guava20.shaded.common.io.ByteSource;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.metadata.acl.AclTCR;
import org.apache.kylin.metadata.acl.AclTCRManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.metadata.user.NKylinUserManager;
import org.apache.kylin.tool.upgrade.RenameEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameUserResourceTool
extends ExecutableApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RenameUserResourceTool.class);
    private static final Option OPTION_DIR;
    private static final Option OPTION_USERS;
    private static final Option OPTION_COLLECT_ONLY;
    private static final Option OPTION_HELP;
    private final Set<String> existsUserNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, String> renameUserMap = new HashMap<String, String>();
    private Set<String> users = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private boolean collectOnly = true;
    private KylinConfig config = KylinConfig.getInstanceFromEnv();
    private ResourceStore resourceStore;

    public static void main(String[] args) {
        RenameUserResourceTool tool = new RenameUserResourceTool();
        tool.execute(args);
        System.out.println("Rename user resource finished.");
        Unsafe.systemExit((int)0);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_DIR);
        options.addOption(OPTION_USERS);
        options.addOption(OPTION_COLLECT_ONLY);
        options.addOption(OPTION_HELP);
        return options;
    }

    private boolean printUsage(OptionsHelper optionsHelper) {
        boolean help = optionsHelper.hasOption(OPTION_HELP);
        if (help) {
            optionsHelper.printUsage(((Object)((Object)this)).getClass().getName(), this.getOptions());
        }
        return help;
    }

    private void initOptionValues(OptionsHelper optionsHelper) {
        while (true) {
            System.out.println("This script will help you modify the duplicate user name.  The system will add a number after the group name created according to the modification time, for example abc-> abc1\nPlease confirm if you need to execute the script\uff1f(y/n)");
            Scanner scanner = new Scanner(System.in, Charset.defaultCharset().name());
            String prompt = scanner.nextLine();
            if (StringUtils.equals((String)"y", (String)prompt)) break;
            if (!StringUtils.equals((String)"n", (String)prompt)) continue;
            Unsafe.systemExit((int)0);
        }
        if (optionsHelper.hasOption(OPTION_USERS)) {
            this.users.addAll(Arrays.asList(optionsHelper.getOptionValue(OPTION_USERS).split(",")));
        }
        if (optionsHelper.hasOption(OPTION_COLLECT_ONLY)) {
            this.collectOnly = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_COLLECT_ONLY));
        }
        String metadataUrl = this.getMetadataUrl(optionsHelper.getOptionValue(OPTION_DIR));
        this.config.setMetadataUrl(metadataUrl);
        this.resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)this.config);
        List managedUsers = NKylinUserManager.getInstance((KylinConfig)this.config).list();
        this.existsUserNames.addAll(managedUsers.stream().map(ManagedUser::getUsername).collect(Collectors.toList()));
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        if (this.printUsage(optionsHelper)) {
            return;
        }
        this.initOptionValues(optionsHelper);
        if (optionsHelper.hasOption(OPTION_USERS)) {
            String destUsername;
            String originUsername = optionsHelper.getOptionValue(OPTION_USERS);
            int index = originUsername.indexOf(58);
            if (index > 0) {
                destUsername = originUsername.substring(index + 1);
                originUsername = originUsername.substring(0, index);
            } else {
                destUsername = this.generateAvailableUsername(originUsername);
            }
            this.renameUserMap.put(originUsername, destUsername);
            NKylinUserManager kylinUserManager = NKylinUserManager.getInstance((KylinConfig)this.config);
            ManagedUser managedUser = kylinUserManager.get(originUsername);
            if (managedUser == null) {
                System.out.printf(Locale.ROOT, "user %s does not exists%n", originUsername);
                Unsafe.systemExit((int)1);
            }
        } else {
            this.collectDuplicateUser();
        }
        ArrayList<RenameEntity> renameEntities = new ArrayList<RenameEntity>();
        for (Map.Entry<String, String> entry : this.renameUserMap.entrySet()) {
            String originUsername = entry.getKey();
            String destUsername = entry.getValue();
            renameEntities.addAll(this.renameUser(originUsername, destUsername));
        }
        for (RenameEntity renameEntity : renameEntities) {
            System.out.println(renameEntity);
        }
        if (!this.collectOnly) {
            for (RenameEntity renameEntity : renameEntities) {
                renameEntity.updateMetadata();
            }
        }
    }

    private void collectDuplicateUser() {
        List managedUsers = NKylinUserManager.getInstance((KylinConfig)this.config).list();
        ConcurrentSkipListMap duplicateUserMap = managedUsers.stream().collect(Collectors.groupingByConcurrent(ManagedUser::getUsername, () -> new ConcurrentSkipListMap(String.CASE_INSENSITIVE_ORDER), Collectors.toList()));
        for (Map.Entry entry : duplicateUserMap.entrySet()) {
            List userList = ((List)entry.getValue()).stream().sorted(Comparator.comparingLong(RootPersistentEntity::getCreateTime)).collect(Collectors.toList());
            if (userList.size() == 1) continue;
            for (int i = 1; i < userList.size(); ++i) {
                ManagedUser managedUser = (ManagedUser)userList.get(i);
                String destUserName = this.generateAvailableUsername(managedUser.getUsername());
                this.renameUserMap.put(managedUser.getUsername(), destUserName);
            }
        }
    }

    private List<RenameEntity> renameUser(String oriUsername, String destUsername) {
        ArrayList<RenameEntity> results = new ArrayList<RenameEntity>();
        List allProjectInstanceList = NProjectManager.getInstance((KylinConfig)this.config).listAllProjects();
        NKylinUserManager kylinUserManager = NKylinUserManager.getInstance((KylinConfig)this.config);
        ManagedUser user = kylinUserManager.get(oriUsername);
        for (ProjectInstance projectInstance : allProjectInstanceList) {
            this.updateUserAcl(oriUsername, destUsername, projectInstance).ifPresent(results::add);
            this.updateProjectAcl(oriUsername, destUsername, projectInstance).ifPresent(results::add);
            this.updateSavedQueries(oriUsername, destUsername, projectInstance).ifPresent(results::add);
            this.updateProjectOwner(oriUsername, destUsername, projectInstance).ifPresent(results::add);
            results.addAll(this.updateModelOwner(oriUsername, destUsername, projectInstance));
        }
        String oriResourcePath = "/_global/user/" + user.getUsername();
        user.setUsername(destUsername);
        String destResourcePath = "/_global/user/" + destUsername;
        results.add(new RenameEntity(oriResourcePath, destResourcePath, (RootPersistentEntity)user, ManagedUser.class));
        return results;
    }

    private Optional<RenameEntity> updateUserAcl(String oriUsername, String destUsername, ProjectInstance projectInstance) {
        Optional<RenameEntity> result = Optional.empty();
        String projectName = projectInstance.getName();
        AclTCRManager tcrManager = AclTCRManager.getInstance((KylinConfig)this.config, (String)projectName);
        AclTCR aclTCR = tcrManager.getAclTCR(oriUsername, true);
        if (aclTCR != null) {
            String oriUserAclPath = String.format(Locale.ROOT, "/%s/acl/user/%s%s", projectName, oriUsername, ".json");
            String destUserAclPath = String.format(Locale.ROOT, "/%s/acl/user/%s%s", projectName, destUsername, ".json");
            result = Optional.of(new RenameEntity(oriUserAclPath, destUserAclPath));
        }
        return result;
    }

    private Optional<RenameEntity> updateProjectAcl(String oriUsername, String destUsername, ProjectInstance projectInstance) {
        Optional<RenameEntity> result = Optional.empty();
        String projectAclPath = String.format(Locale.ROOT, "/_global/acl/%s", projectInstance.getUuid());
        RawResource rs = this.resourceStore.getResource(projectAclPath);
        if (rs == null) {
            return result;
        }
        try (InputStream is = rs.getByteSource().openStream();){
            JsonNode aclJsonNode = (JsonNode)JsonUtil.readValue((InputStream)is, JsonNode.class);
            if (aclJsonNode.has("ownerInfo")) {
                JsonNode ownerInfo = aclJsonNode.get("ownerInfo");
                String sid = ownerInfo.get("sid").asText();
                boolean principal = ownerInfo.get("principal").asBoolean();
                if (principal && StringUtils.equals((String)sid, (String)oriUsername)) {
                    ((ObjectNode)ownerInfo).put("sid", destUsername);
                }
            }
            if (aclJsonNode.has("entries")) {
                ArrayNode entries = (ArrayNode)aclJsonNode.get("entries");
                for (JsonNode entry : entries) {
                    String p;
                    if (!entry.has("p") || !StringUtils.equals((String)(p = entry.get("p").asText()), (String)oriUsername)) continue;
                    ((ObjectNode)entry).put("p", destUsername);
                }
            }
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(buf);
            JsonUtil.writeValue((OutputStream)dout, (Object)aclJsonNode);
            dout.close();
            buf.close();
            ByteSource byteSource = ByteSource.wrap((byte[])buf.toByteArray());
            rs = new RawResource(projectAclPath, byteSource, System.currentTimeMillis(), rs.getMvcc());
        }
        catch (IOException e) {
            log.warn("read resource {} failed", (Object)projectAclPath);
        }
        result = Optional.of(new RenameEntity(projectAclPath, projectAclPath, rs));
        return result;
    }

    private Optional<RenameEntity> updateSavedQueries(String oriUsername, String destUsername, ProjectInstance projectInstance) {
        Optional<RenameEntity> result = Optional.empty();
        String originSavedQueriesPath = "/" + projectInstance.getName() + "/query/" + oriUsername + ".json";
        RawResource rs = this.resourceStore.getResource(originSavedQueriesPath);
        if (rs != null) {
            String destSavedQueriesPath = "/" + projectInstance.getName() + "/query/" + destUsername + ".json";
            result = Optional.of(new RenameEntity(originSavedQueriesPath, destSavedQueriesPath));
        }
        return result;
    }

    private Optional<RenameEntity> updateProjectOwner(String oriUsername, String destUsername, ProjectInstance projectInstance) {
        Optional<RenameEntity> result = Optional.empty();
        String owner = projectInstance.getOwner();
        if (StringUtils.equals((String)owner, (String)oriUsername)) {
            projectInstance.setOwner(destUsername);
            result = Optional.of(new RenameEntity(projectInstance.getResourcePath(), projectInstance.getResourcePath(), (RootPersistentEntity)projectInstance, ProjectInstance.class));
        }
        return result;
    }

    private List<RenameEntity> updateModelOwner(String oriUsername, String destUsername, ProjectInstance projectInstance) {
        ArrayList<RenameEntity> results = new ArrayList<RenameEntity>();
        NDataModelManager dataModelManager = NDataModelManager.getInstance((KylinConfig)this.config, (String)projectInstance.getName());
        List dataModels = dataModelManager.listAllModels().stream().filter(nDataModel -> StringUtils.equals((String)nDataModel.getOwner(), (String)oriUsername)).collect(Collectors.toList());
        for (NDataModel dataModel : dataModels) {
            dataModel.setOwner(destUsername);
            results.add(new RenameEntity(dataModel.getResourcePath(), dataModel.getResourcePath(), (RootPersistentEntity)dataModel, NDataModel.class));
        }
        return results;
    }

    private String generateAvailableUsername(String originUserName) {
        if (this.renameUserMap.get(originUserName) != null) {
            return this.renameUserMap.get(originUserName);
        }
        String destName = this.generateAvailableResourceName(originUserName, this.existsUserNames);
        this.existsUserNames.add(destName);
        this.renameUserMap.put(originUserName, destName);
        return destName;
    }

    private String generateAvailableResourceName(String originName, Set<String> existsResourceNames) {
        int suffix = 1;
        String destName;
        while (existsResourceNames.contains(destName = String.format(Locale.ROOT, "%s%s", originName, suffix))) {
            ++suffix;
        }
        return destName;
    }

    private String getMetadataUrl(String rootPath) {
        if (rootPath.startsWith("file://")) {
            rootPath = rootPath.replace("file://", "");
            return org.apache.commons.lang3.StringUtils.appendIfMissing((String)rootPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return org.apache.commons.lang3.StringUtils.appendIfMissing((String)rootPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    static {
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.withDescription((String)"Specify the directory to operator");
        OptionBuilder.isRequired((boolean)true);
        OPTION_DIR = OptionBuilder.create((String)"dir");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"username");
        OptionBuilder.withDescription((String)"Specify users (optional)");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)"user");
        OPTION_USERS = OptionBuilder.create((String)"u");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"true/false");
        OptionBuilder.withDescription((String)"collect only, show rename resource.(default true)");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)"collect-only");
        OPTION_COLLECT_ONLY = OptionBuilder.create((String)"collect");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"print help message.");
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)"help");
        OPTION_HELP = OptionBuilder.create((String)"h");
    }
}

