/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.upgrade;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.kyligence.kap.guava20.shaded.common.io.ByteSource;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.execution.NExecutableManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateJobTool
extends ExecutableApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrateJobTool.class);
    private static final Option OPTION_HELP = OptionBuilder.getInstance().hasArg(false).withDescription("print help message.").isRequired(false).withLongOpt("help").create("h");
    private static final Option OPTION_DIR = OptionBuilder.getInstance().hasArg().withArgName("dir").withDescription("Specify the directory to operator").isRequired(true).create("dir");
    private static final Map<String, String> JOB_TYPE_HANDLER_MAP = new HashMap<String, String>();
    private KylinConfig config = KylinConfig.getInstanceFromEnv();
    private ResourceStore resourceStore;

    public static void main(String[] args) {
        MigrateJobTool tool = new MigrateJobTool();
        tool.execute(args);
        System.out.println("Migrate job finished.");
        Unsafe.systemExit((int)0);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_DIR);
        options.addOption(OPTION_HELP);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        if (this.printUsage(optionsHelper)) {
            return;
        }
        String metadataUrl = this.getMetadataUrl(optionsHelper.getOptionValue(OPTION_DIR));
        this.config.setMetadataUrl(metadataUrl);
        this.resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)this.config);
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)this.config);
        for (ProjectInstance project : projectManager.listAllProjects()) {
            this.updateExecute(project);
        }
    }

    private void updateExecute(ProjectInstance projectInstance) {
        NExecutableManager executableManager = NExecutableManager.getInstance((KylinConfig)this.config, (String)projectInstance.getName());
        List executeJobs = executableManager.getAllExecutables().stream().filter(executable -> JobTypeEnum.INC_BUILD == executable.getJobType() || JobTypeEnum.INDEX_BUILD == executable.getJobType() || JobTypeEnum.SUB_PARTITION_BUILD == executable.getJobType() || JobTypeEnum.INDEX_REFRESH == executable.getJobType() || JobTypeEnum.SUB_PARTITION_REFRESH == executable.getJobType() || JobTypeEnum.INDEX_MERGE == executable.getJobType()).filter(executable -> ExecutableState.RUNNING == executable.getStatus() || ExecutableState.ERROR == executable.getStatus() || ExecutableState.PAUSED == executable.getStatus()).collect(Collectors.toList());
        for (AbstractExecutable executeJob : executeJobs) {
            String executePath = "/" + projectInstance.getName() + "/execute" + "/" + executeJob.getId();
            RawResource rs = this.resourceStore.getResource(executePath);
            if (rs == null) continue;
            try {
                InputStream in = rs.getByteSource().openStream();
                Throwable throwable = null;
                try {
                    String name;
                    String handlerType;
                    JsonNode executeNode = (JsonNode)JsonUtil.readValue((InputStream)in, JsonNode.class);
                    if (executeNode.has("name") && (handlerType = JOB_TYPE_HANDLER_MAP.get(name = executeNode.get("name").textValue())) != null && !executeNode.has("handler_type")) {
                        ((ObjectNode)executeNode).put("handler_type", handlerType);
                    }
                    this.addUpdateMetadataTask(executeNode);
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    DataOutputStream dout = new DataOutputStream(buf);
                    JsonUtil.writeValue((OutputStream)dout, (Object)executeNode);
                    dout.close();
                    buf.close();
                    ByteSource byteSource = ByteSource.wrap((byte[])buf.toByteArray());
                    rs = new RawResource(executePath, byteSource, System.currentTimeMillis(), rs.getMvcc() + 1L);
                    System.out.println("update execute " + executePath);
                    this.resourceStore.getMetadataStore().putResource(rs, null, -1L);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Exception e) {
                log.warn("read {} failed", (Object)executePath, (Object)e);
            }
        }
    }

    private void addUpdateMetadataTask(JsonNode executeNode) {
        ArrayNode tasks;
        if (executeNode.has("tasks") && (tasks = (ArrayNode)executeNode.get("tasks")).size() == 2) {
            ObjectNode outputNode;
            ObjectNode taskNode = (ObjectNode)tasks.get(0).deepCopy();
            String uuid = taskNode.get("uuid").textValue().replace("_00", "_02");
            taskNode.put("uuid", uuid);
            taskNode.put("name", "Update Metadata");
            taskNode.put("type", "org.apache.kylin.engine.spark.job.NSparkUpdateMetadataStep");
            if (taskNode.has("params")) {
                ObjectNode paramsNode = (ObjectNode)taskNode.get("params");
                paramsNode.remove("distMetaUrl");
                paramsNode.remove("className");
                paramsNode.remove("outputMetaUrl");
            }
            if (taskNode.has("output") && (outputNode = (ObjectNode)taskNode.get("output")).has("status")) {
                outputNode.put("status", "READY");
            }
            tasks.add((JsonNode)taskNode);
        }
    }

    private boolean printUsage(OptionsHelper optionsHelper) {
        boolean help = optionsHelper.hasOption(OPTION_HELP);
        if (help) {
            optionsHelper.printUsage(((Object)((Object)this)).getClass().getName(), this.getOptions());
        }
        return help;
    }

    private String getMetadataUrl(String rootPath) {
        if (rootPath.startsWith("file://")) {
            rootPath = rootPath.replace("file://", "");
            return StringUtils.appendIfMissing((String)rootPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return StringUtils.appendIfMissing((String)rootPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    static {
        JOB_TYPE_HANDLER_MAP.put("INDEX_BUILD", "org.apache.kylin.engine.spark.job.ExecutableAddCuboidHandler");
        JOB_TYPE_HANDLER_MAP.put("INC_BUILD", "org.apache.kylin.engine.spark.job.ExecutableAddSegmentHandler");
        JOB_TYPE_HANDLER_MAP.put("INDEX_MERGE", "org.apache.kylin.engine.spark.job.ExecutableMergeOrRefreshHandler");
        JOB_TYPE_HANDLER_MAP.put("INDEX_REFRESH", "org.apache.kylin.engine.spark.job.ExecutableMergeOrRefreshHandler");
    }
}

