/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.upgrade;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.tool.util.MetadataUtil;
import org.apache.kylin.tool.util.ScreenPrintUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckProjectModeCLI
extends ExecutableApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckProjectModeCLI.class);
    private static final Option OPTION_METADATA_DIR = OptionBuilder.getInstance().hasArg().withArgName("metadata_dir").withDescription("metadata dir.").isRequired(true).withLongOpt("metadata_dir").create("d");
    private static final Option OPTION_EXEC = OptionBuilder.getInstance().hasArg(false).withArgName("exec").withDescription("exec the upgrade.").isRequired(false).withLongOpt("exec").create("e");

    public static void main(String[] args) {
        CheckProjectModeCLI updateProjectModelCLI = new CheckProjectModeCLI();
        try {
            updateProjectModelCLI.execute(args);
        }
        catch (RuntimeException e) {
            log.error("Failed to exec CheckProjectModeCLI", (Throwable)e);
            ScreenPrintUtil.systemExitWhenMainThread(1);
        }
        log.info("Upgrade project mode finished!");
        ScreenPrintUtil.systemExitWhenMainThread(0);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_METADATA_DIR);
        options.addOption(OPTION_EXEC);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String metadataUrl = MetadataUtil.getMetadataUrl(optionsHelper.getOptionValue(OPTION_METADATA_DIR));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)metadataUrl));
        KylinConfig systemKylinConfig = KylinConfig.getInstanceFromEnv();
        systemKylinConfig.setMetadataUrl(metadataUrl);
        ArrayList projectInstanceList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)projectInstanceList)) {
            ScreenPrintUtil.printlnRed(String.format(Locale.ROOT, "found %d projects %s need to be changed to AI augmented mode.", projectInstanceList.size(), Arrays.toString(projectInstanceList.stream().map(ProjectInstance::getName).toArray())));
            if (optionsHelper.hasOption(OPTION_EXEC)) {
                throw new RuntimeException("Smart mode project exist, stop upgrade.");
            }
        } else {
            ScreenPrintUtil.printlnGreen("found 0 projects need to be changed.");
            if (optionsHelper.hasOption(OPTION_EXEC)) {
                ScreenPrintUtil.printlnGreen("projects mode upgrade succeeded.");
            }
        }
        log.info("Succeed to check project mode.");
    }
}

