/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.setup;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.kylin.cluster.SchedulerInfoCmdHelper;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.BufferedLogger;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.ShellException;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.tool.setup.YarnResourceInfoTool;
import org.apache.kylin.tool.util.HadoopConfExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KapGetClusterInfo {
    private static final Logger logger = LoggerFactory.getLogger(KapGetClusterInfo.class);
    private static final String YARN_METRICS_SUFFIX = "/ws/v1/cluster/metrics";
    private static final String AVAILABLE_VIRTUAL_CORE = "availableVirtualCores";
    private static final String AVAILABLE_MEMORY = "availableMB";
    private String fileName = "cluster.info";
    private String queueName = "";
    private Configuration configuration = null;
    private String yarnMasterUrlBase;
    private Map<String, Integer> clusterMetricsMap = new HashMap<String, Integer>();

    public KapGetClusterInfo() {
    }

    public KapGetClusterInfo(String fileName) {
        this.fileName = fileName;
    }

    public KapGetClusterInfo(String fileName, String queue) {
        this.fileName = fileName;
        this.queueName = queue;
        String confPath = System.getProperty("kylin.hadoop.conf.dir", HadoopUtil.getHadoopConfDir());
        this.configuration = new Configuration();
        this.configuration.addResource(new Path(confPath + File.separator + "core-site.xml"));
        this.configuration.addResource(new Path(confPath + File.separator + "hdfs-site.xml"));
        this.configuration.addResource(new Path(confPath + File.separator + "yarn-site.xml"));
    }

    public static void main(String[] args) throws IOException, ShellException, YarnException {
        if (args.length < 1) {
            logger.error("Usage: KapGetClusterInfo fileName [queue]");
            Unsafe.systemExit((int)1);
        }
        KapGetClusterInfo kapSetupConcurrency = args.length >= 2 ? new KapGetClusterInfo(args[0], args[1]) : new KapGetClusterInfo(args[0]);
        kapSetupConcurrency.getYarnMetrics();
        kapSetupConcurrency.saveToFile();
        Unsafe.systemExit((int)0);
    }

    public void extractYarnMasterHost() {
        Matcher m;
        Pattern pattern = Pattern.compile("(http://)([^:]*):([^/])*.*");
        if (this.yarnMasterUrlBase != null && (m = pattern.matcher(this.yarnMasterUrlBase)).matches()) {
            return;
        }
        this.yarnMasterUrlBase = this.configuration != null ? HadoopConfExtractor.extractYarnMasterUrl(this.configuration) : HadoopConfExtractor.extractYarnMasterUrl(HadoopUtil.getCurrentConfiguration());
    }

    public void getYarnMetrics() throws IOException, ShellException, YarnException {
        JsonNode clusterMetrics;
        this.extractYarnMasterHost();
        String url = this.yarnMasterUrlBase + YARN_METRICS_SUFFIX;
        String command = "curl -s -k --negotiate -u : " + url;
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        BufferedLogger patternedLogger = new BufferedLogger(logger);
        String response = config.getCliCommandExecutor().execute(command, (org.apache.kylin.common.util.Logger)patternedLogger).getCmd();
        logger.info("yarn metrics response: {}", (Object)response);
        Map<String, Integer> clusterMetricsInfos = null;
        if (response == null) {
            throw new IllegalStateException("Cannot get yarn metrics with url: " + this.yarnMasterUrlBase + YARN_METRICS_SUFFIX);
        }
        try {
            clusterMetrics = new ObjectMapper().readTree(response).path("clusterMetrics");
        }
        catch (Exception e) {
            logger.warn("Failed to get clusterMetrics from cluster.", (Throwable)e);
            try {
                clusterMetrics = new ObjectMapper().readTree(SchedulerInfoCmdHelper.metricsInfo()).path("clusterMetrics");
            }
            catch (IOException | RuntimeException exception) {
                logger.warn("Failed to get clusterMetrics from cluster via SchedulerInfoCmdHelper.", (Throwable)exception);
                YarnResourceInfoTool yarnClusterMetrics = new YarnResourceInfoTool();
                clusterMetricsInfos = this.queueName.equals("") ? yarnClusterMetrics.getYarnResourceInfo() : yarnClusterMetrics.getYarnResourceInfoByQueueName(this.queueName);
                if (clusterMetricsInfos == null || clusterMetricsInfos.isEmpty()) {
                    logger.error("The queue:{} is invalid, please check kylin.properties", (Object)this.queueName);
                    Unsafe.systemExit((int)101);
                    return;
                }
                this.clusterMetricsMap.put(AVAILABLE_VIRTUAL_CORE, clusterMetricsInfos.get(AVAILABLE_VIRTUAL_CORE));
                this.clusterMetricsMap.put(AVAILABLE_MEMORY, clusterMetricsInfos.get(AVAILABLE_MEMORY));
                return;
            }
        }
        this.clusterMetricsMap.put(AVAILABLE_VIRTUAL_CORE, clusterMetrics.path(AVAILABLE_VIRTUAL_CORE).intValue());
        this.clusterMetricsMap.put(AVAILABLE_MEMORY, clusterMetrics.path(AVAILABLE_MEMORY).intValue());
    }

    public void saveToFile() throws IOException {
        File dest = new File(this.fileName);
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, Integer> element : this.clusterMetricsMap.entrySet()) {
            String input = element.getKey() + "=" + element.getValue();
            input = input + "\n";
            buf.append(input);
        }
        FileUtils.writeStringToFile((File)dest, (String)buf.toString(), (Charset)Charset.defaultCharset());
    }
}

