/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.routine;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.helper.MetadataToolHelper;
import org.apache.kylin.helper.RoutineToolHelper;
import org.apache.kylin.metadata.epoch.EpochManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.tool.MaintainModeTool;
import org.apache.kylin.tool.util.ToolMainWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutineTool
extends ExecutableApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoutineTool.class);
    private static final Option OPTION_CLEANUP_METADATA = new Option("m", "metadata", false, "cleanup metadata garbage after check.");
    private static final Option OPTION_CLEANUP = new Option("c", "cleanup", false, "cleanup hdfs garbage after check.");
    private static final Option OPTION_PROJECTS = new Option("p", "projects", true, "specify projects to cleanup.");
    private static final Option OPTION_REQUEST_FS_RATE = new Option("r", "rate", true, "specify request fs rate.");
    private static final Option OPTION_RETRY_TIMES = new Option("t", "retryTimes", true, "specify retry times.");
    private static final Option OPTION_HELP = new Option("h", "help", false, "print help message.");
    private boolean storageCleanup;
    private boolean metadataCleanup;
    private String[] projects = new String[0];
    private int retryTimes;
    private double requestFSRate;
    private MetadataToolHelper helper = new MetadataToolHelper();

    public static void main(String[] args) {
        ToolMainWrapper.wrap(args, () -> {
            RoutineTool tool = new RoutineTool();
            tool.execute(args);
        });
        Unsafe.systemExit((int)0);
    }

    public static void deleteRawRecItems() {
        RoutineToolHelper.deleteRawRecItems();
    }

    public static void cleanQueryHistories() {
        RoutineToolHelper.cleanQueryHistories();
    }

    public static void cleanStreamingStats() {
        RoutineToolHelper.cleanStreamingStats();
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_CLEANUP_METADATA);
        options.addOption(OPTION_CLEANUP);
        options.addOption(OPTION_PROJECTS);
        options.addOption(OPTION_REQUEST_FS_RATE);
        options.addOption(OPTION_RETRY_TIMES);
        options.addOption(OPTION_HELP);
        return options;
    }

    protected final List<String> getProjectsToCleanup() {
        if (this.getProjects().length != 0) {
            return Arrays.asList(this.getProjects());
        }
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        List instances = NProjectManager.getInstance((KylinConfig)kylinConfig).listAllProjects();
        return instances.stream().map(ProjectInstance::getName).collect(Collectors.toList());
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        if (this.printUsage(optionsHelper)) {
            return;
        }
        this.initOptionValues(optionsHelper);
        System.out.println("Start to cleanup metadata");
        List<String> projectsToCleanup = this.getProjectsToCleanup();
        MaintainModeTool maintainModeTool = new MaintainModeTool("routine tool");
        maintainModeTool.init();
        maintainModeTool.markEpochs();
        if (EpochManager.getInstance().isMaintenanceMode()) {
            Runtime.getRuntime().addShutdownHook(new Thread(maintainModeTool::releaseEpochs));
        }
        this.doCleanup(projectsToCleanup);
    }

    private void doCleanup(List<String> projectsToCleanup) {
        try {
            if (this.metadataCleanup) {
                RoutineToolHelper.cleanMeta(projectsToCleanup);
            }
            this.cleanStorage();
        }
        catch (Exception e) {
            log.error("Failed to execute routintool", (Throwable)e);
        }
    }

    public void cleanStorage() {
        this.helper.cleanStorage(this.storageCleanup, Arrays.asList(this.projects), this.requestFSRate, this.retryTimes);
    }

    protected boolean printUsage(OptionsHelper optionsHelper) {
        boolean help = optionsHelper.hasOption(OPTION_HELP);
        if (help) {
            optionsHelper.printUsage(((Object)((Object)this)).getClass().getName(), this.getOptions());
        }
        return help;
    }

    protected void initOptionValues(OptionsHelper optionsHelper) {
        this.storageCleanup = optionsHelper.hasOption(OPTION_CLEANUP);
        this.metadataCleanup = optionsHelper.hasOption(OPTION_CLEANUP_METADATA);
        if (optionsHelper.hasOption(OPTION_PROJECTS)) {
            this.projects = optionsHelper.getOptionValue(OPTION_PROJECTS).split(",");
        }
        if (optionsHelper.hasOption(OPTION_REQUEST_FS_RATE)) {
            this.requestFSRate = Double.parseDouble(optionsHelper.getOptionValue(OPTION_REQUEST_FS_RATE));
        }
        if (optionsHelper.hasOption(OPTION_RETRY_TIMES)) {
            this.retryTimes = Integer.parseInt(optionsHelper.getOptionValue(OPTION_RETRY_TIMES));
        }
        log.info("RoutineTool has option metadata cleanup: " + this.metadataCleanup + " storage cleanup: " + this.storageCleanup + (this.projects.length > 0 ? " projects: " + optionsHelper.getOptionValue(OPTION_PROJECTS) : "") + " Request FileSystem rate: " + this.requestFSRate + " Retry Times: " + this.retryTimes);
        System.out.println("RoutineTool has option metadata cleanup: " + this.metadataCleanup + " storage cleanup: " + this.storageCleanup + (this.projects.length > 0 ? " projects: " + optionsHelper.getOptionValue(OPTION_PROJECTS) : "") + " Request FileSystem rate: " + this.requestFSRate + " Retry Times: " + this.retryTimes);
    }

    @Generated
    public boolean isStorageCleanup() {
        return this.storageCleanup;
    }

    @Generated
    public boolean isMetadataCleanup() {
        return this.metadataCleanup;
    }

    @Generated
    public String[] getProjects() {
        return this.projects;
    }

    @Generated
    public int getRetryTimes() {
        return this.retryTimes;
    }

    @Generated
    public double getRequestFSRate() {
        return this.requestFSRate;
    }

    @Generated
    public MetadataToolHelper getHelper() {
        return this.helper;
    }
}

