/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.obf;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.kylin.tool.obf.AbstractObfuscator;
import org.apache.kylin.tool.obf.MappingRecorder;
import org.apache.kylin.tool.obf.ObfLevel;
import org.apache.kylin.tool.obf.ResultRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileObfuscator
extends AbstractObfuscator {
    protected static final Logger logger = LoggerFactory.getLogger((String)"obfuscation");

    FileObfuscator(ObfLevel level, MappingRecorder recorder, ResultRecorder resultRecorder) {
        super(level, recorder, resultRecorder);
    }

    public void obfuscate(File orig, FileFilter fileFilter) {
        if (orig == null || !orig.exists()) {
            return;
        }
        if (orig.isDirectory()) {
            this.obfuscateDirectory(orig, fileFilter);
        } else {
            this.obfuscateFile(orig);
        }
    }

    private void obfuscateDirectory(File directory, FileFilter fileFilter) {
        File[] files;
        File[] fileArray = files = fileFilter == null ? directory.listFiles() : directory.listFiles(fileFilter);
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.obfuscateDirectory(f, fileFilter);
                    continue;
                }
                this.obfuscateFile(f);
            }
        }
    }

    protected void obfuscateFile(File orig) {
        if (orig == null) {
            return;
        }
        String path = orig.getAbsolutePath();
        logger.info("Start to process file: {}", (Object)path);
        try {
            switch (this.level) {
                case OBF: {
                    this.doObfuscateFile(orig);
                    break;
                }
                case RAW: {
                    break;
                }
            }
            logger.info("{} process successfully", (Object)path);
            this.resultRecorder.addSuccessFile(path);
        }
        catch (Exception e) {
            logger.warn("{} processed failed", (Object)path);
            this.resultRecorder.addFailedFile(path);
        }
    }

    abstract void doObfuscateFile(File var1) throws IOException;
}

