/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.metadata;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.transaction.TransactionException;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckMetadataAccessCLI {
    protected static final Logger logger = LoggerFactory.getLogger(CheckMetadataAccessCLI.class);

    public static void main(String[] args) {
        StorageURL metadataUrl = KylinConfig.getInstanceFromEnv().getMetadataUrl();
        if (metadataUrl.metadataLengthIllegal()) {
            logger.info("the maximum length of metadata_name allowed is {}", (Object)33);
            Unsafe.systemExit((int)1);
        }
        CheckMetadataAccessCLI cli = new CheckMetadataAccessCLI();
        if (args.length != 1) {
            logger.info("Usage: CheckMetadataAccessCLI <repetition>");
            Unsafe.systemExit((int)1);
        }
        for (long repetition = Long.parseLong(args[0]); repetition > 0L; --repetition) {
            if (cli.testAccessMetadata()) continue;
            logger.error("Test failed.");
            Unsafe.systemExit((int)1);
        }
        logger.info("Test succeed.");
        Unsafe.systemExit((int)0);
    }

    public boolean testAccessMetadata() {
        String projectName = RandomUtil.randomUUIDStr();
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)config);
        logger.info("Start to test. Test metastore is: " + config.getMetadataUrl().toString());
        try {
            store.collectResourceRecursively("/_global/project", ".json");
        }
        catch (Exception e) {
            logger.error("Connection test failed." + e.getCause());
            return false;
        }
        try {
            UnitOfWork.doInTransactionWithRetry(() -> {
                NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).createProject(projectName, "test", "This is a test project", null);
                return null;
            }, (String)"_global");
        }
        catch (TransactionException e) {
            logger.error("Creation test failed." + e.getMessage());
            return false;
        }
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)config);
        if (projectManager.getProject(projectName) == null) {
            logger.error("Creation test failed.");
            return false;
        }
        try {
            UnitOfWork.doInTransactionWithRetry(() -> {
                ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(projectName);
                NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).updateProject(projectInstance, projectName, "Still a test project", null);
                return null;
            }, (String)projectName);
        }
        catch (TransactionException e) {
            logger.error("Update test failed." + e.getMessage());
            this.clean(store, ProjectInstance.concatResourcePath((String)projectName));
            return false;
        }
        try {
            UnitOfWork.doInTransactionWithRetry(() -> {
                NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).forceDropProject(projectName);
                return null;
            }, (String)projectName);
        }
        catch (TransactionException e) {
            this.clean(store, ProjectInstance.concatResourcePath((String)projectName));
            logger.error("Deletion test failed");
            return false;
        }
        return true;
    }

    private void clean(ResourceStore store, String path) {
        try {
            UnitOfWork.doInTransactionWithRetry(() -> {
                store.deleteResource(path);
                return null;
            }, (String)path.split("/")[0]);
        }
        catch (TransactionException e) {
            throw new RuntimeException("Failed to cleanup test metadata, it will remain in the resource store: " + store.getConfig().getMetadataUrl(), e);
        }
    }
}

