/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.hadoop;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.Unsafe;

public class CheckHadoopConfDir {
    public static final String CHECKENV_REPORT_PFX = ">   ";

    public static void main(String[] args) throws Exception {
        if (1 != args.length) {
            CheckHadoopConfDir.usage();
            Unsafe.systemExit((int)1);
        }
        File hadoopConfDir = new File(args[0]).getCanonicalFile();
        System.out.println("Checking hadoop config dir " + hadoopConfDir);
        if (!hadoopConfDir.exists()) {
            System.err.println("ERROR: Hadoop config dir '" + hadoopConfDir + "' does not exist");
            Unsafe.systemExit((int)1);
        }
        if (!hadoopConfDir.isDirectory()) {
            System.err.println("ERROR: Hadoop config dir '" + hadoopConfDir + "' is not a directory");
            Unsafe.systemExit((int)1);
        }
        LocalFileSystem localfs = CheckHadoopConfDir.getLocalFSAndHitUGIForTheFirstTime();
        Configuration conf = new Configuration(false);
        for (File f : hadoopConfDir.listFiles()) {
            if (!f.getName().endsWith("-site.xml")) continue;
            Path p = new Path(f.toString());
            p = localfs.makeQualified(p);
            conf.addResource(p);
            System.out.println("Load " + p);
        }
        conf.reloadConfiguration();
        boolean shortcircuit = conf.getBoolean("dfs.client.read.shortcircuit", false);
        if (!shortcircuit) {
            System.out.println(">   WARN: 'dfs.client.read.shortcircuit' is not enabled which could impact query performance. Check " + hadoopConfDir + "/hdfs-site.xml");
        }
        Unsafe.systemExit((int)0);
    }

    private static LocalFileSystem getLocalFSAndHitUGIForTheFirstTime() {
        try {
            return FileSystem.getLocal((Configuration)new Configuration());
        }
        catch (IOException e) {
            System.err.println("ERROR: Hadoop security exception? Seems the classpath is not setup propertly regarding Hadoop security.");
            System.err.println("Detailed error message: " + e.getMessage());
            Unsafe.systemExit((int)1);
            return null;
        }
    }

    private static void usage() {
        System.out.println("Usage: CheckHadoopConfDir hadoopConfDir");
    }
}

