/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.daemon.handler;

import com.google.common.base.Preconditions;
import javax.crypto.SecretKey;
import org.apache.kylin.common.util.SecretKeyUtil;
import org.apache.kylin.tool.daemon.CheckResult;
import org.apache.kylin.tool.daemon.CheckStateHandler;
import org.apache.kylin.tool.daemon.HandleResult;
import org.apache.kylin.tool.daemon.HandleStateEnum;
import org.apache.kylin.tool.daemon.ServiceOpLevelEnum;
import org.apache.kylin.tool.daemon.Worker;
import org.apache.kylin.tool.util.ToolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCheckStateHandler
extends Worker
implements CheckStateHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCheckStateHandler.class);

    public boolean upGradeQueryService() {
        return this.opQueryService(ServiceOpLevelEnum.QUERY_UP_GRADE);
    }

    public boolean downGradeQueryService() {
        return this.opQueryService(ServiceOpLevelEnum.QUERY_DOWN_GRADE);
    }

    private boolean opQueryService(ServiceOpLevelEnum opLevelEnum) {
        try {
            if (null == AbstractCheckStateHandler.getKgSecretKey()) {
                this.setKgSecretKey(SecretKeyUtil.readKGSecretKeyFromFile());
            }
            Preconditions.checkNotNull((Object)AbstractCheckStateHandler.getKgSecretKey(), (Object)"kg secret key is null!");
            if (null == AbstractCheckStateHandler.getKePid()) {
                this.setKEPid(ToolUtil.getKylinPid());
            }
            byte[] encryptedToken = SecretKeyUtil.generateEncryptedTokenWithPid((SecretKey)AbstractCheckStateHandler.getKgSecretKey(), (String)AbstractCheckStateHandler.getKePid());
            AbstractCheckStateHandler.getRestClient().downOrUpGradeKE(opLevelEnum.getOpType(), encryptedToken);
        }
        catch (Exception e) {
            logger.error("Failed to operate service {}", (Object)opLevelEnum.getOpType(), (Object)e);
            return false;
        }
        return true;
    }

    abstract HandleResult doHandle(CheckResult var1);

    @Override
    public HandleResult handle(CheckResult checkResult) {
        HandleResult result;
        logger.info("Handler: [{}], Health Checker: [{}] check result is {}, message: {}", new Object[]{this.getClass().getName(), checkResult.getCheckerName(), checkResult.getCheckState(), checkResult.getReason()});
        try {
            result = this.doHandle(checkResult);
            logger.info("Handler: [{}] handle the check result success ...", (Object)this.getClass().getName());
        }
        catch (Exception e) {
            logger.error("Failed to do handle!", (Throwable)e);
            result = new HandleResult(HandleStateEnum.HANDLE_FAILED);
        }
        if (null == result) {
            result = new HandleResult(HandleStateEnum.HANDLE_WARN);
        }
        if (null == result.getHandleState()) {
            result.setHandleState(HandleStateEnum.HANDLE_WARN);
        }
        return result;
    }
}

