/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.daemon;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.Unsafe;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.ExecutorServiceUtil;
import org.apache.kylin.tool.daemon.CheckResult;
import org.apache.kylin.tool.daemon.CheckStateEnum;
import org.apache.kylin.tool.daemon.CheckStateHandler;
import org.apache.kylin.tool.daemon.HandleResult;
import org.apache.kylin.tool.daemon.HandleStateEnum;
import org.apache.kylin.tool.daemon.HealthChecker;
import org.apache.kylin.tool.daemon.handler.DownGradeStateHandler;
import org.apache.kylin.tool.daemon.handler.NormalStateHandler;
import org.apache.kylin.tool.daemon.handler.RestartStateHandler;
import org.apache.kylin.tool.daemon.handler.SuicideStateHandler;
import org.apache.kylin.tool.daemon.handler.UpGradeStateHandler;
import org.apache.kylin.tool.daemon.handler.WarnStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KapGuardian {
    private static final Logger logger = LoggerFactory.getLogger(KapGuardian.class);
    private List<HealthChecker> healthCheckers = Lists.newArrayList();
    private Map<CheckStateEnum, List<CheckStateHandler>> checkStateHandlersMap = new EnumMap<CheckStateEnum, List<CheckStateHandler>>(CheckStateEnum.class);
    private KylinConfig config = KylinConfig.getInstanceFromEnv();
    private ScheduledExecutorService executor;

    public KapGuardian() {
        if (!this.config.isGuardianEnabled()) {
            logger.warn("Do not enable to start Guardian Process, exit 0!");
            Unsafe.systemExit((int)0);
        }
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("ke-guardian-process").build());
        this.loadCheckers();
        this.initCheckStateHandler();
    }

    public static void main(String[] args) {
        logger.info("Guardian Process starting...");
        try {
            KapGuardian kapGuardian = new KapGuardian();
            kapGuardian.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                logger.info("Guardian Process of KE instance port[{}] KYLIN_HOME[{}] stopped", (Object)kapGuardian.getServerPort(), (Object)kapGuardian.getKylinHome());
                kapGuardian.stop();
            }));
        }
        catch (Exception e) {
            logger.info("Guardian Process start failed", (Throwable)e);
            Unsafe.systemExit((int)1);
        }
        logger.info("Guardian Process started...");
    }

    public void start() {
        this.executor.scheduleWithFixedDelay(() -> {
            try {
                logger.info("Guardian Process: start to run health checkers ...");
                for (HealthChecker healthChecker : this.healthCheckers) {
                    CheckResult checkResult = healthChecker.check();
                    List<CheckStateHandler> handlers = this.checkStateHandlersMap.get(checkResult.getCheckState());
                    if (CollectionUtils.isEmpty(handlers)) continue;
                    for (CheckStateHandler handler : handlers) {
                        HandleResult handleResult = handler.handle(checkResult);
                        if (HandleStateEnum.STOP_CHECK != handleResult.getHandleState()) continue;
                        logger.info("Guardian Process: state [{}] found, stop check!", (Object)HandleStateEnum.STOP_CHECK);
                        return;
                    }
                }
                logger.info("Guardian Process: health check finished ...");
            }
            catch (Exception e) {
                logger.info("Guardian Process: failed to run health check!", (Throwable)e);
            }
        }, this.config.getGuardianCheckInitDelay(), this.config.getGuardianCheckInterval(), TimeUnit.SECONDS);
    }

    public void stop() {
        if (null != this.executor && !this.executor.isShutdown()) {
            ExecutorServiceUtil.forceShutdown((ExecutorService)this.executor);
        }
    }

    public void loadCheckers() {
        String healthCheckersStr = this.config.getGuardianHealthCheckers();
        if (StringUtils.isNotBlank((String)healthCheckersStr)) {
            TreeMap<Integer, ArrayList> checkerMap = new TreeMap<Integer, ArrayList>();
            for (String healthCheckerClassName : healthCheckersStr.split(",")) {
                if (!StringUtils.isNotBlank((String)healthCheckerClassName.trim())) continue;
                HealthChecker healthChecker = (HealthChecker)ClassUtil.newInstance((String)healthCheckerClassName);
                if (!checkerMap.containsKey(healthChecker.getPriority())) {
                    checkerMap.put(healthChecker.getPriority(), Lists.newArrayList());
                }
                ((List)checkerMap.get(healthChecker.getPriority())).add(healthChecker);
            }
            this.healthCheckers.addAll(checkerMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        }
    }

    public void initCheckStateHandler() {
        this.checkStateHandlersMap.put(CheckStateEnum.RESTART, Lists.newArrayList((Object[])new CheckStateHandler[]{new RestartStateHandler()}));
        this.checkStateHandlersMap.put(CheckStateEnum.NORMAL, Lists.newArrayList((Object[])new CheckStateHandler[]{new NormalStateHandler()}));
        this.checkStateHandlersMap.put(CheckStateEnum.WARN, Lists.newArrayList((Object[])new CheckStateHandler[]{new WarnStateHandler()}));
        this.checkStateHandlersMap.put(CheckStateEnum.SUICIDE, Lists.newArrayList((Object[])new CheckStateHandler[]{new SuicideStateHandler()}));
        this.checkStateHandlersMap.put(CheckStateEnum.QUERY_UPGRADE, Lists.newArrayList((Object[])new CheckStateHandler[]{new UpGradeStateHandler()}));
        this.checkStateHandlersMap.put(CheckStateEnum.QUERY_DOWNGRADE, Lists.newArrayList((Object[])new CheckStateHandler[]{new DownGradeStateHandler()}));
        this.checkStateHandlersMap.put(CheckStateEnum.OTHER, Lists.newArrayList());
    }

    public String getServerPort() {
        return this.config.getServerPort();
    }

    public String getKylinHome() {
        return KylinConfig.getKylinHome();
    }
}

