/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.exception.code.ErrorCodeTool;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.recommendation.candidate.JdbcRawRecStore;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.tool.util.ScreenPrintUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecCandidateTool
extends ExecutableApplication {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final Option OPERATE_BACKUP = OptionBuilder.getInstance().withDescription("Backup rec candidate to local path").isRequired(false).create("backup");
    private static final Option OPTION_DIR = OptionBuilder.getInstance().hasArg().withArgName("DIRECTORY_PATH").withDescription("Specify the target directory for backup and restore").isRequired(false).create("dir");
    private static final Option OPTION_MODEL_ID = OptionBuilder.getInstance().hasArg().withArgName("MODEL_ID").withDescription("Specify model id for backup (optional)").isRequired(false).create("model");
    private static final Option OPTION_PROJECT = OptionBuilder.getInstance().hasArg().withArgName("PROJECT_NAME").withDescription("Specify project name for backup (optional)").isRequired(false).create("project");
    private static final Option OPTION_TABLE = OptionBuilder.getInstance().hasArg().withArgName("TABLE_NAME").withDescription("Specify the table for restore (optional)").isRequired(false).create("table");
    private final Options options;
    private final KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();

    public RecCandidateTool() {
        this.options = new Options();
        this.initOptions();
    }

    public static void main(String[] args) {
        RecCandidateTool tool = new RecCandidateTool();
        try {
            tool.execute(args);
        }
        catch (Exception e) {
            ScreenPrintUtil.printlnRed("Rec candidate task failed. Detailed Message is at ${KYLIN_HOME}/logs/shell.stderr");
            logger.error("Rec candidate", (Throwable)e);
            Unsafe.systemExit((int)1);
        }
        ScreenPrintUtil.printlnGreen("OK");
        Unsafe.systemExit((int)0);
    }

    protected Options getOptions() {
        return this.options;
    }

    private void backup(OptionsHelper optionsHelper) throws Exception {
        String path = optionsHelper.getOptionValue(OPTION_DIR);
        if (StringUtils.isEmpty((CharSequence)path)) {
            path = KylinConfigBase.getKylinHome() + File.separator + "rec_candidate";
        }
        String time = LocalDateTime.now(Clock.systemDefaultZone()).format(DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss", Locale.getDefault(Locale.Category.FORMAT)));
        if (optionsHelper.hasOption(OPTION_PROJECT)) {
            String project = optionsHelper.getOptionValue(OPTION_PROJECT);
            String folder = String.format(Locale.ROOT, "project_%s", time);
            File dir = new File(path, folder);
            this.extractProject(project, dir);
        } else if (optionsHelper.hasOption(OPTION_MODEL_ID)) {
            String modelId = optionsHelper.getOptionValue(OPTION_MODEL_ID);
            String folder = String.format(Locale.ROOT, "model_%s", time);
            File dir = new File(path, folder);
            this.extractModel(this.getProjectByModelId(modelId), modelId, dir);
        } else {
            String folder = String.format(Locale.ROOT, "full_%s", time);
            File dir = new File(path, folder);
            this.extractFull(dir);
        }
    }

    private void restore(OptionsHelper optionsHelper) throws Exception {
        String table = optionsHelper.getOptionValue(OPTION_TABLE);
        if (StringUtils.isEmpty((CharSequence)table)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeTool.PARAMETER_EMPTY, new Object[]{"table"});
        }
        String path = optionsHelper.getOptionValue(OPTION_DIR);
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeTool.PARAMETER_NOT_SPECIFY, new Object[]{"-dir"});
        }
        File dirFile = Paths.get(path, new String[0]).toFile();
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeTool.PATH_NOT_EXISTS, new Object[]{path});
        }
        File[] projects = dirFile.listFiles();
        if (projects == null) {
            logger.warn("No project found, skip restore.");
            return;
        }
        JdbcRawRecStore jdbcRawRecStore = new JdbcRawRecStore(this.kylinConfig, table);
        jdbcRawRecStore.deleteAll();
        for (File project : projects) {
            if (!project.isDirectory()) {
                logger.warn("{} is not directory.", (Object)project.getAbsolutePath());
                continue;
            }
            File[] models = project.listFiles();
            if (models == null) {
                logger.warn("No model fount in project {}, skip restore.", (Object)project.getName());
                continue;
            }
            for (File model : models) {
                ArrayList<Object> data = new ArrayList<Object>();
                try (FileInputStream in = new FileInputStream(model);
                     BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, Charset.defaultCharset()));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        try {
                            data.add(JsonUtil.readValue((String)line, RawRecItem.class));
                        }
                        catch (Exception e) {
                            logger.error("Rec candidate deserialize error >>> {}", (Object)line, (Object)e);
                        }
                    }
                    jdbcRawRecStore.save(data, true);
                }
            }
        }
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        if (!optionsHelper.hasOption(OPERATE_BACKUP)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeTool.PARAMETER_NOT_SPECIFY, new Object[]{"-backup"});
        }
        this.backup(optionsHelper);
    }

    private void initOptions() {
        OptionGroup optionGroup1 = new OptionGroup();
        optionGroup1.setRequired(true);
        optionGroup1.addOption(OPERATE_BACKUP);
        OptionGroup optionGroup2 = new OptionGroup();
        optionGroup2.setRequired(false);
        optionGroup2.addOption(OPTION_MODEL_ID);
        optionGroup2.addOption(OPTION_PROJECT);
        this.options.addOptionGroup(optionGroup1);
        this.options.addOptionGroup(optionGroup2);
        this.options.addOption(OPTION_DIR);
        this.options.addOption(OPTION_TABLE);
    }

    public void extractFull(File dir) throws Exception {
        logger.info("Extract full rec candidate.");
        List projects = NProjectManager.getInstance((KylinConfig)this.kylinConfig).listAllProjects();
        for (ProjectInstance project : projects) {
            this.extractProject(project.getName(), dir);
        }
    }

    public void extractProject(String project, File dir) throws Exception {
        logger.info("Extract project rec candidate.");
        if (!NProjectManager.getInstance((KylinConfig)this.kylinConfig).listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toSet()).contains(project)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{project});
        }
        Set modelIds = NDataModelManager.getInstance((KylinConfig)this.kylinConfig, (String)project).listAllModelIds();
        for (String modelId : modelIds) {
            this.extractModel(project, modelId, dir);
        }
    }

    public void extractModel(String project, String modelId, File dir) throws Exception {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Rec candidate interrupted.");
        }
        logger.info("Extract rec candidate, project {}, modelId {}.", (Object)project, (Object)modelId);
        File projectDir = new File(dir, project);
        FileUtils.forceMkdir((File)projectDir);
        File modelFile = new File(projectDir, modelId);
        JdbcRawRecStore jdbcRawRecStore = new JdbcRawRecStore(this.kylinConfig);
        List result = jdbcRawRecStore.listAll(project, modelId, Integer.MAX_VALUE);
        try (FileOutputStream os = new FileOutputStream(modelFile);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)os, Charset.defaultCharset()));){
            for (RawRecItem line : result) {
                try {
                    bw.write(JsonUtil.writeValueAsString((Object)line));
                    bw.newLine();
                }
                catch (Exception e) {
                    logger.error("Write error, id is {}", (Object)line.getId(), (Object)e);
                }
            }
        }
    }

    String getProjectByModelId(String modelId) {
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeTool.PARAMETER_EMPTY, new Object[]{"model"});
        }
        List projects = NProjectManager.getInstance((KylinConfig)this.kylinConfig).listAllProjects();
        for (ProjectInstance project : projects) {
            if (NDataModelManager.getInstance((KylinConfig)this.kylinConfig, (String)project.getName()).getDataModelDesc(modelId) == null) continue;
            return project.getName();
        }
        throw new KylinException((ErrorCodeProducer)ErrorCodeTool.PARAMETER_EMPTY, new Object[]{"model"});
    }
}

