/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.tool.metrics.MetricsInfo;
import org.apache.kylin.tool.util.ToolMainWrapper;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsInfoTool
extends ExecutableApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsInfoTool.class);
    private static final String METRIC_DIR = "_metrics/";
    private static final String METRIC_SUFFIX = "_metric.json";
    private static final long DAY_MILLISECOND = 86400000L;
    private static final String BACKUP_FORMAT = "yyyy-MM-dd-HH-mm-ss";
    private static final String BACKUP_MATCH = "\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}_backup";
    private FileSystem fs;
    private KylinConfig config;
    private String metadataPath;
    private String outPath;
    private String metricDate;
    private String lastMetricDate;
    private static final Option OPTION_DATE = OptionBuilder.getInstance().hasArg().withArgName("METRIC_DATE").withDescription("Specifies the date(yyyyMMdd) on which metrics are calculated").isRequired(true).create("date");

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_DATE);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        this.init(optionsHelper);
        if (!this.locateMetaPath()) {
            throw new IllegalAccessException("No backup file for specified date," + this.metricDate);
        }
        MetricsInfo metricsInfo = new MetricsInfo(DateFormat.formatToTimeStr((long)System.currentTimeMillis()), this.getProjectMetrics(), this.getStorageMetric());
        this.outPutMetricsInfo(metricsInfo);
    }

    private void init(OptionsHelper optionsHelper) throws IllegalAccessException {
        this.metricDate = optionsHelper.getOptionValue(OPTION_DATE);
        if (!this.isValidDate(this.metricDate)) {
            throw new IllegalAccessException("'" + this.metricDate + "' is not a valid date of pattern 'yyyyMMdd'");
        }
        long metricDateMillis = DateFormat.stringToDate((String)this.metricDate, (String)"yyyyMMdd").getTime();
        this.lastMetricDate = DateFormat.formatToDateStr((long)(metricDateMillis - 86400000L), (String)"yyyyMMdd");
        this.fs = HadoopUtil.getWorkingFileSystem();
        this.config = KylinConfig.getInstanceFromEnv();
        this.metadataPath = this.config.getHdfsWorkingDirectory();
        this.outPath = this.config.getHdfsWorkingDirectory() + METRIC_DIR + "";
    }

    private List<MetricsInfo.ProjectMetric> getProjectMetrics() throws IOException {
        ArrayList<MetricsInfo.ProjectMetric> projectMetrics = new ArrayList<MetricsInfo.ProjectMetric>();
        Map<String, Integer> modelMap = this.getModelMap(this.inPutMetricsInfo(this.lastMetricDate));
        NProjectManager.getInstance((KylinConfig)this.config).listAllProjects().forEach(projectInstance -> {
            String name = projectInstance.getName();
            int modelTotalCount = NDataModelManager.getInstance((KylinConfig)this.config, (String)name).listAllModels().size();
            Integer lastModelCount = (Integer)modelMap.get(name);
            Integer modelAddCount = lastModelCount == null ? null : Integer.valueOf(modelTotalCount - lastModelCount);
            MetricsInfo.ProjectMetric projectMetric = new MetricsInfo.ProjectMetric(name, modelTotalCount, modelAddCount);
            projectMetrics.add(projectMetric);
        });
        return projectMetrics;
    }

    private boolean locateMetaPath() throws IOException {
        Path path = new Path(HadoopUtil.getBackupFolder((KylinConfig)this.config));
        if (!this.fs.exists(path)) {
            log.error("check default backup folder failed");
            return false;
        }
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)BACKUP_FORMAT);
        long metricDateMillis = DateFormat.stringToDate((String)this.metricDate, (String)"yyyyMMdd").getTime();
        Set candidateFolder = Arrays.stream(this.fs.listStatus(path)).filter(file -> Pattern.matches(BACKUP_MATCH, file.getPath().getName())).filter(file -> {
            String filePrefix = file.getPath().getName().substring(0, BACKUP_FORMAT.length());
            long fileMillis = formatter.parseDateTime(filePrefix).getMillis();
            return fileMillis >= metricDateMillis && fileMillis < metricDateMillis + 86400000L;
        }).collect(Collectors.toSet());
        if (candidateFolder.isEmpty()) {
            log.error("check default backup folder failed");
            return false;
        }
        Optional<FileStatus> last = candidateFolder.stream().max(Comparator.comparingLong(FileStatus::getModificationTime));
        String folder = last.get().getPath().getName();
        String restorePath = StringUtils.appendIfMissing((String)HadoopUtil.getBackupFolder((KylinConfig)this.config), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + folder;
        this.config.setProperty("kylin.metadata.url", this.config.getMetadataUrlPrefix() + "@hdfs,path=" + restorePath);
        return true;
    }

    private Map<String, Integer> getModelMap(MetricsInfo info) {
        HashMap map = Maps.newHashMap();
        if (info != null && info.getProjectMetrics() != null) {
            info.getProjectMetrics().forEach(metric -> map.put(metric.getProjectName(), metric.getModelTotalCount()));
        }
        return map;
    }

    @VisibleForTesting
    public MetricsInfo inPutMetricsInfo(String dateStr) throws IOException {
        Path path = new Path(this.outPath + dateStr + METRIC_SUFFIX);
        if (this.fs.exists(path)) {
            try (FSDataInputStream inputStream = this.fs.open(path);){
                MetricsInfo metricsInfo = (MetricsInfo)JsonUtil.readValue((InputStream)inputStream, MetricsInfo.class);
                return metricsInfo;
            }
        }
        return null;
    }

    private void outPutMetricsInfo(MetricsInfo metricsInfo) throws IOException {
        String pathStr = this.outPath + this.metricDate + METRIC_SUFFIX;
        Path path = new Path(pathStr);
        try (FSDataOutputStream outputStream = this.fs.create(path);){
            outputStream.writeBytes(JsonUtil.writeValueAsString((Object)metricsInfo));
            log.info("outPut MetricsInfo success at {}", (Object)pathStr);
        }
    }

    private MetricsInfo.StorageMetric getStorageMetric() throws IOException {
        ContentSummary contentSummary = this.fs.getContentSummary(new Path(this.metadataPath));
        return new MetricsInfo.StorageMetric(this.metadataPath, contentSummary.getLength(), contentSummary.getFileCount(), contentSummary.getDirectoryCount());
    }

    public static void main(String[] args) {
        ToolMainWrapper.wrap(args, () -> {
            MetricsInfoTool tool = new MetricsInfoTool();
            tool.execute(args);
        });
        Unsafe.systemExit((int)0);
    }

    private boolean isValidDate(String metricDate) {
        try {
            if (metricDate.length() == 8 && String.valueOf(Integer.parseInt(metricDate)).length() == 8) {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd", Locale.getDefault(Locale.Category.FORMAT));
                format.setLenient(false);
                format.parse(metricDate);
                return true;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return false;
    }
}

