/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.metadata.epoch.EpochManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.tool.util.ToolMainWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MaintainModeTool
extends ExecutableApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MaintainModeTool.class);
    private static final Option OPTION_MaintainMode_ON = new Option("on", "on", false, "turn on maintain mode.");
    private static final Option OPTION_MaintainMode_ON_REASON = new Option("reason", "reason", true, "the reason to turn on maintain mode.");
    private static final Option OPTION_MaintainMode_OFF = new Option("off", "off", false, "turn off maintain mode.");
    private static final Option OPTION_PROJECTS = new Option("p", "projects", true, "specify projects to turn on or turn off maintain mode.");
    private static final Option OPTION_HELP = new Option("h", "help", false, "print help message.");
    private static final String LEADER_RACE_KEY = "kylin.server.leader-race.enabled";
    private static final Option OPTION_HIDDEN_OUTPUT = new Option("hidden", "hidden-output", true, "only show output in logs");
    private static final Option OPTION_FORCE_TURN_OFF = new Option("f", "force", false, "force to turn maintain mode off");
    private boolean maintainModeOn;
    private String reason;
    private List<String> projects = Lists.newArrayList();
    private String owner;
    private KylinConfig config;
    private EpochManager epochManager;
    private boolean hiddenOutput;
    private boolean forceToTurnOff;

    public MaintainModeTool() {
    }

    public MaintainModeTool(String reason) {
        this.reason = reason;
        this.hiddenOutput = true;
    }

    public static void main(String[] args) {
        ToolMainWrapper.wrap(args, () -> {
            MaintainModeTool tool = new MaintainModeTool();
            tool.execute(args);
        });
        Unsafe.systemExit((int)0);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_MaintainMode_ON);
        options.addOption(OPTION_MaintainMode_ON_REASON);
        options.addOption(OPTION_PROJECTS);
        options.addOption(OPTION_HELP);
        options.addOption(OPTION_MaintainMode_OFF);
        options.addOption(OPTION_HIDDEN_OUTPUT);
        options.addOption(OPTION_FORCE_TURN_OFF);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        if (this.printUsage(optionsHelper)) {
            return;
        }
        this.initOptionValues(optionsHelper);
        this.init();
        if (this.maintainModeOn) {
            this.markEpochs();
        } else {
            this.releaseEpochs();
        }
    }

    public void init() {
        this.config = KylinConfig.getInstanceFromEnv();
        String ipAndPort = AddressUtil.getMockPortAddress();
        this.tryCatchupAuditLog(ipAndPort);
        if (CollectionUtils.isEmpty(this.projects)) {
            this.projects = NProjectManager.getInstance((KylinConfig)this.config).listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toList());
        }
        this.projects.add("_global");
        this.owner = ipAndPort + "|" + Long.MAX_VALUE;
        this.epochManager = EpochManager.getInstance();
        this.epochManager.setIdentity(this.owner);
    }

    private void tryCatchupAuditLog(String ipAndPort) {
        try {
            ResourceStore metaStore = ResourceStore.getKylinMetaStore((KylinConfig)this.config);
            metaStore.getAuditLogStore().setInstance(ipAndPort);
            metaStore.getAuditLogStore().catchupWithTimeout();
        }
        catch (Exception e) {
            log.error("Catchup audit log failed, try to release epochs", (Throwable)e);
            System.out.println("Catchup audit log failed, try to release epochs when init");
            Unsafe.systemExit((int)1);
        }
    }

    public void markEpochs() {
        this.print("Start to mark epoch with reason: " + this.reason);
        if (this.epochManager.isMaintenanceMode()) {
            System.out.println("The system is under maintenance mode. Please try again later.");
            log.warn("The system is under maintenance mode. Please try again later.");
            Unsafe.systemExit((int)1);
        }
        Unsafe.setProperty((String)LEADER_RACE_KEY, (String)"false");
        try {
            this.enterMaintenanceModeWithRetry(this.config.getTurnMaintainModeRetryTimes(), this.reason, this.projects);
        }
        catch (Exception e) {
            log.error("Mark epoch failed", (Throwable)e);
            System.out.println("\u001b[31mTurn on maintain mode failed. Detailed Message is at ${KYLIN_HOME}/logs/shell.stderr\u001b[0m");
            Unsafe.systemExit((int)1);
        }
        finally {
            Unsafe.clearProperty((String)LEADER_RACE_KEY);
        }
        this.print("Mark epoch success with reason: " + this.reason);
    }

    private void enterMaintenanceModeWithRetry(int retryTimes, String reason, List<String> prj) throws IllegalStateException {
        boolean checkMaintOwner;
        boolean updateEpoch = false;
        try {
            updateEpoch = this.epochManager.tryForceInsertOrUpdateEpochBatchTransaction(prj, false, reason, false);
        }
        catch (Exception e) {
            log.error("enter maintain mode failed", (Throwable)e);
        }
        boolean bl = checkMaintOwner = this.epochManager.isMaintenanceMode() && this.epochManager.checkEpochOwner("_global");
        if (updateEpoch && checkMaintOwner && retryTimes > 0) {
            log.info("finished enter maintenance mode...retry:{},reason:{}", (Object)retryTimes, (Object)reason);
        } else if (retryTimes > 0) {
            log.warn("retry enter maintenance mode...retry:{},reason:{}", (Object)retryTimes, (Object)reason);
            this.enterMaintenanceModeWithRetry(retryTimes - 1, reason, prj);
        } else {
            throw new IllegalStateException("Failed to turn on maintain mode!");
        }
    }

    private void exitMaintenanceModeWithRetry(int retryTimes, String reason, List<String> prj, boolean skipCheckMaintMode) throws IllegalStateException {
        boolean updateEpoch = false;
        try {
            updateEpoch = this.epochManager.tryForceInsertOrUpdateEpochBatchTransaction(prj, skipCheckMaintMode, reason, true);
        }
        catch (Exception e) {
            log.error("exit maintain mode failed", (Throwable)e);
        }
        if (updateEpoch && (!this.epochManager.checkExpectedIsMaintenance(true) || skipCheckMaintMode) && retryTimes > 0) {
            log.info("finished exited maintenance mode...retry:{},reason:{}", (Object)retryTimes, (Object)reason);
        } else if (retryTimes > 0) {
            log.warn("retry exited maintenance mode...retry:{},reason:{}", (Object)retryTimes, (Object)reason);
            this.exitMaintenanceModeWithRetry(retryTimes - 1, reason, prj, skipCheckMaintMode);
        } else {
            throw new IllegalStateException("Failed to turn off maintain mode!");
        }
    }

    public void releaseEpochs() {
        this.print("Start to release epoch");
        if (!this.epochManager.isMaintenanceMode() && !this.forceToTurnOff) {
            System.out.println("System is not in maintenance mode.");
            log.warn("System is not in maintenance mode.");
            throw new IllegalStateException("System is not in maintenance mode.");
        }
        try {
            Unsafe.setProperty((String)LEADER_RACE_KEY, (String)"true");
            this.epochManager.setIdentity("");
            this.exitMaintenanceModeWithRetry(this.config.getTurnMaintainModeRetryTimes(), null, this.projects, this.forceToTurnOff);
        }
        catch (Exception e) {
            log.error("Release epoch failed, try to turn off maintain mode manually.", (Throwable)e);
            System.out.println("\u001b[31mTurn off maintain mode failed. Detailed Message is at ${KYLIN_HOME}/logs/shell.stderr\u001b[0m");
            throw new IllegalStateException("Turn off maintain mode failed.");
        }
        finally {
            Unsafe.clearProperty((String)LEADER_RACE_KEY);
        }
        this.print("Release epoch success");
    }

    private boolean printUsage(OptionsHelper optionsHelper) {
        boolean help = optionsHelper.hasOption(OPTION_HELP);
        if (help) {
            optionsHelper.printUsage(((Object)((Object)this)).getClass().getName(), this.getOptions());
        }
        return help;
    }

    private void initOptionValues(OptionsHelper optionsHelper) {
        if (optionsHelper.hasOption(OPTION_MaintainMode_ON) && optionsHelper.hasOption(OPTION_MaintainMode_OFF)) {
            throw new IllegalStateException("Can not turn on and off maintain mode at same time.");
        }
        if (!optionsHelper.hasOption(OPTION_MaintainMode_ON) && !optionsHelper.hasOption(OPTION_MaintainMode_OFF)) {
            throw new IllegalStateException("You should specified turn on or off maintain mode.");
        }
        this.maintainModeOn = optionsHelper.hasOption(OPTION_MaintainMode_ON);
        if (optionsHelper.hasOption(OPTION_PROJECTS)) {
            this.projects = Lists.newArrayList((Object[])optionsHelper.getOptionValue(OPTION_PROJECTS).split(","));
        }
        if (optionsHelper.hasOption(OPTION_HIDDEN_OUTPUT)) {
            this.hiddenOutput = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_HIDDEN_OUTPUT));
        }
        this.forceToTurnOff = optionsHelper.hasOption(OPTION_FORCE_TURN_OFF);
        this.reason = optionsHelper.getOptionValue(OPTION_MaintainMode_ON_REASON);
        if (this.maintainModeOn && StringUtils.isEmpty((Object)this.reason)) {
            log.warn("You need to use the argument -reason to explain why you turn on maintenance mode");
            System.out.println("You need to use the argument -reason to explain why you turn on maintenance mode");
            Unsafe.systemExit((int)1);
        }
        log.info("MaintainModeTool has option maintain mode on: {}{}{}", new Object[]{this.maintainModeOn, StringUtils.isEmpty((Object)this.reason) ? "" : " reason: " + this.reason, this.projects.size() > 0 ? " projects: " + optionsHelper.getOptionValue(OPTION_PROJECTS) : ""});
        this.print(String.format(Locale.ROOT, "MaintainModeTool has option maintain mode on: %s%s%s", this.maintainModeOn, StringUtils.isEmpty((Object)this.reason) ? "" : " reason: " + this.reason, this.projects.size() > 0 ? " projects: " + optionsHelper.getOptionValue(OPTION_PROJECTS) : ""));
    }

    private void print(String output) {
        if (!this.hiddenOutput) {
            System.out.println(output);
        }
        log.info(output);
    }

    @Generated
    public void setMaintainModeOn(boolean maintainModeOn) {
        this.maintainModeOn = maintainModeOn;
    }

    @Generated
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Generated
    public void setProjects(List<String> projects) {
        this.projects = projects;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setConfig(KylinConfig config) {
        this.config = config;
    }

    @Generated
    public void setEpochManager(EpochManager epochManager) {
        this.epochManager = epochManager;
    }

    @Generated
    public void setHiddenOutput(boolean hiddenOutput) {
        this.hiddenOutput = hiddenOutput;
    }

    @Generated
    public void setForceToTurnOff(boolean forceToTurnOff) {
        this.forceToTurnOff = forceToTurnOff;
    }
}

