/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.collect.Sets;
import io.kyligence.kap.guava20.shaded.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinTableCCCleanup {
    private static final Logger logger = LoggerFactory.getLogger(KylinTableCCCleanup.class);
    private KylinConfig config;
    private boolean cleanup;
    private List<String> projects;

    public KylinTableCCCleanup(KylinConfig config, boolean cleanup, List<String> projects) {
        this.config = config;
        this.cleanup = cleanup;
        this.projects = projects;
    }

    public void scanAllTableCC() {
        for (String projectName : this.projects) {
            this.scanTableCCOfProject(projectName);
        }
    }

    private void scanTableCCOfProject(String projectName) {
        logger.info("check project {}", (Object)projectName);
        NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)this.config, (String)projectName);
        Map projectTableMap = tableMetadataManager.getAllTablesMap();
        HashMap tableComputedColumns = Maps.newHashMap();
        for (Map.Entry tableDescEntry : projectTableMap.entrySet()) {
            String tableIdentity = (String)tableDescEntry.getKey();
            TableDesc tableDesc = (TableDesc)tableDescEntry.getValue();
            Set<ColumnDesc> computedColumnDescSet = this.getComputedColumnDescOfTable(tableDesc);
            if (computedColumnDescSet.isEmpty()) continue;
            logger.info("check table: {}", (Object)tableIdentity);
            tableComputedColumns.put(tableIdentity, computedColumnDescSet);
            this.processTableHasCCInMetadata(projectName, tableDesc, computedColumnDescSet);
        }
        if (this.cleanup) {
            logger.info("project {} cleanup finished successfully.", (Object)projectName);
        }
    }

    private void processTableHasCCInMetadata(String projectName, TableDesc tableDesc, Set<ColumnDesc> computedColumnDescSet) {
        HashSet ccNames = Sets.newHashSet();
        for (ColumnDesc columnDesc : computedColumnDescSet) {
            ccNames.add(columnDesc.getName());
        }
        logger.info("project {} found computed columns in table metadata: {}", (Object)projectName, (Object)ccNames);
        if (this.cleanup) {
            this.cleanupCCInTableMetadata(projectName, tableDesc);
            logger.info("project {} table cleanup finished successfully.", (Object)projectName);
        }
    }

    private void cleanupCCInTableMetadata(String project, TableDesc tableDesc) {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            TableDesc newTableDesc = this.filterCCBeforeSave(tableDesc);
            NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).updateTableDesc(newTableDesc);
            return 0;
        }, (String)project);
    }

    private TableDesc filterCCBeforeSave(TableDesc srcTable) {
        TableDesc copy = new TableDesc(srcTable);
        HashSet newCols = Sets.newHashSet();
        Object[] cols = copy.getColumns();
        if (ArrayUtils.isEmpty((Object[])cols)) {
            return srcTable;
        }
        for (Object col : cols) {
            if (col.isComputedColumn()) continue;
            newCols.add(col);
        }
        if (newCols.size() == cols.length) {
            return srcTable;
        }
        copy.setColumns(newCols.toArray(new ColumnDesc[0]));
        return copy;
    }

    private Set<ColumnDesc> getComputedColumnDescOfTable(TableDesc tableDesc) {
        ColumnDesc[] columnDescArray = tableDesc.getColumns();
        if (null == columnDescArray) {
            return Sets.newHashSet();
        }
        HashSet computedColumnDescSet = Sets.newHashSet();
        for (ColumnDesc columnDesc : columnDescArray) {
            if (!columnDesc.isComputedColumn()) continue;
            computedColumnDescSet.add(columnDesc);
        }
        return computedColumnDescSet;
    }
}

