/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.File;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.metrics.service.MonitorDao;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.tool.util.ToolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDBTool {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final String INFLUXD_PATH = "/usr/bin/influxd";

    private InfluxDBTool() {
    }

    public static void dumpInfluxDBMetrics(File exportDir) {
        KapConfig kapConfig = KapConfig.wrap((KylinConfig)KylinConfig.getInstanceFromEnv());
        String database = kapConfig.getMetricsDbNameWithMetadataUrlPrefix();
        InfluxDBTool.dumpInfluxDB(exportDir, "system_metrics", database);
    }

    public static void dumpInfluxDBMonitorMetrics(File exportDir) {
        String database = MonitorDao.generateDatabase((KylinConfig)KylinConfig.getInstanceFromEnv());
        InfluxDBTool.dumpInfluxDB(exportDir, "monitor_metrics", database);
    }

    private static void dumpInfluxDB(File exportDir, String subDir, String database) {
        File destDir = new File(exportDir, subDir);
        try {
            KapConfig kapConfig = KapConfig.wrap((KylinConfig)KylinConfig.getInstanceFromEnv());
            String host = kapConfig.getMetricsRpcServiceBindAddress();
            FileUtils.forceMkdir((File)destDir);
            logger.info("Try connect {}.", (Object)host);
            String ip = host.split(":")[0];
            int port = Integer.parseInt(host.split(":")[1]);
            if (!ToolUtil.isPortAvailable((String)ip, (int)port)) {
                logger.info("Failed to Connect influxDB in {}, skip dump.", (Object)host);
                return;
            }
            logger.info("Connect successful.");
            File influxd = new File(INFLUXD_PATH);
            if (!influxd.exists()) {
                String influxDBHome = ToolUtil.getKylinHome() + File.separator + "influxdb";
                influxd = new File(influxDBHome + INFLUXD_PATH);
            }
            String cmd = String.format(Locale.ROOT, "%s backup -portable -database %s -host %s %s", influxd.getAbsolutePath(), database, host, destDir.getAbsolutePath());
            logger.info("InfluxDB backup cmd is {}.", (Object)cmd);
            CliCommandExecutor.CliCmdExecResult result = new CliCommandExecutor().execute(cmd, null);
            if (null != result.getCmd()) {
                logger.debug("dump InfluxDB, database: {}, info: {}", (Object)database, (Object)result.getCmd());
            }
        }
        catch (Exception e) {
            logger.debug("Failed to dump influxdb by database: {} ", (Object)database, (Object)e);
        }
    }
}

