/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.job;

import java.io.IOException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.constant.JobTypeEnum;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.job.exception.JobException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeBuildingCLI
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(CubeBuildingCLI.class);
    private static final Option OPTION_CUBE;
    private static final Option OPTION_BUILD_TYPE;
    private static final Option OPTION_TIME_START;
    private static final Option OPTION_TIME_END;
    private final Options options = new Options();
    private KylinConfig kylinConfig;
    private CubeManager cubeManager;
    private ExecutableManager executableManager;

    public CubeBuildingCLI() {
        this.options.addOption(OPTION_CUBE);
        this.options.addOption(OPTION_BUILD_TYPE);
        this.options.addOption(OPTION_TIME_START);
        this.options.addOption(OPTION_TIME_END);
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.cubeManager = CubeManager.getInstance((KylinConfig)this.kylinConfig);
        this.executableManager = ExecutableManager.getInstance((KylinConfig)this.kylinConfig);
    }

    protected Options getOptions() {
        return this.options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String cubeName = optionsHelper.getOptionValue(OPTION_CUBE);
        String buildType = optionsHelper.getOptionValue(OPTION_BUILD_TYPE);
        if (Strings.isNullOrEmpty((String)buildType)) {
            buildType = "BUILD";
        }
        Long startTime = 0L;
        if (!Strings.isNullOrEmpty((String)optionsHelper.getOptionValue(OPTION_TIME_START))) {
            startTime = Long.parseLong(optionsHelper.getOptionValue(OPTION_TIME_START));
        }
        Long endTime = Long.parseLong(optionsHelper.getOptionValue(OPTION_TIME_END));
        this.run(cubeName, startTime, endTime, buildType);
    }

    private void run(String cubeName, long startDate, long endDate, String buildType) throws IOException, JobException {
        CubeInstance cube = this.cubeManager.getCube(cubeName);
        Preconditions.checkArgument((cube != null ? 1 : 0) != 0, (Object)("Cube named " + cubeName + " does not exist!!!"));
        JobTypeEnum buildTypeEnum = JobTypeEnum.valueOf((String)buildType);
        Preconditions.checkArgument((buildTypeEnum != null ? 1 : 0) != 0, (Object)("Build type named " + buildType + " does not exist!!!"));
        this.submitJob(cube, new SegmentRange.TSRange(Long.valueOf(startDate), Long.valueOf(endDate)), buildTypeEnum, false, "SYSTEM");
    }

    private void submitJob(CubeInstance cube, SegmentRange.TSRange tsRange, JobTypeEnum buildType, boolean forceMergeEmptySeg, String submitter) throws IOException, JobException {
        DefaultChainedExecutable job;
        this.checkCubeDescSignature(cube);
        if (buildType == JobTypeEnum.BUILD) {
            CubeSegment newSeg = this.cubeManager.appendSegment(cube, tsRange);
            job = EngineFactory.createBatchCubingJob((CubeSegment)newSeg, (String)submitter, null);
        } else if (buildType == JobTypeEnum.MERGE) {
            CubeSegment newSeg = this.cubeManager.mergeSegments(cube, tsRange, null, forceMergeEmptySeg);
            job = EngineFactory.createBatchMergeJob((CubeSegment)newSeg, (String)submitter);
        } else if (buildType == JobTypeEnum.REFRESH) {
            CubeSegment refreshSeg = this.cubeManager.refreshSegment(cube, tsRange, null);
            job = EngineFactory.createBatchCubingJob((CubeSegment)refreshSeg, (String)submitter, null);
        } else {
            throw new JobException("invalid build type:" + buildType);
        }
        this.executableManager.addJob((AbstractExecutable)job);
    }

    private void checkCubeDescSignature(CubeInstance cube) {
        if (!cube.getDescriptor().checkSignature()) {
            throw new IllegalStateException("Inconsistent cube desc signature for " + cube.getDescriptor());
        }
    }

    public static void main(String[] args) {
        CubeBuildingCLI cli = new CubeBuildingCLI();
        try {
            cli.execute(args);
            System.exit(0);
        }
        catch (Exception e) {
            logger.error("error start cube building", (Throwable)e);
            System.exit(-1);
        }
    }

    static {
        OptionBuilder.withArgName((String)"cube");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Specify for which cube to build");
        OPTION_CUBE = OptionBuilder.create((String)"cube");
        OptionBuilder.withArgName((String)"buildType");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify for the build type");
        OPTION_BUILD_TYPE = OptionBuilder.create((String)"buildType");
        OptionBuilder.withArgName((String)"startTime");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify the start time of the segment");
        OPTION_TIME_START = OptionBuilder.create((String)"startTime");
        OptionBuilder.withArgName((String)"endTime");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Specify the end time of the segment");
        OPTION_TIME_END = OptionBuilder.create((String)"endTime");
    }
}

