/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.metrics.systemcube;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.tool.metrics.systemcube.SCCreator;
import org.apache.kylin.tool.metrics.systemcube.def.MetricsSinkDesc;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SCCreatorTest
extends LocalFileMetadataTestCase {
    private File tempMetadataDir;

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
        File tempDir = File.createTempFile(((Object)((Object)this)).getClass().getName(), "system");
        FileUtils.forceDelete((File)tempDir);
        this.tempMetadataDir = new File(tempDir, "meta");
    }

    @After
    public void after() throws Exception {
        if (this.tempMetadataDir != null && this.tempMetadataDir.exists()) {
            FileUtils.forceDelete((File)this.tempMetadataDir.getParentFile());
        }
        SCCreatorTest.staticCleanupTestMetadata();
    }

    @Test
    public void testExecute() throws Exception {
        String metadataPath = this.tempMetadataDir.getPath();
        String inputPath = "src/main/resources/SCSinkTools.json";
        SCCreator cli = new SCCreator();
        cli.execute("ADMIN", metadataPath, inputPath);
        Assert.assertTrue((boolean)this.tempMetadataDir.isDirectory());
        KylinConfig local = KylinConfig.createKylinConfig((KylinConfig)KylinConfig.getInstanceFromEnv());
        local.setMetadataUrl(metadataPath);
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)local);
        List cubeList = cubeManager.listAllCubes();
        System.out.println("System cubes: " + cubeList);
        Assert.assertEquals((long)cubeList.size(), (long)10L);
        for (CubeInstance cube : cubeList) {
            Assert.assertTrue((cube.getStatus() != RealizationStatusEnum.DESCBROKEN ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWriteSinkToolsJson() throws Exception {
        HashMap cubeDescOverrideProperties = Maps.newHashMap();
        cubeDescOverrideProperties.put("kylin.cube.algorithm", "INMEM");
        MetricsSinkDesc metricsSinkDesc = new MetricsSinkDesc();
        metricsSinkDesc.setCubeDescOverrideProperties((Map)cubeDescOverrideProperties);
        ArrayList metricsSinkDescList = Lists.newArrayList();
        String outputPath = "src/test/resources/SCSinkTools.json";
        JsonUtil.writeValue((OutputStream)new FileOutputStream(outputPath), (Object)metricsSinkDescList);
        List<MetricsSinkDesc> sinkToolSet = this.readSinkToolsJson(outputPath);
        for (MetricsSinkDesc entry : sinkToolSet) {
            Map props = entry.getCubeDescOverrideProperties();
            for (String key : cubeDescOverrideProperties.keySet()) {
                Assert.assertEquals(props.get(key), cubeDescOverrideProperties.get(key));
            }
        }
    }

    @Test
    public void testReadSinkToolsJson() throws Exception {
        List<MetricsSinkDesc> sinkToolSet = this.readSinkToolsJson("src/main/resources/SCSinkTools.json");
        for (MetricsSinkDesc entry : sinkToolSet) {
            Map props = entry.getCubeDescOverrideProperties();
            Assert.assertEquals(props.get("kylin.cube.algorithm"), (Object)"INMEM");
        }
    }

    private List<MetricsSinkDesc> readSinkToolsJson(String jsonPath) throws Exception {
        TypeReference<List<MetricsSinkDesc>> typeRef = new TypeReference<List<MetricsSinkDesc>>(){};
        List sourceToolSet = (List)JsonUtil.readValue((String)FileUtils.readFileToString((File)new File(jsonPath)), (TypeReference)typeRef);
        return sourceToolSet;
    }
}

