/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.metrics.systemcube;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metrics.lib.ActiveReservoirReporter;
import org.apache.kylin.metrics.lib.impl.RecordEvent;
import org.apache.kylin.metrics.lib.impl.TimePropertyEnum;
import org.apache.kylin.metrics.lib.impl.hive.HiveReservoirReporter;
import org.apache.kylin.metrics.property.JobPropertyEnum;
import org.apache.kylin.metrics.property.QuerySparkExecutionEnum;
import org.apache.kylin.metrics.property.QuerySparkJobEnum;
import org.apache.kylin.metrics.property.QuerySparkStageEnum;
import org.apache.kylin.shaded.com.google.common.base.Strings;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public class HiveTableCreator {
    public static void main(String[] args) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        System.out.println(HiveTableCreator.generateAllSQL(config));
    }

    public static String generateAllSQL(KylinConfig config) {
        StringBuilder sb = new StringBuilder();
        sb.append(HiveTableCreator.generateDatabaseSQL());
        sb.append("\n");
        sb.append(HiveTableCreator.generateHiveTableSQLForMetricsQuery(config));
        sb.append("\n");
        sb.append(HiveTableCreator.generateHiveTableSQLForMetricsQueryCUBE(config));
        sb.append("\n");
        sb.append(HiveTableCreator.generateHiveTableSQLForMetricsQueryRPC(config));
        sb.append("\n");
        sb.append(HiveTableCreator.generateHiveTableSQLForMetricsJob(config));
        sb.append("\n");
        sb.append(HiveTableCreator.generateHiveTableSQLForMetricsJobException(config));
        return sb.toString();
    }

    public static String generateDatabaseSQL() {
        return "CREATE DATABASE IF NOT EXISTS " + ActiveReservoirReporter.KYLIN_PREFIX + ";\n";
    }

    public static String generateHiveTableSQL(String tableName, List<Pair<String, String>> columns, List<Pair<String, String>> partitionKVs) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("DROP TABLE IF EXISTS " + tableName + ";\n");
        sb.append("\n");
        sb.append("CREATE TABLE " + tableName + "\n");
        sb.append("(\n");
        for (i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            Pair<String, String> column = columns.get(i);
            sb.append((String)column.getFirst() + " " + (String)column.getSecond() + "\n");
        }
        sb.append(")\n");
        if (partitionKVs != null && partitionKVs.size() > 0) {
            sb.append("PARTITIONED BY(");
            for (i = 0; i < partitionKVs.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                Pair<String, String> partitionKV = partitionKVs.get(i);
                sb.append((String)partitionKV.getFirst() + " " + (String)partitionKV.getSecond());
            }
            sb.append(")\n");
        }
        sb.append("ROW FORMAT DELIMITED FIELDS TERMINATED BY ','\n");
        sb.append("STORED AS TEXTFILE;\n");
        return sb.toString();
    }

    public static String generateHiveTableSQLForMetricsQuery(KylinConfig config) {
        String tableName = HiveReservoirReporter.getTableFromSubject((String)config.getKylinMetricsSubjectQueryExecution());
        return HiveTableCreator.generateHiveTableSQL(tableName, HiveTableCreator.getHiveColumnsForMetricsQueryExecution(), HiveTableCreator.getPartitionKVsForHiveTable());
    }

    public static String generateHiveTableSQLForMetricsQueryCUBE(KylinConfig config) {
        String tableName = HiveReservoirReporter.getTableFromSubject((String)config.getKylinMetricsSubjectQuerySparkJob());
        return HiveTableCreator.generateHiveTableSQL(tableName, HiveTableCreator.getHiveColumnsForMetricsQuerySparkJob(), HiveTableCreator.getPartitionKVsForHiveTable());
    }

    public static String generateHiveTableSQLForMetricsQueryRPC(KylinConfig config) {
        String tableName = HiveReservoirReporter.getTableFromSubject((String)config.getKylinMetricsSubjectQuerySparkStage());
        return HiveTableCreator.generateHiveTableSQL(tableName, HiveTableCreator.getHiveColumnsForMetricsQuerySparkStage(), HiveTableCreator.getPartitionKVsForHiveTable());
    }

    public static String generateHiveTableSQLForMetricsJob(KylinConfig config) {
        String tableName = HiveReservoirReporter.getTableFromSubject((String)config.getKylinMetricsSubjectJob());
        return HiveTableCreator.generateHiveTableSQL(tableName, HiveTableCreator.getHiveColumnsForMetricsJob(), HiveTableCreator.getPartitionKVsForHiveTable());
    }

    public static String generateHiveTableSQLForMetricsJobException(KylinConfig config) {
        String tableName = HiveReservoirReporter.getTableFromSubject((String)config.getKylinMetricsSubjectJobException());
        return HiveTableCreator.generateHiveTableSQL(tableName, HiveTableCreator.getHiveColumnsForMetricsJobException(), HiveTableCreator.getPartitionKVsForHiveTable());
    }

    public static List<Pair<String, String>> getHiveColumnsForMetricsQueryExecution() {
        LinkedList columns = Lists.newLinkedList();
        columns.add(new Pair((Object)QuerySparkExecutionEnum.ID_CODE.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.QUERY_ID.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.EXECUTION_ID.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)RecordEvent.RecordReserveKeyEnum.HOST.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.USER.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.SPARDER_NAME.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.PROJECT.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.REALIZATION.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.REALIZATION_TYPE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.CUBOID_IDS.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.TYPE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.START_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.END_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.EXCEPTION.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.TIME_COST.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.TOTAL_SCAN_COUNT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.TOTAL_SCAN_BYTES.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.RESULT_COUNT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.EXECUTION_DURATION.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.RESULT_SIZE.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.EXECUTOR_DESERIALIZE_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.EXECUTOR_DESERIALIZE_CPU_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.EXECUTOR_RUN_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.EXECUTOR_CPU_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.JVM_GC_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.RESULT_SERIALIZATION_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.MEMORY_BYTE_SPILLED.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.DISK_BYTES_SPILLED.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkExecutionEnum.PEAK_EXECUTION_MEMORY.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.addAll(HiveTableCreator.getTimeColumnsForMetrics());
        return columns;
    }

    public static List<Pair<String, String>> getHiveColumnsForMetricsQuerySparkJob() {
        LinkedList columns = Lists.newLinkedList();
        columns.add(new Pair((Object)QuerySparkJobEnum.QUERY_ID.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkJobEnum.PROJECT.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkJobEnum.EXECUTION_ID.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkJobEnum.JOB_ID.toString(), (Object)HiveTypeEnum.HINT.toString()));
        columns.add(new Pair((Object)RecordEvent.RecordReserveKeyEnum.HOST.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkJobEnum.START_TIME.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkJobEnum.END_TIME.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkJobEnum.IF_SUCCESS.toString(), (Object)HiveTypeEnum.HBOOLEAN.toString()));
        columns.add(new Pair((Object)QuerySparkJobEnum.RESULT_SIZE.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkJobEnum.EXECUTOR_DESERIALIZE_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkJobEnum.EXECUTOR_DESERIALIZE_CPU_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkJobEnum.EXECUTOR_RUN_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkJobEnum.EXECUTOR_CPU_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkJobEnum.JVM_GC_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkJobEnum.RESULT_SERIALIZATION_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkJobEnum.MEMORY_BYTE_SPILLED.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkJobEnum.DISK_BYTES_SPILLED.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkJobEnum.PEAK_EXECUTION_MEMORY.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.addAll(HiveTableCreator.getTimeColumnsForMetrics());
        return columns;
    }

    public static List<Pair<String, String>> getHiveColumnsForMetricsQuerySparkStage() {
        LinkedList columns = Lists.newLinkedList();
        columns.add(new Pair((Object)RecordEvent.RecordReserveKeyEnum.HOST.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.QUERY_ID.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.EXECUTION_ID.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.JOB_ID.toString(), (Object)HiveTypeEnum.HINT.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.STAGE_ID.toString(), (Object)HiveTypeEnum.HINT.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.SUBMIT_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.PROJECT.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.REALIZATION.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.CUBOID_ID.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.IF_SUCCESS.toString(), (Object)HiveTypeEnum.HBOOLEAN.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.RESULT_SIZE.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.EXECUTOR_DESERIALIZE_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.EXECUTOR_DESERIALIZE_CPU_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.EXECUTOR_RUN_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.EXECUTOR_CPU_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.JVM_GC_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.RESULT_SERIALIZATION_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.MEMORY_BYTE_SPILLED.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.DISK_BYTES_SPILLED.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QuerySparkStageEnum.PEAK_EXECUTION_MEMORY.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.addAll(HiveTableCreator.getTimeColumnsForMetrics());
        return columns;
    }

    public static List<Pair<String, String>> getHiveColumnsForMetricsJob() {
        LinkedList columns = Lists.newLinkedList();
        columns.add(new Pair((Object)JobPropertyEnum.ID_CODE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)RecordEvent.RecordReserveKeyEnum.HOST.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.USER.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.PROJECT.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.CUBE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.TYPE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.ALGORITHM.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.BUILD_DURATION.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.SOURCE_SIZE.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.CUBE_SIZE.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.PER_BYTES_TIME_COST.toString(), (Object)HiveTypeEnum.HDOUBLE.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.WAIT_RESOURCE_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.STEP_DURATION_DISTINCT_COLUMNS.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.STEP_DURATION_DICTIONARY.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.STEP_DURATION_INMEM_CUBING.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.STEP_DURATION_HFILE_CONVERT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.addAll(HiveTableCreator.getTimeColumnsForMetrics());
        return columns;
    }

    public static List<Pair<String, String>> getHiveColumnsForMetricsJobException() {
        LinkedList columns = Lists.newLinkedList();
        columns.add(new Pair((Object)JobPropertyEnum.ID_CODE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)RecordEvent.RecordReserveKeyEnum.HOST.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.USER.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.PROJECT.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.CUBE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.TYPE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.ALGORITHM.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.EXCEPTION.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.addAll(HiveTableCreator.getTimeColumnsForMetrics());
        return columns;
    }

    public static List<Pair<String, String>> getPartitionKVsForHiveTable() {
        LinkedList partitionKVs = Lists.newLinkedList();
        partitionKVs.add(new Pair((Object)TimePropertyEnum.DAY_DATE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        return partitionKVs;
    }

    public static List<Pair<String, String>> getTimeColumnsForMetrics() {
        LinkedList columns = Lists.newLinkedList();
        columns.add(new Pair((Object)RecordEvent.RecordReserveKeyEnum.TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)TimePropertyEnum.YEAR.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)TimePropertyEnum.MONTH.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)TimePropertyEnum.WEEK_BEGIN_DATE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)TimePropertyEnum.DAY_TIME.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)TimePropertyEnum.TIME_HOUR.toString(), (Object)HiveTypeEnum.HINT.toString()));
        columns.add(new Pair((Object)TimePropertyEnum.TIME_MINUTE.toString(), (Object)HiveTypeEnum.HINT.toString()));
        columns.add(new Pair((Object)TimePropertyEnum.TIME_SECOND.toString(), (Object)HiveTypeEnum.HINT.toString()));
        return columns;
    }

    static enum HiveTypeEnum {
        HBOOLEAN("boolean"),
        HINT("int"),
        HBIGINT("bigint"),
        HDOUBLE("double"),
        HSTRING("string"),
        HDECIMAL("decimal");

        private final String typeName;

        private HiveTypeEnum(String typeName) {
            this.typeName = typeName;
        }

        public static HiveTypeEnum getByTypeName(String typeName) {
            if (Strings.isNullOrEmpty((String)typeName)) {
                return null;
            }
            for (HiveTypeEnum hiveType : HiveTypeEnum.values()) {
                if (!hiveType.typeName.equals(typeName.toLowerCase(Locale.ROOT))) continue;
                return hiveType;
            }
            return null;
        }

        public String toString() {
            return this.typeName;
        }
    }
}

