/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.job;

import com.google.common.base.Strings;
import java.io.IOException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.model.CubeBuildTypeEnum;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.util.JobRestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeBuildingCLIV2
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(CubeBuildingCLIV2.class);
    private static final Option OPTION_CUBE;
    private static final Option OPTION_BUILD_TYPE;
    private static final Option OPTION_TIME_START;
    private static final Option OPTION_TIME_END;
    private static final Option OPTION_HOST;
    private static final Option OPTION_PORT;
    private static final Option OPTION_USER_NAME;
    private static final Option OPTION_PASSWORD;
    private static final Option OPTION_WAITING_FOR_END;
    private static final Option OPTION_RETRY_NUMBER;
    private static final Option OPTION_DISCARD_ERROR_JOB;
    private final Options options = new Options();

    public CubeBuildingCLIV2() {
        this.options.addOption(OPTION_CUBE);
        this.options.addOption(OPTION_BUILD_TYPE);
        this.options.addOption(OPTION_TIME_START);
        this.options.addOption(OPTION_TIME_END);
        this.options.addOption(OPTION_HOST);
        this.options.addOption(OPTION_PORT);
        this.options.addOption(OPTION_USER_NAME);
        this.options.addOption(OPTION_PASSWORD);
        this.options.addOption(OPTION_WAITING_FOR_END);
        this.options.addOption(OPTION_RETRY_NUMBER);
        this.options.addOption(OPTION_DISCARD_ERROR_JOB);
    }

    protected Options getOptions() {
        return this.options;
    }

    protected void execute(OptionsHelper optionsHelper) throws IOException {
        String cubeName = optionsHelper.getOptionValue(OPTION_CUBE);
        String buildType = optionsHelper.getOptionValue(OPTION_BUILD_TYPE);
        if (Strings.isNullOrEmpty((String)buildType)) {
            buildType = "BUILD";
        }
        Long startTime = 0L;
        if (!Strings.isNullOrEmpty((String)optionsHelper.getOptionValue(OPTION_TIME_START))) {
            startTime = Long.parseLong(optionsHelper.getOptionValue(OPTION_TIME_START));
        }
        Long endTime = Long.parseLong(optionsHelper.getOptionValue(OPTION_TIME_END));
        String host = optionsHelper.getOptionValue(OPTION_HOST);
        Integer port = Integer.parseInt(optionsHelper.getOptionValue(OPTION_PORT));
        String userName = optionsHelper.getOptionValue(OPTION_USER_NAME);
        String password = optionsHelper.getOptionValue(OPTION_PASSWORD);
        Boolean waitingForEnd = true;
        if (!Strings.isNullOrEmpty((String)optionsHelper.getOptionValue(OPTION_WAITING_FOR_END))) {
            waitingForEnd = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_WAITING_FOR_END));
        }
        JobRestClient client = new JobRestClient(host, port.intValue(), userName, password);
        System.out.println("start building cube.");
        JobInstance jobInstance = this.submitJob(client, cubeName, startTime, endTime, buildType);
        if (waitingForEnd.booleanValue()) {
            int retryNumber = 0;
            if (!Strings.isNullOrEmpty((String)optionsHelper.getOptionValue(OPTION_RETRY_NUMBER))) {
                retryNumber = Integer.parseInt(optionsHelper.getOptionValue(OPTION_RETRY_NUMBER));
            }
            while (!jobInstance.getStatus().isComplete()) {
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    System.err.println("Thread interrupted, exit");
                    System.exit(-1);
                }
                jobInstance = client.getJobStatus(jobInstance.getId());
                System.out.println("job " + jobInstance.getId() + " get status : " + jobInstance.getStatus());
                if (!jobInstance.getStatus().equals((Object)JobStatusEnum.ERROR) || retryNumber <= 0) continue;
                System.out.println("retry count is " + retryNumber);
                --retryNumber;
                jobInstance = client.resumeJob(jobInstance.getId());
            }
            if (!jobInstance.getStatus().equals((Object)JobStatusEnum.FINISHED)) {
                boolean discardErrorJob = false;
                if (!Strings.isNullOrEmpty((String)optionsHelper.getOptionValue(OPTION_DISCARD_ERROR_JOB))) {
                    discardErrorJob = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_DISCARD_ERROR_JOB));
                }
                if (discardErrorJob) {
                    client.discardJob(jobInstance.getId());
                }
                System.exit(-1);
            }
        }
    }

    private JobInstance submitJob(JobRestClient client, String cubeName, long startDate, long endDate, String buildType) throws IOException {
        CubeBuildTypeEnum buildTypeEnum = CubeBuildTypeEnum.valueOf((String)buildType);
        JobInstance jobInstance = client.buildCubeV2(cubeName, startDate, endDate, buildTypeEnum);
        System.out.println("building cube job:");
        System.out.println(client.JobInstance2JsonString(jobInstance));
        return jobInstance;
    }

    public static void main(String[] args) {
        CubeBuildingCLIV2 cli = new CubeBuildingCLIV2();
        try {
            cli.execute(args);
            System.exit(0);
        }
        catch (Exception e) {
            logger.error("error running cube building", (Throwable)e);
            System.exit(-1);
        }
    }

    static {
        OptionBuilder.withArgName((String)"cube");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Specify for which cube to build");
        OPTION_CUBE = OptionBuilder.create((String)"cube");
        OptionBuilder.withArgName((String)"buildType");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify for the build type");
        OPTION_BUILD_TYPE = OptionBuilder.create((String)"buildType");
        OptionBuilder.withArgName((String)"startTime");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify the start time of the segment");
        OPTION_TIME_START = OptionBuilder.create((String)"startTime");
        OptionBuilder.withArgName((String)"endTime");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Specify the end time of the segment");
        OPTION_TIME_END = OptionBuilder.create((String)"endTime");
        OptionBuilder.withArgName((String)"host");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Specify the kylin server host");
        OPTION_HOST = OptionBuilder.create((String)"host");
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Specify the kylin server port");
        OPTION_PORT = OptionBuilder.create((String)"port");
        OptionBuilder.withArgName((String)"userName");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Specify the kylin server user name");
        OPTION_USER_NAME = OptionBuilder.create((String)"userName");
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Specify the kylin server password");
        OPTION_PASSWORD = OptionBuilder.create((String)"password");
        OptionBuilder.withArgName((String)"waitingForEnd");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify whether waiting for end");
        OPTION_WAITING_FOR_END = OptionBuilder.create((String)"waitingForEnd");
        OptionBuilder.withArgName((String)"retryNumber");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify retry number when execute failed");
        OPTION_RETRY_NUMBER = OptionBuilder.create((String)"retryNumber");
        OptionBuilder.withArgName((String)"discardErrorJob");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify discard job when execute failed");
        OPTION_DISCARD_ERROR_JOB = OptionBuilder.create((String)"discardErrorJob");
    }
}

