/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.extractor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.job.dao.ExecutableDao;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.tool.extractor.MrJobInfoExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnLogExtractor {
    private static final Logger logger = LoggerFactory.getLogger(YarnLogExtractor.class);
    List<String> yarnLogsResources = Lists.newArrayList();
    private KylinConfig kylinConfig;
    private ExecutableDao executableDao;

    public void extractYarnLogAndMRJob(String jobId, File yarnLogDir) throws Exception {
        logger.info("Collecting Yarn logs and MR counters for the Job {}", (Object)jobId);
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.executableDao = ExecutableDao.getInstance((KylinConfig)this.kylinConfig);
        ExecutablePO executablePO = null;
        executablePO = this.executableDao.getJob(jobId);
        if (executablePO == null) {
            logger.error("Can not find executablePO.");
            return;
        }
        for (ExecutablePO task : executablePO.getTasks()) {
            this.yarnLogsResources.add(task.getUuid());
        }
        for (String stepId : this.yarnLogsResources) {
            logger.info("Checking step {}", (Object)stepId);
            this.extractYarnLog(stepId, new File(yarnLogDir, stepId));
            this.extractMRJob(stepId, new File(yarnLogDir, stepId));
        }
    }

    protected void extractMRJob(String taskId, File destDir) {
        try {
            Map jobInfo = this.executableDao.getJobOutput(taskId).getInfo();
            String jobId = null;
            if (jobInfo.containsKey("mr_job_id")) {
                jobId = (String)jobInfo.get("mr_job_id");
            } else if (taskId.endsWith("00")) {
                String applicationId;
                logger.info("Create Intermediate Flat Hive Table's taskId: " + taskId);
                String jobContent = this.executableDao.getJobOutput(taskId).getContent();
                if (jobContent != null && (applicationId = this.extractApplicationId(jobContent)) != null) {
                    jobId = applicationId.replace("application", "job");
                    logger.info("jobId is: " + jobId);
                }
            }
            if (jobId != null) {
                FileUtils.forceMkdir((File)destDir);
                String[] mrJobArgs = new String[]{"-mrJobId", jobId, "-destDir", destDir.getAbsolutePath(), "-compress", "false", "-submodule", "true"};
                new MrJobInfoExtractor().execute(mrJobArgs);
            }
        }
        catch (Exception e) {
            logger.error("Failed to extract MRJob .", (Throwable)e);
        }
    }

    protected void extractYarnLog(String taskId, File destDir) {
        try {
            Map jobInfo = this.executableDao.getJobOutput(taskId).getInfo();
            FileUtils.forceMkdir((File)destDir);
            String appId = null;
            if (jobInfo.containsKey("mr_job_id")) {
                appId = ((String)jobInfo.get("mr_job_id")).replace("job", "application");
            } else if (jobInfo.containsKey("spark_job_id")) {
                appId = (String)jobInfo.get("spark_job_id");
            }
            if (appId != null) {
                String applicationId = ((String)jobInfo.get("mr_job_id")).replace("job", "application");
                this.extractYarnLogByApplicationId(applicationId, destDir);
            } else if (taskId.endsWith("00")) {
                this.extractFlatStepInfo(taskId, destDir);
            }
        }
        catch (Exception e) {
            logger.error("Failed to extract yarn log.", (Throwable)e);
        }
    }

    private void extractFlatStepInfo(String taskId, File destDir) {
        try {
            logger.info("Create Intermediate Flat Hive Table's taskId: " + taskId);
            String jobContent = this.executableDao.getJobOutput(taskId).getContent();
            if (jobContent != null) {
                String applicationId = this.extractApplicationId(jobContent);
                logger.info("applicationId is: " + applicationId);
                if (applicationId != null && applicationId.startsWith("application")) {
                    logger.info("Create Intermediate Flat Hive Table's applicationId: " + applicationId);
                    this.extractYarnLogByApplicationId(applicationId, destDir);
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to extract FlatStepInfo.", (Throwable)e);
        }
    }

    private String extractApplicationId(String jobContent) {
        Matcher matcher = Pattern.compile("application_[0-9]+[_][0-9]+").matcher(jobContent);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }

    private void extractYarnLogByApplicationId(String applicationId, File destDir) throws Exception {
        if (YarnLogExtractor.shouldDoLogCollection(applicationId, this.kylinConfig)) {
            File destFile = new File(destDir, applicationId + ".log");
            String yarnCmd = "yarn logs -applicationId " + applicationId + " > " + destFile.getAbsolutePath();
            logger.info(yarnCmd);
            try {
                this.kylinConfig.getCliCommandExecutor().execute(yarnCmd);
            }
            catch (Exception ex) {
                logger.warn("Failed to get yarn logs. ", (Throwable)ex);
            }
        } else {
            logger.info("Skip this application {}.", (Object)applicationId);
        }
    }

    public static boolean shouldDoLogCollection(String applicationId, KylinConfig kylinConfig) throws IOException {
        String yarnCmd = "yarn application -status " + applicationId;
        String cmdOutput = (String)kylinConfig.getCliCommandExecutor().execute(yarnCmd).getSecond();
        HashMap params = Maps.newHashMap();
        String[] cmdOutputLines = cmdOutput.split("\n");
        for (String cmdOutputLine : cmdOutputLines) {
            String[] pair = cmdOutputLine.split(":");
            if (pair.length < 2) continue;
            params.put(pair[0].trim(), pair[1].trim());
        }
        for (Map.Entry entry : params.entrySet()) {
            logger.info("Status of {}  {} : {}", new Object[]{applicationId, entry.getKey(), entry.getValue()});
        }
        if (params.containsKey("State") && ((String)params.get("State")).equals("RUNNING")) {
            return false;
        }
        return params.containsKey("Final-State") && !((String)params.get("Final-State")).equals("SUCCEEDED");
    }
}

