/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.extractor;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.tool.extractor.AbstractInfoExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinLogExtractor
extends AbstractInfoExtractor {
    private static final Logger logger = LoggerFactory.getLogger(KylinLogExtractor.class);
    private static final int DEFAULT_LOG_PERIOD = 3;
    private static final Option OPTION_LOG_PERIOD;
    KylinConfig config;

    public KylinLogExtractor() {
        this.packageType = "logs";
        this.options.addOption(OPTION_LOG_PERIOD);
        this.config = KylinConfig.getInstanceFromEnv();
    }

    private void beforeExtract() {
        logger.info("Start to reload metadata from diagnosis.");
        this.config.clearManagers();
        CubeManager.getInstance((KylinConfig)this.config);
        CubeDescManager.getInstance((KylinConfig)this.config);
        DataModelManager.getInstance((KylinConfig)this.config);
        ProjectManager.getInstance((KylinConfig)this.config);
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        int logPeriod;
        this.beforeExtract();
        int n = logPeriod = optionsHelper.hasOption(OPTION_LOG_PERIOD) ? Integer.parseInt(optionsHelper.getOptionValue(OPTION_LOG_PERIOD)) : 3;
        if (logPeriod < 1) {
            logger.warn("No logs to extract.");
            return;
        }
        logger.info("Start to extract kylin logs in {} days", (Object)logPeriod);
        ArrayList logDirs = Lists.newArrayList();
        logDirs.add(new File(KylinLogExtractor.getKylinHome(), "logs"));
        logDirs.add(new File(KylinLogExtractor.getKylinHome(), "tomcat/logs"));
        ArrayList requiredLogFiles = Lists.newArrayList();
        long logThresholdTime = System.currentTimeMillis() - (long)(logPeriod * 24 * 3600 * 1000);
        for (File kylinLogDir : logDirs) {
            File[] allLogFiles = kylinLogDir.listFiles();
            if (allLogFiles == null || allLogFiles.length == 0) {
                return;
            }
            for (File logFile : allLogFiles) {
                if (logFile.lastModified() <= logThresholdTime) continue;
                requiredLogFiles.add(logFile);
            }
        }
        for (File logFile : requiredLogFiles) {
            logger.info("Log file:" + logFile.getAbsolutePath());
            if (!logFile.exists()) continue;
            String cmd = String.format(Locale.ROOT, "cp %s %s", logFile.getAbsolutePath(), exportDir.getAbsolutePath());
            this.config.getCliCommandExecutor().execute(cmd);
        }
    }

    static {
        OptionBuilder.withArgName((String)"logPeriod");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"specify how many days of kylin logs to extract. Default 3.");
        OPTION_LOG_PERIOD = OptionBuilder.create((String)"logPeriod");
    }
}

