/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.extractor;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.tool.extractor.AbstractInfoExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JStackExtractor
extends AbstractInfoExtractor {
    private static final Logger logger = LoggerFactory.getLogger(JStackExtractor.class);

    public JStackExtractor() {
        this.packageType = "jstack";
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) {
        try {
            File logDir = new File(exportDir, "logs");
            File jstackDumpFile = new File(logDir, String.format(Locale.ROOT, "jstack.log.%s", System.currentTimeMillis()));
            JStackExtractor.dumpKylinJStack(jstackDumpFile);
        }
        catch (IOException e) {
            logger.error("IO Error on dump jstack", (Throwable)e);
        }
    }

    private static void dumpKylinJStack(File outputFile) throws IOException {
        String jstackDumpCmd = String.format(Locale.ROOT, "jstack -l %s", JStackExtractor.getKylinPid());
        Pair result = new CliCommandExecutor().execute(jstackDumpCmd, null);
        FileUtils.writeStringToFile((File)outputFile, (String)((String)result.getSecond()));
    }
}

