/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.util.Collections;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.tool.CubeMetaIngester;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@Ignore
public class CubeMetaIngesterTest
extends LocalFileMetadataTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testHappyIngest() {
        String srcPath = Thread.currentThread().getContextClassLoader().getResource("cloned_cube_and_model.zip").getPath();
        CubeMetaIngester.main((String[])new String[]{"-project", "default", "-srcPath", srcPath});
        ProjectInstance project = ProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject("default");
        Assert.assertEquals((long)1L, (long)Collections.frequency(project.getTables(), "DEFAULT.TEST_KYLIN_FACT"));
        Assert.assertTrue((boolean)project.getModels().contains("cloned_model"));
        Assert.assertTrue((boolean)project.getRealizationEntries().contains(RealizationEntry.create((RealizationType)RealizationType.CUBE, (String)"cloned_cube")));
        CubeMetaIngesterTest.getTestConfig().clearManagers();
        CubeInstance instance = CubeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getCube("cloned_cube");
        Assert.assertTrue((instance != null ? 1 : 0) != 0);
    }

    @Test
    public void testHappyIngest2() {
        String srcPath = Thread.currentThread().getContextClassLoader().getResource("benchmark_meta.zip").getPath();
        CubeMetaIngester.main((String[])new String[]{"-project", "default", "-srcPath", srcPath, "-overwriteTables", "true"});
        ProjectInstance project = ProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject("default");
        Assert.assertEquals((long)1L, (long)Collections.frequency(project.getTables(), "SSB.CUSTOMER"));
        Assert.assertTrue((boolean)project.getModels().contains("benchmark_model"));
        Assert.assertTrue((boolean)project.getRealizationEntries().contains(RealizationEntry.create((RealizationType)RealizationType.CUBE, (String)"benchmark_cube")));
        CubeMetaIngesterTest.getTestConfig().clearManagers();
        CubeInstance instance = CubeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getCube("benchmark_cube");
        Assert.assertTrue((instance != null ? 1 : 0) != 0);
    }

    @Test
    public void testBadIngest() {
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectCause((Matcher)new BaseMatcher<Throwable>(){

            public boolean matches(Object item) {
                return item instanceof IllegalStateException && ((IllegalStateException)item).getMessage().equals("Already exist a model called test_kylin_inner_join_model_desc");
            }

            public void describeTo(Description description) {
            }
        });
        String srcPath = ((Object)((Object)this)).getClass().getResource("/cloned_cube_meta.zip").getPath();
        CubeMetaIngester.main((String[])new String[]{"-project", "default", "-srcPath", srcPath});
    }

    @Test
    public void testProjectNotExist() {
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectCause(CoreMatchers.instanceOf(IllegalStateException.class));
        String srcPath = ((Object)((Object)this)).getClass().getResource("/cloned_cube_meta.zip").getPath();
        CubeMetaIngester.main((String[])new String[]{"-project", "Xdefault", "-srcPath", srcPath});
    }
}

