/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.NavigableSet;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceTool;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.tool.CubeMetaExtractor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CubeMetaExtractorTest
extends LocalFileMetadataTestCase {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testExtractorByPrj() throws IOException {
        this.folder.create();
        File tempDir = this.folder.getRoot();
        String tempDirAbsPath = tempDir.getAbsolutePath();
        ArrayList<String> args = new ArrayList<String>();
        args.add("-destDir");
        args.add(tempDirAbsPath);
        args.add("-project");
        args.add("default");
        args.add("-compress");
        args.add("false");
        args.add("-packagetype");
        args.add("cubemeta");
        String[] cubeMetaArgs = new String[args.size()];
        args.toArray(cubeMetaArgs);
        CubeMetaExtractor cubeMetaExtractor = new CubeMetaExtractor();
        cubeMetaExtractor.execute(cubeMetaArgs);
        File[] files = tempDir.listFiles();
        Preconditions.checkState((files.length == 1 ? 1 : 0) != 0);
        String dumpDir = files[0].getAbsolutePath();
        KylinConfig instanceFromUri = KylinConfig.createInstanceFromUri((String)dumpDir);
        NavigableSet tables = new ResourceTool().list(instanceFromUri, "table");
        NavigableSet tableExds = new ResourceTool().list(instanceFromUri, "table_exd");
        HashSet expectTbl = Sets.newHashSet((Object[])new String[]{"/table/DEFAULT.FIFTY_DIM.json", "/table/DEFAULT.STREAMING_TABLE.json", "/table/DEFAULT.STREAMING_CATEGORY.json", "/table/DEFAULT.TEST_ACCOUNT.json", "/table/DEFAULT.TEST_CATEGORY_GROUPINGS.json", "/table/DEFAULT.TEST_COUNTRY.json", "/table/DEFAULT.TEST_KYLIN_FACT.json", "/table/DEFAULT.TEST_ORDER.json", "/table/EDW.TEST_CAL_DT.json", "/table/EDW.TEST_SELLER_TYPE_DIM.json", "/table/EDW.TEST_SITES.json", "/table/SSB.CUSTOMER.json", "/table/SSB.DATES.json", "/table/SSB.PART.json", "/table/SSB.SUPPLIER.json", "/table/SSB.V_LINEORDER.json", "/table/DEFAULT.STREAMING_V2_TABLE.json", "/table/DEFAULT.STREAMING_V2_USER_INFO_TABLE.json"});
        HashSet expectTblExd = Sets.newHashSet((Object[])new String[]{"/table_exd/DEFAULT.TEST_COUNTRY.json", "/table_exd/DEFAULT.TEST_KYLIN_FACT--default.json"});
        Assert.assertEquals((Object)expectTbl, (Object)tables);
        Assert.assertEquals((Object)expectTblExd, (Object)tableExds);
    }
}

