/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.metrics.systemcube;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metrics.lib.SinkTool;
import org.apache.kylin.tool.metrics.systemcube.SCCreator;
import org.apache.kylin.tool.metrics.systemcube.util.HiveSinkTool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SCCreatorTest
extends LocalFileMetadataTestCase {
    private File tempMetadataDir;

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
        File tempDir = File.createTempFile(((Object)((Object)this)).getClass().getName(), "system");
        FileUtils.forceDelete((File)tempDir);
        this.tempMetadataDir = new File(tempDir, "meta");
    }

    @After
    public void after() throws Exception {
        if (this.tempMetadataDir != null && this.tempMetadataDir.exists()) {
            FileUtils.forceDelete((File)this.tempMetadataDir.getParentFile());
        }
        SCCreatorTest.staticCleanupTestMetadata();
    }

    @Test
    public void testExecute() throws Exception {
        String metadataPath = this.tempMetadataDir.getPath();
        String inputPath = "src/main/resources/SCSinkTools.json";
        SCCreator cli = new SCCreator();
        cli.execute("ADMIN", metadataPath, inputPath);
        Assert.assertTrue((boolean)this.tempMetadataDir.isDirectory());
        KylinConfig local = KylinConfig.createKylinConfig((KylinConfig)KylinConfig.getInstanceFromEnv());
        local.setMetadataUrl(metadataPath);
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)local);
        List cubeList = cubeManager.listAllCubes();
        System.out.println("System cubes: " + cubeList);
        Assert.assertEquals((long)cubeList.size(), (long)5L);
        for (CubeInstance cube : cubeList) {
            Assert.assertTrue((cube.getStatus() != RealizationStatusEnum.DESCBROKEN ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWriteSinkToolsJson() throws Exception {
        HashMap cubeDescOverrideProperties = Maps.newHashMap();
        cubeDescOverrideProperties.put("kylin.cube.algorithm", "INMEM");
        HiveSinkTool hiveSinkTool = new HiveSinkTool();
        hiveSinkTool.setCubeDescOverrideProperties((Map)cubeDescOverrideProperties);
        String outputPath = "src/test/resources/SCSinkTools.json";
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outputPath));
        Object object = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.enableDefaultTyping();
            mapper.writeValue((OutputStream)os, (Object)Sets.newHashSet((Object[])new HiveSinkTool[]{hiveSinkTool}));
        }
        catch (Throwable mapper) {
            object = mapper;
            throw mapper;
        }
        finally {
            if (os != null) {
                if (object != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable mapper) {
                        ((Throwable)object).addSuppressed(mapper);
                    }
                } else {
                    os.close();
                }
            }
        }
        Set<SinkTool> sinkToolSet = this.readSinkToolsJson(outputPath);
        for (SinkTool entry : sinkToolSet) {
            Map props = entry.getCubeDescOverrideProperties();
            for (String key : cubeDescOverrideProperties.keySet()) {
                Assert.assertEquals(props.get(key), cubeDescOverrideProperties.get(key));
            }
        }
    }

    @Test
    public void testReadSinkToolsJson() throws Exception {
        Set<SinkTool> sinkToolSet = this.readSinkToolsJson("src/main/resources/SCSinkTools.json");
        for (SinkTool entry : sinkToolSet) {
            Map props = entry.getCubeDescOverrideProperties();
            Assert.assertEquals(props.get("kylin.cube.algorithm"), (Object)"INMEM");
        }
    }

    private Set<SinkTool> readSinkToolsJson(String jsonPath) throws Exception {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(jsonPath));){
            ObjectMapper mapper = new ObjectMapper();
            mapper.enableDefaultTyping();
            Set set = (Set)mapper.readValue((InputStream)is, HashSet.class);
            return set;
        }
    }
}

