/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.tool.AbstractInfoExtractor;
import org.apache.kylin.tool.common.HadoopConfExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrJobInfoExtractor
extends AbstractInfoExtractor {
    private static final Logger logger = LoggerFactory.getLogger(MrJobInfoExtractor.class);
    private static final Option OPTION_INCLUDE_DETAILS;
    private static final Option OPTION_MR_JOB_ID;
    private static final int HTTP_RETRY = 3;
    private Map<String, String> nodeInfoMap = Maps.newHashMap();
    private String jobHistoryUrlBase;
    private String yarnMasterUrlBase;

    public MrJobInfoExtractor() {
        this.packageType = "MR";
        this.options.addOption(OPTION_INCLUDE_DETAILS);
        this.options.addOption(OPTION_MR_JOB_ID);
    }

    public static void main(String[] args) {
        MrJobInfoExtractor extractor = new MrJobInfoExtractor();
        extractor.execute(args);
    }

    private void extractRestCheckUrl() {
        Configuration conf = HadoopUtil.getCurrentConfiguration();
        this.yarnMasterUrlBase = HadoopConfExtractor.extractYarnMasterUrl(conf);
        this.jobHistoryUrlBase = HadoopConfExtractor.extractJobHistoryUrl(this.yarnMasterUrlBase, conf);
        logger.info("job history url base: " + this.jobHistoryUrlBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHttpResponse(String url) {
        DefaultHttpClient client = new DefaultHttpClient();
        String msg = null;
        int retry_times = 0;
        while (msg == null && retry_times < 3) {
            ++retry_times;
            HttpGet request = new HttpGet(url);
            try {
                request.addHeader("accept", "application/json");
                HttpResponse response = client.execute((HttpUriRequest)request);
                msg = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (Exception e) {
                logger.warn("Failed to fetch http response. Retry={}", (Object)retry_times, (Object)e);
            }
            finally {
                request.releaseConnection();
            }
        }
        return msg;
    }

    private void extractTaskDetail(String taskId, String user, File exportDir, String taskUrl, String urlBase) throws IOException {
        try {
            if (StringUtils.isEmpty((String)taskId)) {
                return;
            }
            String taskUrlBase = taskUrl + taskId;
            File destDir = new File(exportDir, taskId);
            String taskInfo = this.saveHttpResponseQuietly(new File(destDir, "task.json"), taskUrlBase);
            JsonNode taskAttempt = new ObjectMapper().readTree(taskInfo).path("task").path("successfulAttempt");
            String succAttemptId = taskAttempt.textValue();
            String attemptInfo = this.saveHttpResponseQuietly(new File(destDir, "task_attempts.json"), taskUrlBase + "/attempts/" + succAttemptId);
            JsonNode attemptAttempt = new ObjectMapper().readTree(attemptInfo).path("taskAttempt");
            String containerId = attemptAttempt.get("assignedContainerId").textValue();
            String nodeId = this.nodeInfoMap.get(attemptAttempt.get("nodeHttpAddress").textValue());
            this.saveHttpResponseQuietly(new File(destDir, "task_counters.json"), taskUrlBase + "/counters");
            String logUrl = urlBase + "/jobhistory/logs/" + nodeId + "/" + containerId + "/" + succAttemptId + "/" + user + "/syslog/?start=0";
            logger.debug("Fetch task log from url: " + logUrl);
            this.saveHttpResponseQuietly(new File(destDir, "task_log.txt"), logUrl);
        }
        catch (Exception e) {
            logger.warn("Failed to get task counters rest response" + e);
        }
    }

    private String saveHttpResponseQuietly(File dest, String url) {
        String response = null;
        try {
            response = this.getHttpResponse(url);
            FileUtils.forceMkdir((File)dest.getParentFile());
            FileUtils.writeStringToFile((File)dest, (String)response, (Charset)Charset.defaultCharset());
            return response;
        }
        catch (Exception e) {
            logger.warn("Failed to get http response from {}.", (Object)url, (Object)e);
            return response;
        }
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        try {
            boolean includeTaskDetails = optionsHelper.hasOption(OPTION_INCLUDE_DETAILS) ? Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_INCLUDE_DETAILS)) : true;
            String mrJobId = optionsHelper.getOptionValue(OPTION_MR_JOB_ID);
            this.extractRestCheckUrl();
            Preconditions.checkNotNull((Object)this.jobHistoryUrlBase);
            Preconditions.checkNotNull((Object)this.yarnMasterUrlBase);
            String jobUrlPrefix = this.jobHistoryUrlBase + "/ws/v1/history/mapreduce/jobs/" + mrJobId;
            String nodeUrl = this.yarnMasterUrlBase + "/ws/v1/cluster/nodes";
            String nodeResponse = this.getHttpResponse(nodeUrl);
            JsonNode nodes = new ObjectMapper().readTree(nodeResponse).path("nodes").path("node");
            for (JsonNode node : nodes) {
                this.nodeInfoMap.put(node.path("nodeHTTPAddress").textValue(), node.path("id").textValue());
            }
            String jobResponse = this.saveHttpResponseQuietly(new File(exportDir, "job.json"), jobUrlPrefix);
            String user = new ObjectMapper().readTree(jobResponse).path("job").path("user").textValue();
            this.saveHttpResponseQuietly(new File(exportDir, "job_conf.json"), jobUrlPrefix + "/conf");
            this.saveHttpResponseQuietly(new File(exportDir, "job_counters.json"), jobUrlPrefix + "/counters");
            if (includeTaskDetails) {
                this.extractTaskDetails(exportDir, jobUrlPrefix, this.jobHistoryUrlBase, user);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to get mr tasks rest response.", (Throwable)e);
        }
    }

    private void extractTaskDetails(File exportDir, String jobUrlPrefix, String jobUrlBase, String user) {
        try {
            String tasksUrl = jobUrlPrefix + "/tasks/";
            String tasksResponse = this.saveHttpResponseQuietly(new File(exportDir, "job_tasks.json"), tasksUrl);
            JsonNode tasks = new ObjectMapper().readTree(tasksResponse).path("tasks").path("task");
            String firstStartMapId = null;
            String firstStartReduceId = null;
            long firstStartMapTime = Long.MAX_VALUE;
            long firstStartReduceTime = Long.MAX_VALUE;
            String firstEndMapId = null;
            String firstEndReduceId = null;
            long firstEndMapTime = Long.MAX_VALUE;
            long firstEndReduceTime = Long.MAX_VALUE;
            String lastStartMapId = null;
            String lastStartReduceId = null;
            long lastStartMapTime = 0L;
            long lastStartReduceTime = 0L;
            String lastEndMapId = null;
            String lastEndReduceId = null;
            long lastEndMapTime = 0L;
            long lastEndReduceTime = 0L;
            String maxReduceId = null;
            String maxMapId = null;
            long maxMapElapsedTime = 0L;
            long maxReduceElapsedTime = 0L;
            String minReduceId = null;
            String minMapId = null;
            long minMapElapsedTime = Long.MAX_VALUE;
            long minReduceElapsedTime = Long.MAX_VALUE;
            HashSet selectedTaskIds = Sets.newHashSet();
            for (JsonNode node : tasks) {
                if (node.get("type").textValue().equals("MAP")) {
                    if (node.get("elapsedTime").longValue() >= maxMapElapsedTime) {
                        maxMapElapsedTime = node.get("elapsedTime").longValue();
                        maxMapId = node.get("id").textValue();
                    }
                    if (node.get("elapsedTime").longValue() <= minMapElapsedTime) {
                        minMapElapsedTime = node.get("elapsedTime").longValue();
                        minMapId = node.get("id").textValue();
                    }
                    if (node.get("startTime").longValue() <= firstStartMapTime) {
                        firstStartMapTime = node.get("startTime").longValue();
                        firstStartMapId = node.get("id").textValue();
                    }
                    if (node.get("startTime").longValue() >= lastStartMapTime) {
                        lastStartMapTime = node.get("startTime").longValue();
                        lastStartMapId = node.get("id").textValue();
                    }
                    if (node.get("finishTime").longValue() <= firstEndMapTime) {
                        firstEndMapTime = node.get("finishTime").longValue();
                        firstEndMapId = node.get("id").textValue();
                    }
                    if (node.get("finishTime").longValue() >= lastEndMapTime) {
                        lastEndMapTime = node.get("finishTime").longValue();
                        lastEndMapId = node.get("id").textValue();
                    }
                }
                if (!node.get("type").textValue().equals("REDUCE")) continue;
                if (node.get("elapsedTime").longValue() >= maxReduceElapsedTime) {
                    maxReduceElapsedTime = node.get("elapsedTime").longValue();
                    maxReduceId = node.get("id").textValue();
                }
                if (node.get("elapsedTime").longValue() <= minReduceElapsedTime) {
                    minReduceElapsedTime = node.get("elapsedTime").longValue();
                    minReduceId = node.get("id").textValue();
                }
                if (node.get("startTime").longValue() <= firstStartReduceTime) {
                    firstStartReduceTime = node.get("startTime").longValue();
                    firstStartReduceId = node.get("id").textValue();
                }
                if (node.get("startTime").longValue() >= lastStartReduceTime) {
                    lastStartReduceTime = node.get("startTime").longValue();
                    lastStartReduceId = node.get("id").textValue();
                }
                if (node.get("finishTime").longValue() <= firstEndReduceTime) {
                    firstEndReduceTime = node.get("finishTime").longValue();
                    firstEndReduceId = node.get("id").textValue();
                }
                if (node.get("finishTime").longValue() < lastEndReduceTime) continue;
                lastEndReduceTime = node.get("finishTime").longValue();
                lastEndReduceId = node.get("id").textValue();
            }
            selectedTaskIds.add(maxMapId);
            selectedTaskIds.add(maxReduceId);
            selectedTaskIds.add(minMapId);
            selectedTaskIds.add(minReduceId);
            selectedTaskIds.add(firstStartMapId);
            selectedTaskIds.add(firstStartReduceId);
            selectedTaskIds.add(lastStartMapId);
            selectedTaskIds.add(lastStartReduceId);
            selectedTaskIds.add(firstEndMapId);
            selectedTaskIds.add(firstEndReduceId);
            selectedTaskIds.add(lastEndMapId);
            selectedTaskIds.add(lastEndReduceId);
            File tasksDir = new File(exportDir, "tasks");
            FileUtils.forceMkdir((File)tasksDir);
            for (String taskId : selectedTaskIds) {
                this.extractTaskDetail(taskId, user, tasksDir, tasksUrl, jobUrlBase);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to get mr tasks rest response.", (Throwable)e);
        }
    }

    static {
        OptionBuilder.withArgName((String)"includeTasks");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify whether to include mr task details to extract. Default true.");
        OPTION_INCLUDE_DETAILS = OptionBuilder.create((String)"includeTasks");
        OptionBuilder.withArgName((String)"mrJobId");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify MR Job Id");
        OPTION_MR_JOB_ID = OptionBuilder.create((String)"mrJobId");
    }
}

