/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.metrics.systemcube;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metrics.lib.ActiveReservoirReporter;
import org.apache.kylin.metrics.lib.impl.RecordEvent;
import org.apache.kylin.metrics.lib.impl.TimePropertyEnum;
import org.apache.kylin.metrics.lib.impl.hive.HiveReservoirReporter;
import org.apache.kylin.metrics.property.JobPropertyEnum;
import org.apache.kylin.metrics.property.QueryCubePropertyEnum;
import org.apache.kylin.metrics.property.QueryPropertyEnum;
import org.apache.kylin.metrics.property.QueryRPCPropertyEnum;

public class HiveTableCreator {
    public static void main(String[] args) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        System.out.println(HiveTableCreator.generateAllSQL(config));
    }

    public static String generateAllSQL(KylinConfig config) {
        StringBuilder sb = new StringBuilder();
        sb.append(HiveTableCreator.generateDatabaseSQL());
        sb.append("\n");
        sb.append(HiveTableCreator.generateHiveTableSQLForMetricsQuery(config));
        sb.append("\n");
        sb.append(HiveTableCreator.generateHiveTableSQLForMetricsQueryCUBE(config));
        sb.append("\n");
        sb.append(HiveTableCreator.generateHiveTableSQLForMetricsQueryRPC(config));
        sb.append("\n");
        sb.append(HiveTableCreator.generateHiveTableSQLForMetricsJob(config));
        sb.append("\n");
        sb.append(HiveTableCreator.generateHiveTableSQLForMetricsJobException(config));
        return sb.toString();
    }

    public static String generateDatabaseSQL() {
        return "CREATE DATABASE IF NOT EXISTS " + ActiveReservoirReporter.KYLIN_PREFIX + ";\n";
    }

    public static String generateHiveTableSQL(String tableName, List<Pair<String, String>> columns, List<Pair<String, String>> partitionKVs) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("DROP TABLE IF EXISTS " + tableName + ";\n");
        sb.append("\n");
        sb.append("CREATE TABLE " + tableName + "\n");
        sb.append("(\n");
        for (i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            Pair<String, String> column = columns.get(i);
            sb.append((String)column.getFirst() + " " + (String)column.getSecond() + "\n");
        }
        sb.append(")\n");
        if (partitionKVs != null && partitionKVs.size() > 0) {
            sb.append("PARTITIONED BY(");
            for (i = 0; i < partitionKVs.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                Pair<String, String> partitionKV = partitionKVs.get(i);
                sb.append((String)partitionKV.getFirst() + " " + (String)partitionKV.getSecond());
            }
            sb.append(")\n");
        }
        sb.append("ROW FORMAT DELIMITED FIELDS TERMINATED BY ','\n");
        sb.append("STORED AS TEXTFILE;\n");
        return sb.toString();
    }

    public static String generateHiveTableSQLForMetricsQuery(KylinConfig config) {
        String tableName = HiveReservoirReporter.getTableFromSubject((String)config.getKylinMetricsSubjectQuery());
        return HiveTableCreator.generateHiveTableSQL(tableName, HiveTableCreator.getHiveColumnsForMetricsQuery(), HiveTableCreator.getPartitionKVsForHiveTable());
    }

    public static String generateHiveTableSQLForMetricsQueryCUBE(KylinConfig config) {
        String tableName = HiveReservoirReporter.getTableFromSubject((String)config.getKylinMetricsSubjectQueryCube());
        return HiveTableCreator.generateHiveTableSQL(tableName, HiveTableCreator.getHiveColumnsForMetricsQueryCube(), HiveTableCreator.getPartitionKVsForHiveTable());
    }

    public static String generateHiveTableSQLForMetricsQueryRPC(KylinConfig config) {
        String tableName = HiveReservoirReporter.getTableFromSubject((String)config.getKylinMetricsSubjectQueryRpcCall());
        return HiveTableCreator.generateHiveTableSQL(tableName, HiveTableCreator.getHiveColumnsForMetricsQueryRPC(), HiveTableCreator.getPartitionKVsForHiveTable());
    }

    public static String generateHiveTableSQLForMetricsJob(KylinConfig config) {
        String tableName = HiveReservoirReporter.getTableFromSubject((String)config.getKylinMetricsSubjectJob());
        return HiveTableCreator.generateHiveTableSQL(tableName, HiveTableCreator.getHiveColumnsForMetricsJob(), HiveTableCreator.getPartitionKVsForHiveTable());
    }

    public static String generateHiveTableSQLForMetricsJobException(KylinConfig config) {
        String tableName = HiveReservoirReporter.getTableFromSubject((String)config.getKylinMetricsSubjectJobException());
        return HiveTableCreator.generateHiveTableSQL(tableName, HiveTableCreator.getHiveColumnsForMetricsJobException(), HiveTableCreator.getPartitionKVsForHiveTable());
    }

    public static List<Pair<String, String>> getHiveColumnsForMetricsQuery() {
        LinkedList columns = Lists.newLinkedList();
        columns.add(new Pair((Object)QueryPropertyEnum.ID_CODE.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)RecordEvent.RecordReserveKeyEnum.HOST.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QueryPropertyEnum.USER.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QueryPropertyEnum.PROJECT.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QueryPropertyEnum.REALIZATION.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QueryPropertyEnum.REALIZATION_TYPE.toString(), (Object)HiveTypeEnum.HINT.toString()));
        columns.add(new Pair((Object)QueryPropertyEnum.TYPE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QueryPropertyEnum.EXCEPTION.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QueryPropertyEnum.TIME_COST.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryPropertyEnum.CALCITE_RETURN_COUNT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryPropertyEnum.STORAGE_RETURN_COUNT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryPropertyEnum.AGGR_FILTER_COUNT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.addAll(HiveTableCreator.getTimeColumnsForMetrics());
        return columns;
    }

    public static List<Pair<String, String>> getHiveColumnsForMetricsQueryCube() {
        LinkedList columns = Lists.newLinkedList();
        columns.add(new Pair((Object)RecordEvent.RecordReserveKeyEnum.HOST.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QueryCubePropertyEnum.PROJECT.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QueryCubePropertyEnum.CUBE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QueryCubePropertyEnum.SEGMENT.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QueryCubePropertyEnum.CUBOID_SOURCE.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryCubePropertyEnum.CUBOID_TARGET.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryCubePropertyEnum.IF_MATCH.toString(), (Object)HiveTypeEnum.HBOOLEAN.toString()));
        columns.add(new Pair((Object)QueryCubePropertyEnum.FILTER_MASK.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryCubePropertyEnum.IF_SUCCESS.toString(), (Object)HiveTypeEnum.HBOOLEAN.toString()));
        columns.add(new Pair((Object)QueryCubePropertyEnum.WEIGHT_PER_HIT.toString(), (Object)HiveTypeEnum.HDOUBLE.toString()));
        columns.add(new Pair((Object)QueryCubePropertyEnum.CALL_COUNT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryCubePropertyEnum.TIME_SUM.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryCubePropertyEnum.TIME_MAX.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryCubePropertyEnum.SKIP_COUNT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryCubePropertyEnum.SCAN_COUNT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryCubePropertyEnum.RETURN_COUNT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryCubePropertyEnum.AGGR_FILTER_COUNT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryCubePropertyEnum.AGGR_COUNT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.addAll(HiveTableCreator.getTimeColumnsForMetrics());
        return columns;
    }

    public static List<Pair<String, String>> getHiveColumnsForMetricsQueryRPC() {
        LinkedList columns = Lists.newLinkedList();
        columns.add(new Pair((Object)RecordEvent.RecordReserveKeyEnum.HOST.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QueryRPCPropertyEnum.PROJECT.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QueryRPCPropertyEnum.REALIZATION.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QueryRPCPropertyEnum.RPC_SERVER.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QueryRPCPropertyEnum.EXCEPTION.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)QueryRPCPropertyEnum.CALL_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryRPCPropertyEnum.RETURN_COUNT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryRPCPropertyEnum.SCAN_COUNT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryRPCPropertyEnum.SKIP_COUNT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryRPCPropertyEnum.AGGR_FILTER_COUNT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)QueryRPCPropertyEnum.AGGR_COUNT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.addAll(HiveTableCreator.getTimeColumnsForMetrics());
        return columns;
    }

    public static List<Pair<String, String>> getHiveColumnsForMetricsJob() {
        LinkedList columns = Lists.newLinkedList();
        columns.add(new Pair((Object)JobPropertyEnum.ID_CODE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)RecordEvent.RecordReserveKeyEnum.HOST.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.USER.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.PROJECT.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.CUBE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.TYPE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.ALGORITHM.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.BUILD_DURATION.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.SOURCE_SIZE.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.CUBE_SIZE.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.PER_BYTES_TIME_COST.toString(), (Object)HiveTypeEnum.HDOUBLE.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.WAIT_RESOURCE_TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.STEP_DURATION_DISTINCT_COLUMNS.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.STEP_DURATION_DICTIONARY.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.STEP_DURATION_INMEM_CUBING.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.STEP_DURATION_HFILE_CONVERT.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.addAll(HiveTableCreator.getTimeColumnsForMetrics());
        return columns;
    }

    public static List<Pair<String, String>> getHiveColumnsForMetricsJobException() {
        LinkedList columns = Lists.newLinkedList();
        columns.add(new Pair((Object)JobPropertyEnum.ID_CODE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)RecordEvent.RecordReserveKeyEnum.HOST.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.USER.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.PROJECT.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.CUBE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.TYPE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.ALGORITHM.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)JobPropertyEnum.EXCEPTION.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.addAll(HiveTableCreator.getTimeColumnsForMetrics());
        return columns;
    }

    public static List<Pair<String, String>> getPartitionKVsForHiveTable() {
        LinkedList partitionKVs = Lists.newLinkedList();
        partitionKVs.add(new Pair((Object)TimePropertyEnum.DAY_DATE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        return partitionKVs;
    }

    public static List<Pair<String, String>> getTimeColumnsForMetrics() {
        LinkedList columns = Lists.newLinkedList();
        columns.add(new Pair((Object)RecordEvent.RecordReserveKeyEnum.TIME.toString(), (Object)HiveTypeEnum.HBIGINT.toString()));
        columns.add(new Pair((Object)TimePropertyEnum.YEAR.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)TimePropertyEnum.MONTH.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)TimePropertyEnum.WEEK_BEGIN_DATE.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)TimePropertyEnum.DAY_TIME.toString(), (Object)HiveTypeEnum.HSTRING.toString()));
        columns.add(new Pair((Object)TimePropertyEnum.TIME_HOUR.toString(), (Object)HiveTypeEnum.HINT.toString()));
        columns.add(new Pair((Object)TimePropertyEnum.TIME_MINUTE.toString(), (Object)HiveTypeEnum.HINT.toString()));
        columns.add(new Pair((Object)TimePropertyEnum.TIME_SECOND.toString(), (Object)HiveTypeEnum.HINT.toString()));
        return columns;
    }

    static enum HiveTypeEnum {
        HBOOLEAN("boolean"),
        HINT("int"),
        HBIGINT("bigint"),
        HDOUBLE("double"),
        HSTRING("string"),
        HDECIMAL("decimal");

        private final String typeName;

        private HiveTypeEnum(String typeName) {
            this.typeName = typeName;
        }

        public static HiveTypeEnum getByTypeName(String typeName) {
            if (Strings.isNullOrEmpty((String)typeName)) {
                return null;
            }
            for (HiveTypeEnum hiveType : HiveTypeEnum.values()) {
                if (!hiveType.typeName.equals(typeName.toLowerCase(Locale.ROOT))) continue;
                return hiveType;
            }
            return null;
        }

        public String toString() {
            return this.typeName;
        }
    }
}

