/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.metrics.systemcube;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metrics.lib.SinkTool;
import org.apache.kylin.tool.metrics.systemcube.util.HiveSinkTool;

public class CubeInstanceCreator {
    public static void main(String[] args) throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        CubeInstance cubeInstance = CubeInstanceCreator.generateKylinCubeInstanceForMetricsQuery("ADMIN", config, new HiveSinkTool());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(buf);
        CubeManager.CUBE_SERIALIZER.serialize((RootPersistentEntity)cubeInstance, dout);
        dout.close();
        buf.close();
        System.out.println(buf.toString("UTF-8"));
    }

    public static CubeInstance generateKylinCubeInstanceForMetricsQuery(String owner, KylinConfig config, SinkTool sinkTool) {
        return CubeInstanceCreator.generateKylinCubeInstance(owner, sinkTool.getTableNameForMetrics(config.getKylinMetricsSubjectQuery()));
    }

    public static CubeInstance generateKylinCubeInstanceForMetricsQueryCube(String owner, KylinConfig config, SinkTool sinkTool) {
        return CubeInstanceCreator.generateKylinCubeInstance(owner, sinkTool.getTableNameForMetrics(config.getKylinMetricsSubjectQueryCube()));
    }

    public static CubeInstance generateKylinCubeInstanceForMetricsQueryRPC(String owner, KylinConfig config, SinkTool sinkTool) {
        return CubeInstanceCreator.generateKylinCubeInstance(owner, sinkTool.getTableNameForMetrics(config.getKylinMetricsSubjectQueryRpcCall()));
    }

    public static CubeInstance generateKylinCubeInstanceForMetricsJob(String owner, KylinConfig config, SinkTool sinkTool) {
        return CubeInstanceCreator.generateKylinCubeInstance(owner, sinkTool.getTableNameForMetrics(config.getKylinMetricsSubjectJob()));
    }

    public static CubeInstance generateKylinCubeInstanceForMetricsJobException(String owner, KylinConfig config, SinkTool sinkTool) {
        return CubeInstanceCreator.generateKylinCubeInstance(owner, sinkTool.getTableNameForMetrics(config.getKylinMetricsSubjectJobException()));
    }

    public static CubeInstance generateKylinCubeInstance(String owner, String tableName) {
        CubeInstance cubeInstance = new CubeInstance();
        cubeInstance.setName(tableName.replace('.', '_'));
        cubeInstance.setSegments(new Segments());
        cubeInstance.setDescName(tableName.replace('.', '_'));
        cubeInstance.setStatus(RealizationStatusEnum.DISABLED);
        cubeInstance.setOwner(owner);
        cubeInstance.setCreateTimeUTC(0L);
        cubeInstance.updateRandomUuid();
        return cubeInstance;
    }
}

