/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceTool;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.job.dao.ExecutableDao;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.tool.AbstractInfoExtractor;
import org.apache.kylin.tool.ClientEnvExtractor;
import org.apache.kylin.tool.CubeMetaExtractor;
import org.apache.kylin.tool.KylinLogExtractor;
import org.apache.kylin.tool.MrJobInfoExtractor;
import org.apache.kylin.tool.util.ToolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobDiagnosisInfoCLI
extends AbstractInfoExtractor {
    private static final Logger logger = LoggerFactory.getLogger(JobDiagnosisInfoCLI.class);
    private static final Option OPTION_JOB_ID;
    private static final Option OPTION_INCLUDE_CUBE;
    private static final Option OPTION_INCLUDE_YARN_LOGS;
    private static final Option OPTION_INCLUDE_CLIENT;
    private static final Option OPTION_INCLUDE_CONF;
    List<String> requiredResources = Lists.newArrayList();
    List<String> yarnLogsResources = Lists.newArrayList();
    private KylinConfig kylinConfig;
    private ExecutableDao executableDao;

    public JobDiagnosisInfoCLI() {
        this.packageType = "job";
        this.options.addOption(OPTION_JOB_ID);
        this.options.addOption(OPTION_INCLUDE_CUBE);
        this.options.addOption(OPTION_INCLUDE_CLIENT);
        this.options.addOption(OPTION_INCLUDE_YARN_LOGS);
        this.options.addOption(OPTION_INCLUDE_CONF);
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.executableDao = ExecutableDao.getInstance((KylinConfig)this.kylinConfig);
    }

    public static void main(String[] args) {
        JobDiagnosisInfoCLI extractor = new JobDiagnosisInfoCLI();
        extractor.execute(args);
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        String cubeName;
        String kylinJobId = optionsHelper.getOptionValue(OPTION_JOB_ID);
        boolean includeCube = optionsHelper.hasOption(OPTION_INCLUDE_CUBE) ? Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_INCLUDE_CUBE)) : true;
        boolean includeYarnLogs = optionsHelper.hasOption(OPTION_INCLUDE_YARN_LOGS) ? Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_INCLUDE_YARN_LOGS)) : true;
        boolean includeClient = optionsHelper.hasOption(OPTION_INCLUDE_CLIENT) ? Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_INCLUDE_CLIENT)) : true;
        boolean includeConf = optionsHelper.hasOption(OPTION_INCLUDE_CONF) ? Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_INCLUDE_CONF)) : true;
        logger.info("Start to dump job output");
        ExecutablePO executablePO = this.executableDao.getJob(kylinJobId);
        this.addRequired("/execute/" + kylinJobId);
        this.addRequired("/execute_output/" + kylinJobId);
        for (ExecutablePO kylinTask : executablePO.getTasks()) {
            this.addRequired("/execute/" + kylinTask.getUuid());
            this.addRequired("/execute_output/" + kylinTask.getUuid());
            if (!includeYarnLogs) continue;
            this.yarnLogsResources.add(kylinTask.getUuid());
        }
        this.extractResources(exportDir);
        if (includeCube && !StringUtils.isEmpty((String)(cubeName = (String)executablePO.getParams().get("cubeName")))) {
            File metaDir = new File(exportDir, "cube");
            FileUtils.forceMkdir((File)metaDir);
            Object[] cubeMetaArgs = new String[]{"-packagetype", "cubemeta", "-cube", cubeName, "-destDir", new File(metaDir, cubeName).getAbsolutePath(), "-includeJobs", "false", "-compress", "false", "-submodule", "true"};
            logger.info("Start to extract related cube: " + StringUtils.join((Object[])cubeMetaArgs));
            CubeMetaExtractor cubeMetaExtractor = new CubeMetaExtractor();
            logger.info("CubeMetaExtractor args: " + Arrays.toString(cubeMetaArgs));
            cubeMetaExtractor.execute((String[])cubeMetaArgs);
        }
        if (includeYarnLogs) {
            logger.info("Start to dump mr job info: " + kylinJobId);
            File yarnDir = new File(exportDir, "yarn");
            FileUtils.forceMkdir((File)yarnDir);
            for (String stepId : this.yarnLogsResources) {
                this.extractJobInfo(stepId, new File(yarnDir, stepId));
                this.extractJobLog(stepId, new File(yarnDir, stepId), true);
            }
        }
        if (includeClient) {
            Object[] clientArgs = new String[]{"-destDir", new File(exportDir, "client").getAbsolutePath(), "-compress", "false", "-submodule", "true"};
            ClientEnvExtractor clientEnvExtractor = new ClientEnvExtractor();
            logger.info("ClientEnvExtractor args: " + Arrays.toString(clientArgs));
            clientEnvExtractor.execute((String[])clientArgs);
        }
        if (includeConf) {
            logger.info("Start to extract kylin conf files.");
            try {
                FileUtils.copyDirectoryToDirectory((File)new File(ToolUtil.getConfFolder()), (File)exportDir);
            }
            catch (Exception e) {
                logger.warn("Error in export conf.", (Throwable)e);
            }
        }
        Object[] logsArgs = new String[]{"-destDir", new File(exportDir, "logs").getAbsolutePath(), "-compress", "false", "-submodule", "true"};
        KylinLogExtractor logExtractor = new KylinLogExtractor();
        logger.info("KylinLogExtractor args: " + Arrays.toString(logsArgs));
        logExtractor.execute((String[])logsArgs);
    }

    private void extractResources(File destDir) {
        logger.info("The resource paths going to be extracted:");
        for (String s : this.requiredResources) {
            logger.info(s + "(required)");
        }
        try {
            KylinConfig srcConfig = KylinConfig.getInstanceFromEnv();
            KylinConfig dstConfig = KylinConfig.createInstanceFromUri((String)destDir.getAbsolutePath());
            new ResourceTool().copy(srcConfig, dstConfig, this.requiredResources);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to extract job resources. ", e);
        }
    }

    private void extractJobLog(String taskId, File destDir, boolean onlyFail) throws Exception {
        Map jobInfo = this.executableDao.getJobOutput(taskId).getInfo();
        FileUtils.forceMkdir((File)destDir);
        if (jobInfo.containsKey("mr_job_id")) {
            String applicationId = ((String)jobInfo.get("mr_job_id")).replace("job", "application");
            if (!onlyFail || !this.isYarnAppSucc(applicationId)) {
                File destFile = new File(destDir, applicationId + ".log");
                String yarnCmd = "yarn logs -applicationId " + applicationId + " > " + destFile.getAbsolutePath();
                logger.debug(yarnCmd);
                try {
                    this.kylinConfig.getCliCommandExecutor().execute(yarnCmd);
                }
                catch (Exception ex) {
                    logger.warn("Failed to get yarn logs. ", (Throwable)ex);
                }
            }
        }
    }

    private void extractJobInfo(String taskId, File destDir) throws Exception {
        Map jobInfo = this.executableDao.getJobOutput(taskId).getInfo();
        if (jobInfo.containsKey("mr_job_id")) {
            String mrJobId = (String)jobInfo.get("mr_job_id");
            FileUtils.forceMkdir((File)destDir);
            String[] mrJobArgs = new String[]{"-mrJobId", mrJobId, "-destDir", destDir.getAbsolutePath(), "-compress", "false", "-submodule", "true"};
            new MrJobInfoExtractor().execute(mrJobArgs);
        }
    }

    private boolean isYarnAppSucc(String applicationId) throws IOException {
        String yarnCmd = "yarn application -status " + applicationId;
        String cmdOutput = (String)this.kylinConfig.getCliCommandExecutor().execute(yarnCmd).getSecond();
        HashMap params = Maps.newHashMap();
        String[] cmdOutputLines = StringUtil.split((String)cmdOutput, (String)"\n");
        for (String cmdOutputLine : cmdOutputLines) {
            String[] pair = StringUtil.split((String)cmdOutputLine, (String)":");
            if (pair.length < 2) continue;
            params.put(pair[0].trim(), pair[1].trim());
        }
        for (Map.Entry entry : params.entrySet()) {
            logger.info((String)entry.getKey() + ":" + (String)entry.getValue());
        }
        if (params.containsKey("State") && ((String)params.get("State")).equals("RUNNING")) {
            return true;
        }
        return params.containsKey("Final-State") && ((String)params.get("Final-State")).equals("SUCCEEDED");
    }

    private void addRequired(String record) {
        logger.info("adding required resource {}", (Object)record);
        this.requiredResources.add(record);
    }

    static {
        OptionBuilder.withArgName((String)"jobId");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"specify the Job ID to extract information. ");
        OPTION_JOB_ID = OptionBuilder.create((String)"jobId");
        OptionBuilder.withArgName((String)"includeCube");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"set this to true if want to extract related cube info too. Default true");
        OPTION_INCLUDE_CUBE = OptionBuilder.create((String)"includeCube");
        OptionBuilder.withArgName((String)"includeYarnLogs");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"set this to true if want to extract related yarn logs too. Default true");
        OPTION_INCLUDE_YARN_LOGS = OptionBuilder.create((String)"includeYarnLogs");
        OptionBuilder.withArgName((String)"includeClient");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify whether to include client info to extract. Default true.");
        OPTION_INCLUDE_CLIENT = OptionBuilder.create((String)"includeClient");
        OptionBuilder.withArgName((String)"includeConf");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify whether to include conf files to extract. Default true.");
        OPTION_INCLUDE_CONF = OptionBuilder.create((String)"includeConf");
    }
}

