/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.tool.AbstractInfoExtractor;
import org.apache.kylin.tool.ClientEnvExtractor;
import org.apache.kylin.tool.CubeMetaExtractor;
import org.apache.kylin.tool.JobInstanceExtractor;
import org.apache.kylin.tool.KylinLogExtractor;
import org.apache.kylin.tool.util.ToolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosisInfoCLI
extends AbstractInfoExtractor {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosisInfoCLI.class);
    private static final int DEFAULT_PERIOD = 3;
    private static final Option OPTION_PROJECT;
    private static final Option OPTION_INCLUDE_CONF;
    private static final Option OPTION_INCLUDE_HBASE;
    private static final Option OPTION_INCLUDE_CLIENT;
    private static final Option OPTION_INCLUDE_JOB;
    private static final Option OPTION_THREADS;
    private static final Option OPTION_PERIOD;
    private static final int DEFAULT_PARALLEL_SIZE = 4;
    private ExecutorService executorService;

    public DiagnosisInfoCLI() {
        this.packageType = "project";
        this.options.addOption(OPTION_PROJECT);
        this.options.addOption(OPTION_INCLUDE_CONF);
        this.options.addOption(OPTION_INCLUDE_HBASE);
        this.options.addOption(OPTION_INCLUDE_CLIENT);
        this.options.addOption(OPTION_INCLUDE_JOB);
        this.options.addOption(OPTION_PERIOD);
    }

    public static void main(String[] args) {
        DiagnosisInfoCLI diagnosisInfoCLI = new DiagnosisInfoCLI();
        diagnosisInfoCLI.execute(args);
    }

    private List<String> getProjects(String projectSeed) {
        LinkedList result = Lists.newLinkedList();
        if (projectSeed.equalsIgnoreCase("-all")) {
            ProjectManager projectManager = ProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            for (ProjectInstance projectInstance : projectManager.listAllProjects()) {
                result.add(projectInstance.getName());
            }
        } else {
            result.add(projectSeed);
        }
        if (result.isEmpty()) {
            throw new RuntimeException("No project to extract.");
        }
        return result;
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, final File exportDir) throws IOException {
        String projectInput = optionsHelper.getOptionValue(this.options.getOption("project"));
        boolean includeConf = optionsHelper.hasOption(OPTION_INCLUDE_CONF) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_CONF)) : true;
        boolean includeHBase = optionsHelper.hasOption(OPTION_INCLUDE_HBASE) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_HBASE)) : true;
        boolean includeClient = optionsHelper.hasOption(OPTION_INCLUDE_CLIENT) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_CLIENT)) : true;
        boolean includeJob = optionsHelper.hasOption(OPTION_INCLUDE_JOB) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_JOB)) : true;
        int threadsNum = optionsHelper.hasOption(OPTION_THREADS) ? Integer.valueOf(optionsHelper.getOptionValue(OPTION_THREADS)) : 4;
        final String projectNames = StringUtils.join(this.getProjects(projectInput), (String)",");
        final int period = optionsHelper.hasOption(OPTION_PERIOD) ? Integer.valueOf(optionsHelper.getOptionValue(OPTION_PERIOD)) : 3;
        logger.info("Start diagnosis info extraction in {} threads.", (Object)threadsNum);
        this.executorService = Executors.newFixedThreadPool(threadsNum);
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                logger.info("Start to extract metadata.");
                try {
                    Object[] cubeMetaArgs = new String[]{"-packagetype", "cubemeta", "-destDir", new File(exportDir, "metadata").getAbsolutePath(), "-project", projectNames, "-compress", "false", "-includeJobs", "false", "-submodule", "true"};
                    CubeMetaExtractor cubeMetaExtractor = new CubeMetaExtractor();
                    logger.info("CubeMetaExtractor args: " + Arrays.toString(cubeMetaArgs));
                    cubeMetaExtractor.execute((String[])cubeMetaArgs);
                }
                catch (Exception e) {
                    logger.error("Error in export metadata.", (Throwable)e);
                }
            }
        });
        if (includeJob) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    logger.info("Start to extract jobs.");
                    try {
                        String[] jobArgs = new String[]{"-destDir", new File(exportDir, "jobs").getAbsolutePath(), "-period", Integer.toString(period), "-compress", "false", "-submodule", "true"};
                        JobInstanceExtractor jobInstanceExtractor = new JobInstanceExtractor();
                        jobInstanceExtractor.execute(jobArgs);
                    }
                    catch (Exception e) {
                        logger.error("Error in export jobs.", (Throwable)e);
                    }
                }
            });
        }
        if (includeHBase) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    logger.info("Start to extract HBase usage.");
                    try {
                        Object[] hbaseArgs = new String[]{"-destDir", new File(exportDir, "hbase").getAbsolutePath(), "-project", projectNames, "-compress", "false", "-submodule", "true"};
                        logger.info("HBaseUsageExtractor args: " + Arrays.toString(hbaseArgs));
                        Object extractor = ClassUtil.newInstance((String)"org.apache.kylin.tool.HBaseUsageExtractor");
                        Method execute = extractor.getClass().getMethod("execute", String[].class);
                        execute.invoke(extractor, new Object[]{hbaseArgs});
                    }
                    catch (Throwable e) {
                        logger.error("Error in export HBase usage.", e);
                    }
                }
            });
        }
        if (includeConf) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    logger.info("Start to extract kylin conf files.");
                    try {
                        File destConfDir = new File(exportDir, "conf");
                        FileUtils.forceMkdir((File)destConfDir);
                        File srcConfDir = new File(ToolUtil.getConfFolder());
                        Preconditions.checkState((boolean)srcConfDir.exists(), (Object)("Cannot find config dir: " + srcConfDir.getAbsolutePath()));
                        File[] confFiles = srcConfDir.listFiles();
                        if (confFiles != null) {
                            for (File confFile : confFiles) {
                                FileUtils.copyFileToDirectory((File)confFile, (File)destConfDir);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in export conf.", (Throwable)e);
                    }
                }
            });
        }
        if (includeClient) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object[] clientArgs = new String[]{"-destDir", new File(exportDir, "client").getAbsolutePath(), "-compress", "false", "-submodule", "true"};
                        ClientEnvExtractor clientEnvExtractor = new ClientEnvExtractor();
                        logger.info("ClientEnvExtractor args: " + Arrays.toString(clientArgs));
                        clientEnvExtractor.execute((String[])clientArgs);
                    }
                    catch (Exception e) {
                        logger.error("Error in export client info.", (Throwable)e);
                    }
                }
            });
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                logger.info("Start to extract logs.");
                try {
                    Object[] logsArgs = new String[]{"-destDir", new File(exportDir, "logs").getAbsolutePath(), "-logPeriod", Integer.toString(period), "-compress", "false", "-submodule", "true"};
                    KylinLogExtractor logExtractor = new KylinLogExtractor();
                    logger.info("KylinLogExtractor args: " + Arrays.toString(logsArgs));
                    logExtractor.execute((String[])logsArgs);
                }
                catch (Exception e) {
                    logger.error("Error in export logs.", (Throwable)e);
                }
            }
        });
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Diagnosis info dump interrupted.", e);
        }
    }

    static {
        OptionBuilder.withArgName((String)"project");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify realizations in which project to extract");
        OPTION_PROJECT = OptionBuilder.create((String)"project");
        OptionBuilder.withArgName((String)"includeConf");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify whether to include conf files to extract. Default true.");
        OPTION_INCLUDE_CONF = OptionBuilder.create((String)"includeConf");
        OptionBuilder.withArgName((String)"includeHBase");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify whether to include hbase files to extract. Default true.");
        OPTION_INCLUDE_HBASE = OptionBuilder.create((String)"includeHBase");
        OptionBuilder.withArgName((String)"includeClient");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify whether to include client info to extract. Default true.");
        OPTION_INCLUDE_CLIENT = OptionBuilder.create((String)"includeClient");
        OptionBuilder.withArgName((String)"includeJobs");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify whether to include job info to extract. Default true.");
        OPTION_INCLUDE_JOB = OptionBuilder.create((String)"includeJobs");
        OptionBuilder.withArgName((String)"threads");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify number of threads for parallel extraction.");
        OPTION_THREADS = OptionBuilder.create((String)"threads");
        OptionBuilder.withArgName((String)"period");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"specify how many days of kylin info to extract. Default 3.");
        OPTION_PERIOD = OptionBuilder.create((String)"period");
    }
}

