/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.apache.kylin.storage.hybrid.HybridManager;
import org.apache.kylin.tool.HybridCubeCLI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class HybridCubeCLITest
extends LocalFileMetadataTestCase {
    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void test1Create() throws IOException {
        HybridManager hybridManager = HybridManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        Assert.assertNull((Object)hybridManager.getHybridInstance("ssb_hybrid"));
        HybridCubeCLI.main((String[])new String[]{"-name", "ssb_hybrid", "-project", "default", "-model", "ssb", "-cubes", "ssb_cube1,ssb_cube2", "-action", "create"});
        HybridInstance hybridInstance = hybridManager.getHybridInstance("ssb_hybrid");
        Assert.assertNotNull((Object)hybridInstance);
        Assert.assertEquals((Object)"ssb_hybrid", (Object)hybridInstance.getName());
        Assert.assertEquals((long)2L, (long)hybridInstance.getRealizationEntries().size());
    }

    @Test
    public void test2Update() throws IOException {
        HybridManager hybridManager = HybridManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        Assert.assertNull((Object)hybridManager.getHybridInstance("ssb_hybrid"));
        HybridCubeCLI.main((String[])new String[]{"-name", "ssb_hybrid", "-project", "default", "-model", "ssb", "-cubes", "ssb_cube1,ssb_cube2", "-action", "create"});
        HybridInstance hybridInstance = hybridManager.getHybridInstance("ssb_hybrid");
        Assert.assertNotNull((Object)hybridManager.getHybridInstance("ssb_hybrid"));
        Assert.assertEquals((Object)"ssb_hybrid", (Object)hybridInstance.getName());
        Assert.assertEquals((long)2L, (long)hybridInstance.getRealizationEntries().size());
        HybridCubeCLI.main((String[])new String[]{"-name", "ssb_hybrid", "-project", "default", "-model", "ssb", "-cubes", "ssb_cube1,ssb_cube2,ssb_cube3", "-action", "update"});
        hybridInstance = hybridManager.getHybridInstance("ssb_hybrid");
        Assert.assertNotNull((Object)hybridInstance);
        Assert.assertEquals((Object)"ssb_hybrid", (Object)hybridInstance.getName());
        Assert.assertEquals((long)3L, (long)hybridInstance.getRealizationEntries().size());
    }

    @Test
    public void test3Delete() throws IOException {
        HybridManager hybridManager = HybridManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        Assert.assertNull((Object)hybridManager.getHybridInstance("ssb_hybrid"));
        HybridCubeCLI.main((String[])new String[]{"-name", "ssb_hybrid", "-project", "default", "-model", "ssb", "-cubes", "ssb_cube1,ssb_cube2", "-action", "create"});
        Assert.assertNotNull((Object)hybridManager.getHybridInstance("ssb_hybrid"));
        HybridCubeCLI.main((String[])new String[]{"-name", "ssb_hybrid", "-project", "default", "-model", "ssb", "-action", "delete"});
        HybridInstance hybridInstance = hybridManager.getHybridInstance("ssb_hybrid");
        Assert.assertNull((Object)hybridInstance);
        Assert.assertEquals((long)0L, (long)ProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).findProjects(RealizationType.HYBRID, "ssb_hybrid").size());
    }
}

