/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.metrics.systemcube;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metrics.lib.ActiveReservoirReporter;
import org.apache.kylin.metrics.lib.SinkTool;
import org.apache.kylin.tool.metrics.systemcube.HiveTableCreator;
import org.apache.kylin.tool.metrics.systemcube.util.HiveSinkTool;

public class KylinTableCreator {
    public static void main(String[] args) throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        TableDesc kylinTable = KylinTableCreator.generateKylinTableForMetricsQuery(config, new HiveSinkTool());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(buf);
        TableMetadataManager.TABLE_SERIALIZER.serialize((RootPersistentEntity)kylinTable, dout);
        dout.close();
        buf.close();
        System.out.println(buf.toString());
    }

    public static TableDesc generateKylinTableForMetricsQuery(KylinConfig kylinConfig, SinkTool sinkTool) {
        LinkedList columns = Lists.newLinkedList();
        columns.addAll(HiveTableCreator.getHiveColumnsForMetricsQuery());
        columns.addAll(HiveTableCreator.getPartitionKVsForHiveTable());
        return KylinTableCreator.generateKylinTable(sinkTool, kylinConfig.getKylinMetricsSubjectQuery(), columns);
    }

    public static TableDesc generateKylinTableForMetricsQueryCube(KylinConfig kylinConfig, SinkTool sinkTool) {
        LinkedList columns = Lists.newLinkedList();
        columns.addAll(HiveTableCreator.getHiveColumnsForMetricsQueryCube());
        columns.addAll(HiveTableCreator.getPartitionKVsForHiveTable());
        return KylinTableCreator.generateKylinTable(sinkTool, kylinConfig.getKylinMetricsSubjectQueryCube(), columns);
    }

    public static TableDesc generateKylinTableForMetricsQueryRPC(KylinConfig kylinConfig, SinkTool sinkTool) {
        LinkedList columns = Lists.newLinkedList();
        columns.addAll(HiveTableCreator.getHiveColumnsForMetricsQueryRPC());
        columns.addAll(HiveTableCreator.getPartitionKVsForHiveTable());
        return KylinTableCreator.generateKylinTable(sinkTool, kylinConfig.getKylinMetricsSubjectQueryRpcCall(), columns);
    }

    public static TableDesc generateKylinTableForMetricsJob(KylinConfig kylinConfig, SinkTool sinkTool) {
        LinkedList columns = Lists.newLinkedList();
        columns.addAll(HiveTableCreator.getHiveColumnsForMetricsJob());
        columns.addAll(HiveTableCreator.getPartitionKVsForHiveTable());
        return KylinTableCreator.generateKylinTable(sinkTool, kylinConfig.getKylinMetricsSubjectJob(), columns);
    }

    public static TableDesc generateKylinTableForMetricsJobException(KylinConfig kylinConfig, SinkTool sinkTool) {
        LinkedList columns = Lists.newLinkedList();
        columns.addAll(HiveTableCreator.getHiveColumnsForMetricsJobException());
        columns.addAll(HiveTableCreator.getPartitionKVsForHiveTable());
        return KylinTableCreator.generateKylinTable(sinkTool, kylinConfig.getKylinMetricsSubjectJobException(), columns);
    }

    public static TableDesc generateKylinTable(SinkTool sinkTool, String subject, List<Pair<String, String>> columns) {
        TableDesc kylinTable = new TableDesc();
        Pair tableNameSplits = ActiveReservoirReporter.getTableNameSplits((String)sinkTool.getTableNameForMetrics(subject));
        kylinTable.setUuid(UUID.randomUUID().toString());
        kylinTable.setDatabase((String)tableNameSplits.getFirst());
        kylinTable.setName((String)tableNameSplits.getSecond());
        kylinTable.setTableType(null);
        kylinTable.setLastModified(0L);
        kylinTable.setSourceType(sinkTool.getSourceType());
        ColumnDesc[] columnDescs = new ColumnDesc[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            columnDescs[i] = new ColumnDesc();
            Pair<String, String> entry = columns.get(i);
            columnDescs[i].setId(Integer.toString(i + 1));
            columnDescs[i].setName((String)entry.getFirst());
            columnDescs[i].setDatatype((String)entry.getSecond());
        }
        kylinTable.setColumns(columnDescs);
        kylinTable.init("KYLIN_SYSTEM");
        return kylinTable;
    }
}

