/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.restclient.RestClient;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.dict.lookup.SnapshotManager;
import org.apache.kylin.dict.lookup.SnapshotTable;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.tool.CubeMigrationCheckCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeMigrationCLI
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(CubeMigrationCLI.class);
    protected List<Opt> operations;
    protected KylinConfig srcConfig;
    protected KylinConfig dstConfig;
    protected ResourceStore srcStore;
    protected ResourceStore dstStore;
    protected FileSystem hdfsFS;
    private HBaseAdmin hbaseAdmin;
    protected boolean doAclCopy = false;
    protected boolean doOverwrite = false;
    protected boolean doMigrateSegment = true;
    protected String dstProject;
    private static final String ACL_PREFIX = "/acl/";

    public static void main(String[] args) throws IOException, InterruptedException {
        CubeMigrationCLI cli = new CubeMigrationCLI();
        if (args.length != 8 && args.length != 9) {
            cli.usage();
            System.exit(1);
        }
        if (args.length == 8) {
            cli.moveCube(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
        } else if (args.length == 9) {
            cli.moveCube(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8]);
        }
    }

    protected void usage() {
        System.out.println("Usage: CubeMigrationCLI srcKylinConfigUri dstKylinConfigUri cubeName projectName copyAclOrNot purgeOrNot overwriteIfExists realExecute migrateSegmentOrNot");
        System.out.println("srcKylinConfigUri: The KylinConfig of the cube\u2019s source \ndstKylinConfigUri: The KylinConfig of the cube\u2019s new home \ncubeName: the name of cube to be migrated. \nprojectName: The target project in the target environment.(Make sure it exist) \ncopyAclOrNot: true or false: whether copy cube ACL to target environment. \npurgeOrNot: true or false: whether purge the cube from src server after the migration. \noverwriteIfExists: overwrite cube if it already exists in the target environment. \nrealExecute: if false, just print the operations to take, if true, do the real migration. \nmigrateSegmentOrNot:(optional) true or false: whether copy segment data to target environment. \n");
    }

    public void moveCube(String srcCfgUri, String dstCfgUri, String cubeName, String projectName, String copyAcl, String purgeAndDisable, String overwriteIfExists, String realExecute) throws IOException, InterruptedException {
        this.moveCube(KylinConfig.createInstanceFromUri((String)srcCfgUri), KylinConfig.createInstanceFromUri((String)dstCfgUri), cubeName, projectName, copyAcl, purgeAndDisable, overwriteIfExists, realExecute);
    }

    public void moveCube(KylinConfig srcCfg, KylinConfig dstCfg, String cubeName, String projectName, String copyAcl, String purgeAndDisable, String overwriteIfExists, String realExecute) throws IOException, InterruptedException {
        this.moveCube(srcCfg, dstCfg, cubeName, projectName, Boolean.parseBoolean(copyAcl), Boolean.parseBoolean(purgeAndDisable), Boolean.parseBoolean(overwriteIfExists), Boolean.parseBoolean(realExecute), true);
    }

    public void moveCube(String srcCfgUri, String dstCfgUri, String cubeName, String projectName, String copyAcl, String purgeAndDisable, String overwriteIfExists, String realExecute, String migrateSegment) throws IOException, InterruptedException {
        this.moveCube(KylinConfig.createInstanceFromUri((String)srcCfgUri), KylinConfig.createInstanceFromUri((String)dstCfgUri), cubeName, projectName, Boolean.parseBoolean(copyAcl), Boolean.parseBoolean(purgeAndDisable), Boolean.parseBoolean(overwriteIfExists), Boolean.parseBoolean(realExecute), Boolean.parseBoolean(migrateSegment));
    }

    public void moveCube(KylinConfig srcCfg, KylinConfig dstCfg, String cubeName, String projectName, boolean copyAcl, boolean purgeAndDisable, boolean overwriteIfExists, boolean realExecute, boolean migrateSegment) throws IOException, InterruptedException {
        this.doAclCopy = copyAcl;
        this.doOverwrite = overwriteIfExists;
        this.doMigrateSegment = migrateSegment;
        this.srcConfig = srcCfg;
        this.srcStore = ResourceStore.getStore((KylinConfig)this.srcConfig);
        this.dstConfig = dstCfg;
        this.dstStore = ResourceStore.getStore((KylinConfig)this.dstConfig);
        this.dstProject = projectName;
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)this.srcConfig);
        CubeInstance cube = cubeManager.getCube(cubeName);
        logger.info("cube to be moved is : " + cubeName);
        if (migrateSegment) {
            this.checkCubeState(cube);
        }
        this.checkAndGetHbaseUrl();
        Configuration conf = HBaseConnection.getCurrentHBaseConfiguration();
        this.hbaseAdmin = new HBaseAdmin(conf);
        this.hdfsFS = HadoopUtil.getWorkingFileSystem();
        this.operations = new ArrayList<Opt>();
        this.copyFilesInMetaStore(cube);
        if (migrateSegment) {
            this.renameFoldersInHdfs(cube);
            this.changeHtableHost(cube);
        } else {
            this.clearSegments(cubeName);
        }
        this.addCubeAndModelIntoProject(cube, cubeName);
        if (migrateSegment && purgeAndDisable) {
            this.purgeAndDisable(cubeName);
        }
        if (realExecute) {
            this.doOpts();
            if (migrateSegment) {
                this.checkMigrationSuccess(this.dstConfig, cubeName, true);
            }
            this.updateMeta(this.dstConfig, projectName, cubeName, cube.getModel());
        } else {
            this.showOpts();
        }
    }

    public void checkMigrationSuccess(KylinConfig kylinConfig, String cubeName, Boolean ifFix) throws IOException {
        CubeMigrationCheckCLI checkCLI = new CubeMigrationCheckCLI(kylinConfig, ifFix);
        checkCLI.execute(cubeName);
    }

    protected void checkCubeState(CubeInstance cube) {
        if (cube.getStatus() != RealizationStatusEnum.READY) {
            throw new IllegalStateException("Cannot migrate cube that is not in READY state.");
        }
        for (CubeSegment segment : cube.getSegments()) {
            if (segment.getStatus() == SegmentStatusEnum.READY) continue;
            throw new IllegalStateException("At least one segment is not in READY state");
        }
    }

    protected void checkAndGetHbaseUrl() {
        StorageURL srcMetadataUrl = this.srcConfig.getMetadataUrl();
        StorageURL dstMetadataUrl = this.dstConfig.getMetadataUrl();
        logger.info("src metadata url is " + srcMetadataUrl);
        logger.info("dst metadata url is " + dstMetadataUrl);
        if (!"hbase".equals(srcMetadataUrl.getScheme()) || !"hbase".equals(dstMetadataUrl.getScheme())) {
            throw new IllegalStateException("Both metadata urls should be hbase metadata url");
        }
    }

    protected void renameFoldersInHdfs(CubeInstance cube) throws IOException {
        for (CubeSegment segment : cube.getSegments()) {
            String jobUuid = segment.getLastBuildJobID();
            String src = JobBuilderSupport.getJobWorkingDir((String)this.srcConfig.getHdfsWorkingDirectory(), (String)jobUuid);
            String tgt = JobBuilderSupport.getJobWorkingDir((String)this.dstConfig.getHdfsWorkingDirectory(), (String)jobUuid);
            this.operations.add(new Opt(OptType.RENAME_FOLDER_IN_HDFS, new Object[]{src, tgt}));
        }
    }

    protected void changeHtableHost(CubeInstance cube) {
        if (cube.getDescriptor().getStorageType() != 2) {
            return;
        }
        for (CubeSegment segment : cube.getSegments()) {
            this.operations.add(new Opt(OptType.CHANGE_HTABLE_HOST, new Object[]{segment.getStorageLocationIdentifier()}));
        }
    }

    protected void clearSegments(String cubeName) throws IOException {
        this.operations.add(new Opt(OptType.CLEAR_SEGMENTS, new Object[]{cubeName}));
    }

    protected void copyFilesInMetaStore(CubeInstance cube) throws IOException {
        if (this.dstStore.exists(cube.getResourcePath()) && !this.doOverwrite) {
            throw new IllegalStateException("The cube named " + cube.getName() + " already exists on target metadata store. Use overwriteIfExists to overwrite it");
        }
        ArrayList<String> metaItems = new ArrayList<String>();
        HashSet<String> dictAndSnapshot = new HashSet<String>();
        this.listCubeRelatedResources(cube, metaItems, dictAndSnapshot);
        for (String item : metaItems) {
            this.operations.add(new Opt(OptType.COPY_FILE_IN_META, new Object[]{item}));
        }
        if (this.doMigrateSegment) {
            for (String item : dictAndSnapshot) {
                this.operations.add(new Opt(OptType.COPY_DICT_OR_SNAPSHOT, new Object[]{item, cube.getName()}));
            }
        }
    }

    protected void addCubeAndModelIntoProject(CubeInstance srcCube, String cubeName) throws IOException {
        String projectResPath = ProjectInstance.concatResourcePath((String)this.dstProject);
        if (!this.dstStore.exists(projectResPath)) {
            throw new IllegalStateException("The target project " + this.dstProject + " does not exist");
        }
        this.operations.add(new Opt(OptType.ADD_INTO_PROJECT, new Object[]{srcCube, cubeName, this.dstProject}));
    }

    private void purgeAndDisable(String cubeName) throws IOException {
        this.operations.add(new Opt(OptType.PURGE_AND_DISABLE, new Object[]{cubeName}));
    }

    private List<String> getCompatibleTablePath(Set<TableRef> tableRefs, String project, String rootPath) throws IOException {
        ArrayList<String> toResource = new ArrayList<String>();
        List paths = this.srcStore.collectResourceRecursively(rootPath, ".json");
        HashMap<String, String> tableMap = new HashMap<String, String>();
        for (String string : paths) {
            for (TableRef tableRef : tableRefs) {
                String tableId = tableRef.getTableIdentity();
                if (!string.contains(tableId)) continue;
                String prj = (String)TableDesc.parseResourcePath((String)string).getSecond();
                if (prj == null && tableMap.get(tableId) == null) {
                    tableMap.put(tableRef.getTableIdentity(), string);
                }
                if (prj == null || !prj.contains(project)) continue;
                tableMap.put(tableRef.getTableIdentity(), string);
            }
        }
        for (Map.Entry entry : tableMap.entrySet()) {
            toResource.add((String)entry.getValue());
        }
        return toResource;
    }

    protected void listCubeRelatedResources(CubeInstance cube, List<String> metaResource, Set<String> dictAndSnapshot) throws IOException {
        CubeDesc cubeDesc = cube.getDescriptor();
        String prj = cubeDesc.getProject();
        metaResource.add(cube.getResourcePath());
        metaResource.add(cubeDesc.getResourcePath());
        metaResource.add(DataModelDesc.concatResourcePath((String)cubeDesc.getModelName()));
        Set tblRefs = cubeDesc.getModel().getAllTables();
        metaResource.addAll(this.getCompatibleTablePath(tblRefs, prj, "/table"));
        metaResource.addAll(this.getCompatibleTablePath(tblRefs, prj, "/table_exd"));
        if (this.doMigrateSegment) {
            for (CubeSegment segment : cube.getSegments()) {
                metaResource.add(segment.getStatisticsResourcePath());
                dictAndSnapshot.addAll(segment.getSnapshotPaths());
                dictAndSnapshot.addAll(segment.getDictionaryPaths());
            }
        }
        if (this.doAclCopy) {
            metaResource.add(ACL_PREFIX + cube.getUuid());
            metaResource.add(ACL_PREFIX + cube.getModel().getUuid());
        }
    }

    protected Options getOptions() {
        Options options = new Options();
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
    }

    protected void addOpt(OptType type, Object[] params) {
        this.operations.add(new Opt(type, params));
    }

    private void showOpts() {
        for (int i = 0; i < this.operations.size(); ++i) {
            this.showOpt(this.operations.get(i));
        }
    }

    private void showOpt(Opt opt) {
        logger.info("Operation: " + opt.toString());
    }

    protected void doOpts() throws IOException, InterruptedException {
        try {
            for (int index = 0; index < this.operations.size(); ++index) {
                logger.info("Operation index :" + index);
                this.doOpt(this.operations.get(index));
            }
        }
        catch (Exception e) {
            logger.error("error met", (Throwable)e);
            logger.info("Try undoing previous changes");
            for (int i = index; i >= 0; --i) {
                try {
                    this.undo(this.operations.get(i));
                    continue;
                }
                catch (Exception ee) {
                    logger.error("error met ", (Throwable)e);
                    logger.info("Continue undoing...");
                }
            }
            throw new RuntimeException("Cube moving failed");
        }
    }

    private void doOpt(Opt opt) throws IOException, InterruptedException {
        logger.info("Executing operation: " + opt.toString());
        switch (opt.type) {
            case CHANGE_HTABLE_HOST: {
                String tableName = (String)opt.params[0];
                System.out.println("CHANGE_HTABLE_HOST, table name: " + tableName);
                HTableDescriptor desc = this.hbaseAdmin.getTableDescriptor(TableName.valueOf((String)tableName));
                this.hbaseAdmin.disableTable(tableName);
                desc.setValue("KYLIN_HOST", this.dstConfig.getMetadataUrlPrefix());
                this.hbaseAdmin.modifyTable(tableName, desc);
                this.hbaseAdmin.enableTable(tableName);
                logger.info("CHANGE_HTABLE_HOST is completed");
                break;
            }
            case COPY_FILE_IN_META: {
                String item = (String)opt.params[0];
                RawResource res = this.srcStore.getResource(item);
                if (res == null) {
                    logger.info("Item: {} doesn't exist, ignore it.", (Object)item);
                    break;
                }
                this.dstStore.putResource(this.renameTableWithinProject(item), res.inputStream, res.timestamp);
                res.inputStream.close();
                logger.info("Item " + item + " is copied");
                break;
            }
            case COPY_DICT_OR_SNAPSHOT: {
                String item = (String)opt.params[0];
                if (item.toLowerCase().endsWith(".dict")) {
                    DictionaryManager dstDictMgr = DictionaryManager.getInstance((KylinConfig)this.dstConfig);
                    DictionaryManager srcDicMgr = DictionaryManager.getInstance((KylinConfig)this.srcConfig);
                    DictionaryInfo dictSrc = srcDicMgr.getDictionaryInfo(item);
                    long ts = dictSrc.getLastModified();
                    dictSrc.setLastModified(0L);
                    Dictionary dictObj = dictSrc.getDictionaryObject().copyToAnotherMeta(this.srcConfig, this.dstConfig);
                    DictionaryInfo dictSaved = dstDictMgr.trySaveNewDict(dictObj, dictSrc);
                    dictSrc.setLastModified(ts);
                    if (dictSaved == dictSrc) {
                        logger.info("Item " + item + " is copied");
                        break;
                    }
                    String cubeName = (String)opt.params[1];
                    String cubeResPath = CubeInstance.concatResourcePath((String)cubeName);
                    JsonSerializer cubeSerializer = new JsonSerializer(CubeInstance.class);
                    CubeInstance cube = (CubeInstance)this.dstStore.getResource(cubeResPath, CubeInstance.class, (Serializer)cubeSerializer);
                    for (CubeSegment segment : cube.getSegments()) {
                        for (Map.Entry entry : segment.getDictionaries().entrySet()) {
                            if (!((String)entry.getValue()).equalsIgnoreCase(item)) continue;
                            entry.setValue(dictSaved.getResourcePath());
                        }
                    }
                    this.dstStore.putResource(cubeResPath, (RootPersistentEntity)cube, (Serializer)cubeSerializer);
                    logger.info("Item " + item + " is dup, instead " + dictSaved.getResourcePath() + " is reused");
                    break;
                }
                if (item.toLowerCase().endsWith(".snapshot")) {
                    SnapshotManager dstSnapMgr = SnapshotManager.getInstance((KylinConfig)this.dstConfig);
                    SnapshotManager srcSnapMgr = SnapshotManager.getInstance((KylinConfig)this.srcConfig);
                    SnapshotTable snapSrc = srcSnapMgr.getSnapshotTable(item);
                    long ts = snapSrc.getLastModified();
                    snapSrc.setLastModified(0L);
                    SnapshotTable snapSaved = dstSnapMgr.trySaveNewSnapshot(snapSrc);
                    snapSrc.setLastModified(ts);
                    if (snapSaved == snapSrc) {
                        logger.info("Item " + item + " is copied");
                        break;
                    }
                    String cubeName = (String)opt.params[1];
                    String cubeResPath = CubeInstance.concatResourcePath((String)cubeName);
                    JsonSerializer cubeSerializer = new JsonSerializer(CubeInstance.class);
                    CubeInstance cube = (CubeInstance)this.dstStore.getResource(cubeResPath, CubeInstance.class, (Serializer)cubeSerializer);
                    for (CubeSegment segment : cube.getSegments()) {
                        for (Map.Entry entry : segment.getSnapshots().entrySet()) {
                            if (!((String)entry.getValue()).equalsIgnoreCase(item)) continue;
                            entry.setValue(snapSaved.getResourcePath());
                        }
                    }
                    this.dstStore.putResource(cubeResPath, (RootPersistentEntity)cube, (Serializer)cubeSerializer);
                    logger.info("Item " + item + " is dup, instead " + snapSaved.getResourcePath() + " is reused");
                    break;
                }
                logger.error("unknown item found: " + item);
                logger.info("ignore it");
                break;
            }
            case RENAME_FOLDER_IN_HDFS: {
                String srcPath = (String)opt.params[0];
                String dstPath = (String)opt.params[1];
                this.renameHDFSPath(srcPath, dstPath);
                logger.info("HDFS Folder renamed from " + srcPath + " to " + dstPath);
                break;
            }
            case ADD_INTO_PROJECT: {
                CubeInstance srcCube = (CubeInstance)opt.params[0];
                String cubeName = (String)opt.params[1];
                String projectName = (String)opt.params[2];
                String modelName = srcCube.getDescriptor().getModelName();
                String projectResPath = ProjectInstance.concatResourcePath((String)projectName);
                JsonSerializer projectSerializer = new JsonSerializer(ProjectInstance.class);
                ProjectInstance project = (ProjectInstance)this.dstStore.getResource(projectResPath, ProjectInstance.class, (Serializer)projectSerializer);
                for (TableRef tableRef : srcCube.getModel().getAllTables()) {
                    project.addTable(tableRef.getTableIdentity());
                }
                if (!project.getModels().contains(modelName)) {
                    project.addModel(modelName);
                }
                project.removeRealization(RealizationType.CUBE, cubeName);
                project.addRealizationEntry(RealizationType.CUBE, cubeName);
                this.dstStore.putResource(projectResPath, (RootPersistentEntity)project, (Serializer)projectSerializer);
                logger.info("Project instance for " + projectName + " is corrected");
                break;
            }
            case CLEAR_SEGMENTS: {
                String cubeName = (String)opt.params[0];
                String cubeInstancePath = CubeInstance.concatResourcePath((String)cubeName);
                JsonSerializer cubeInstanceSerializer = new JsonSerializer(CubeInstance.class);
                CubeInstance cubeInstance = (CubeInstance)this.dstStore.getResource(cubeInstancePath, CubeInstance.class, (Serializer)cubeInstanceSerializer);
                cubeInstance.getSegments().clear();
                cubeInstance.clearCuboids();
                cubeInstance.setCreateTimeUTC(System.currentTimeMillis());
                cubeInstance.setStatus(RealizationStatusEnum.DISABLED);
                this.dstStore.putResource(cubeInstancePath, (RootPersistentEntity)cubeInstance, (Serializer)cubeInstanceSerializer);
                logger.info("Cleared segments for " + cubeName + ", since segments has not been copied");
                break;
            }
            case PURGE_AND_DISABLE: {
                String cubeName = (String)opt.params[0];
                String cubeResPath = CubeInstance.concatResourcePath((String)cubeName);
                JsonSerializer cubeSerializer = new JsonSerializer(CubeInstance.class);
                CubeInstance cube = (CubeInstance)this.srcStore.getResource(cubeResPath, CubeInstance.class, (Serializer)cubeSerializer);
                cube.getSegments().clear();
                cube.setStatus(RealizationStatusEnum.DISABLED);
                this.srcStore.putResource(cubeResPath, (RootPersistentEntity)cube, (Serializer)cubeSerializer);
                logger.info("Cube " + cubeName + " is purged and disabled in " + this.srcConfig.getMetadataUrl());
                break;
            }
        }
    }

    private void undo(Opt opt) throws IOException, InterruptedException {
        logger.info("Undo operation: " + opt.toString());
        switch (opt.type) {
            case CHANGE_HTABLE_HOST: {
                String tableName = (String)opt.params[0];
                HTableDescriptor desc = this.hbaseAdmin.getTableDescriptor(TableName.valueOf((String)tableName));
                this.hbaseAdmin.disableTable(tableName);
                desc.setValue("KYLIN_HOST", this.srcConfig.getMetadataUrlPrefix());
                this.hbaseAdmin.modifyTable(tableName, desc);
                this.hbaseAdmin.enableTable(tableName);
                break;
            }
            case COPY_FILE_IN_META: {
                logger.info("Undo for COPY_FILE_IN_META is ignored");
                String item = (String)opt.params[0];
                if (!item.startsWith(ACL_PREFIX) || !this.doAclCopy) break;
                logger.info("Remove acl record");
                this.dstStore.deleteResource(item);
                break;
            }
            case COPY_DICT_OR_SNAPSHOT: {
                logger.info("Undo for COPY_DICT_OR_SNAPSHOT is ignored");
                break;
            }
            case RENAME_FOLDER_IN_HDFS: {
                String srcPath = (String)opt.params[1];
                String dstPath = (String)opt.params[0];
                if (!this.hdfsFS.exists(new Path(srcPath)) || this.hdfsFS.exists(new Path(dstPath))) break;
                this.renameHDFSPath(srcPath, dstPath);
                logger.info("HDFS Folder renamed from " + srcPath + " to " + dstPath);
                break;
            }
            case ADD_INTO_PROJECT: {
                logger.info("Undo for ADD_INTO_PROJECT is ignored");
                break;
            }
            case PURGE_AND_DISABLE: {
                logger.info("Undo for PURGE_AND_DISABLE is not supported");
                break;
            }
        }
    }

    private String renameTableWithinProject(String srcItem) {
        if (this.dstProject != null && srcItem.contains("/table")) {
            String tableIdentity = (String)TableDesc.parseResourcePath((String)srcItem).getFirst();
            if (srcItem.contains("/table_exd")) {
                return TableExtDesc.concatResourcePath((String)tableIdentity, (String)this.dstProject);
            }
            return "/table/" + tableIdentity + "--" + this.dstProject + ".json";
        }
        return srcItem;
    }

    private void updateMeta(KylinConfig config, String projectName, String cubeName, DataModelDesc model) {
        String[] nodes = config.getRestServers();
        HashMap<String, String> tableToProjects = new HashMap<String, String>();
        for (TableRef tableRef : model.getAllTables()) {
            tableToProjects.put(tableRef.getTableIdentity(), tableRef.getTableDesc().getProject());
        }
        for (String node : nodes) {
            RestClient restClient = new RestClient(node);
            try {
                logger.info("update meta cache for " + node);
                restClient.clearCacheForCubeMigration(cubeName, projectName, model.getName(), tableToProjects);
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
    }

    private void renameHDFSPath(String srcPath, String dstPath) throws IOException, InterruptedException {
        int nRetry = 0;
        int sleepTime = 5000;
        while (!this.hdfsFS.rename(new Path(srcPath), new Path(dstPath))) {
            if (++nRetry > 3) {
                throw new InterruptedException("Cannot rename folder " + srcPath + " to folder " + dstPath);
            }
            Thread.sleep(sleepTime * nRetry * nRetry);
        }
    }

    private class Opt {
        private OptType type;
        private Object[] params;

        private Opt(OptType type, Object[] params) {
            this.type = type;
            this.params = params;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.type).append(":");
            for (Object s : this.params) {
                sb.append(s).append(", ");
            }
            return sb.toString();
        }
    }

    protected static enum OptType {
        COPY_FILE_IN_META,
        COPY_DICT_OR_SNAPSHOT,
        RENAME_FOLDER_IN_HDFS,
        ADD_INTO_PROJECT,
        CHANGE_HTABLE_HOST,
        PURGE_AND_DISABLE,
        CLEAR_SEGMENTS;

    }
}

