/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.tool.AbstractInfoExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientEnvExtractor
extends AbstractInfoExtractor {
    private static final Logger logger = LoggerFactory.getLogger(ClientEnvExtractor.class);
    private KylinConfig kylinConfig;
    private CliCommandExecutor cmdExecutor;

    public ClientEnvExtractor() throws IOException {
        this.packageType = "client";
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.cmdExecutor = this.kylinConfig.getCliCommandExecutor();
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        this.addLocalFile("/sys/kernel/mm/transparent_hugepage/defrag", "linux/transparent_hugepage");
        this.addLocalFile("/proc/sys/vm/swappiness", "linux/swappiness");
        this.addLocalFile("/proc/cpuinfo", "linux");
        this.addShellOutput("lsb_release -a", "linux", "lsb_release");
        this.addShellOutput("df -h", "linux", "disk_usage");
        this.addShellOutput("free -m", "linux", "mem_usage_mb");
        this.addShellOutput("top -b -n 1 | head -n 30", "linux", "top");
        this.addShellOutput("ps aux|grep kylin", "linux", "kylin_processes");
        this.addShellOutput("hadoop version", "hadoop", "version");
        this.addShellOutput("hbase version", "hbase", "version");
        this.addShellOutput("hive --version", "hive", "version");
        this.addShellOutput("beeline --version", "hive", "beeline_version");
    }

    private void addLocalFile(String src, String destDir) {
        try {
            File srcFile = new File(src);
            File destDirFile = null;
            if (!StringUtils.isEmpty((String)destDir)) {
                destDirFile = new File(this.exportDir, destDir);
                FileUtils.forceMkdir((File)destDirFile);
            } else {
                destDirFile = this.exportDir;
            }
            FileUtils.forceMkdir((File)destDirFile);
            Files.copy((File)srcFile, (File)new File(destDirFile, srcFile.getName()));
        }
        catch (Exception e) {
            logger.warn("Failed to copy " + src + ".", (Throwable)e);
        }
    }

    private void addShellOutput(String cmd, String destDir, String filename) {
        try {
            File destDirFile = null;
            if (!StringUtils.isEmpty((String)destDir)) {
                destDirFile = new File(this.exportDir, destDir);
                FileUtils.forceMkdir((File)destDirFile);
            } else {
                destDirFile = this.exportDir;
            }
            Pair result = this.cmdExecutor.execute(cmd);
            String output = (String)result.getSecond();
            FileUtils.writeStringToFile((File)new File(destDirFile, filename), (String)output, (Charset)Charset.defaultCharset());
        }
        catch (Exception e) {
            logger.warn("Failed to run command: " + cmd + ".", (Throwable)e);
        }
    }
}

