/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.metrics.systemcube;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metrics.lib.SinkTool;
import org.apache.kylin.tool.metrics.systemcube.CubeDescCreator;
import org.apache.kylin.tool.metrics.systemcube.CubeInstanceCreator;
import org.apache.kylin.tool.metrics.systemcube.HiveTableCreator;
import org.apache.kylin.tool.metrics.systemcube.KylinTableCreator;
import org.apache.kylin.tool.metrics.systemcube.ModelCreator;
import org.apache.kylin.tool.metrics.systemcube.ProjectCreator;
import org.apache.kylin.tool.metrics.systemcube.util.HiveSinkTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCCreator
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(SCCreator.class);
    private static final Option OPTION_OWNER;
    private static final Option OPTION_INPUT_CONFIG;
    private static final Option OPTION_OUTPUT;
    private static final String D_CUBE_INSTANCE = "cube/";
    private static final String D_CUBE_DESC = "cube_desc/";
    private static final String D_PROJECT = "project/";
    private static final String D_TABLE = "table/";
    private static final String D_MODEL_DESC = "model_desc/";
    private static final String F_HIVE_SQL = "create_hive_tables_for_system_cubes";
    protected final Options options;
    private final KylinConfig config = KylinConfig.getInstanceFromEnv();

    public SCCreator() {
        this.options = new Options();
        this.options.addOption(OPTION_OWNER);
        this.options.addOption(OPTION_OUTPUT);
        this.options.addOption(OPTION_INPUT_CONFIG);
    }

    public static void main(String[] args) {
        SCCreator cli = new SCCreator();
        cli.execute(args);
    }

    protected Options getOptions() {
        return this.options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String owner = optionsHelper.getOptionValue(OPTION_OWNER);
        String output = optionsHelper.getOptionValue(OPTION_OUTPUT);
        String inputConfig = optionsHelper.getOptionValue(OPTION_INPUT_CONFIG);
        if (Strings.isNullOrEmpty((String)inputConfig)) {
            throw new RuntimeException("Input configuration file should be specified!!!");
        }
        this.execute(owner, output, inputConfig);
    }

    public void execute(String owner, String output, String inputConfig) throws Exception {
        if (Strings.isNullOrEmpty((String)owner)) {
            owner = "ADMIN";
        }
        if (!output.endsWith("/")) {
            output = output + "/";
        }
        Set sourceToolSet = (Set)JsonUtil.readValueWithTyping((InputStream)new BufferedInputStream(new FileInputStream(new File(inputConfig))), HashSet.class);
        this.run(owner, output, sourceToolSet);
    }

    private void run(String owner, String output, Collection<SinkTool> sinkToolSet) throws IOException {
        ArrayList kylinTables = Lists.newArrayList();
        ArrayList kylinModels = Lists.newArrayList();
        ArrayList kylinCubeDescs = Lists.newArrayList();
        ArrayList kylinCubeInstances = Lists.newArrayList();
        boolean ifHive = false;
        for (SinkTool sourceTool : sinkToolSet) {
            if (!(sourceTool instanceof HiveSinkTool)) {
                logger.warn("current version only support hive sink!!!");
                continue;
            }
            ifHive = true;
            kylinTables.addAll(this.generateKylinTableForSystemCube(sourceTool));
            kylinModels.addAll(this.generateKylinModelForSystemCube(owner, sourceTool));
            kylinCubeDescs.addAll(this.generateKylinCubeDescForSystemCube(sourceTool));
            kylinCubeInstances.addAll(this.generateKylinCubeInstanceForSystemCube(owner, sourceTool));
        }
        if (ifHive) {
            this.generateHiveTableSQLFileForSystemCube(output);
        }
        ProjectInstance projectInstance = ProjectCreator.generateKylinProjectInstance(owner, kylinTables, kylinModels, kylinCubeDescs);
        this.generateKylinProjectFileForSystemCube(output, projectInstance);
        for (TableDesc tableDesc : kylinTables) {
            this.generateKylinTableFileForSystemCube(output, tableDesc);
        }
        for (DataModelDesc dataModelDesc : kylinModels) {
            this.generateKylinModelFileForSystemCube(output, dataModelDesc);
        }
        for (CubeDesc cubeDesc : kylinCubeDescs) {
            this.generateKylinCubeDescFileForSystemCube(output, cubeDesc);
        }
        for (CubeInstance cubeInstance : kylinCubeInstances) {
            this.generateKylinCubeInstanceFileForSystemCube(output, cubeInstance);
        }
    }

    private List<TableDesc> generateKylinTableForSystemCube(SinkTool sinkTool) {
        LinkedList result = Lists.newLinkedList();
        result.add(KylinTableCreator.generateKylinTableForMetricsQuery(this.config, sinkTool));
        result.add(KylinTableCreator.generateKylinTableForMetricsQueryCube(this.config, sinkTool));
        result.add(KylinTableCreator.generateKylinTableForMetricsQueryRPC(this.config, sinkTool));
        result.add(KylinTableCreator.generateKylinTableForMetricsJob(this.config, sinkTool));
        result.add(KylinTableCreator.generateKylinTableForMetricsJobException(this.config, sinkTool));
        return result;
    }

    private List<DataModelDesc> generateKylinModelForSystemCube(String owner, SinkTool sinkTool) {
        LinkedList result = Lists.newLinkedList();
        result.add(ModelCreator.generateKylinModelForMetricsQuery(owner, this.config, sinkTool));
        result.add(ModelCreator.generateKylinModelForMetricsQueryCube(owner, this.config, sinkTool));
        result.add(ModelCreator.generateKylinModelForMetricsQueryRPC(owner, this.config, sinkTool));
        result.add(ModelCreator.generateKylinModelForMetricsJob(owner, this.config, sinkTool));
        result.add(ModelCreator.generateKylinModelForMetricsJobException(owner, this.config, sinkTool));
        return result;
    }

    private List<CubeDesc> generateKylinCubeDescForSystemCube(SinkTool sinkTool) {
        LinkedList result = Lists.newLinkedList();
        result.add(CubeDescCreator.generateKylinCubeDescForMetricsQuery(this.config, sinkTool));
        result.add(CubeDescCreator.generateKylinCubeDescForMetricsQueryCube(this.config, sinkTool));
        result.add(CubeDescCreator.generateKylinCubeDescForMetricsQueryRPC(this.config, sinkTool));
        result.add(CubeDescCreator.generateKylinCubeDescForMetricsJob(this.config, sinkTool));
        result.add(CubeDescCreator.generateKylinCubeDescForMetricsJobException(this.config, sinkTool));
        return result;
    }

    private List<CubeInstance> generateKylinCubeInstanceForSystemCube(String owner, SinkTool sinkTool) {
        LinkedList result = Lists.newLinkedList();
        result.add(CubeInstanceCreator.generateKylinCubeInstanceForMetricsQuery(owner, this.config, sinkTool));
        result.add(CubeInstanceCreator.generateKylinCubeInstanceForMetricsQueryCube(owner, this.config, sinkTool));
        result.add(CubeInstanceCreator.generateKylinCubeInstanceForMetricsQueryRPC(owner, this.config, sinkTool));
        result.add(CubeInstanceCreator.generateKylinCubeInstanceForMetricsJob(owner, this.config, sinkTool));
        result.add(CubeInstanceCreator.generateKylinCubeInstanceForMetricsJobException(owner, this.config, sinkTool));
        return result;
    }

    private void generateHiveTableSQLFileForSystemCube(String output) throws IOException {
        String contents = HiveTableCreator.generateAllSQL(this.config);
        this.saveToFile(output + F_HIVE_SQL + ".sql", contents);
    }

    private void generateKylinTableFileForSystemCube(String output, TableDesc kylinTable) throws IOException {
        this.saveSystemCubeMetadataToFile(output + D_TABLE + kylinTable.getIdentity() + ".json", kylinTable, TableMetadataManager.TABLE_SERIALIZER);
    }

    private void generateKylinModelFileForSystemCube(String output, DataModelDesc modelDesc) throws IOException {
        this.saveSystemCubeMetadataToFile(output + D_MODEL_DESC + modelDesc.getName() + ".json", modelDesc, ModelCreator.MODELDESC_SERIALIZER);
    }

    private void generateKylinCubeInstanceFileForSystemCube(String output, CubeInstance cubeInstance) throws IOException {
        this.saveSystemCubeMetadataToFile(output + D_CUBE_INSTANCE + cubeInstance.getName() + ".json", cubeInstance, CubeManager.CUBE_SERIALIZER);
    }

    private void generateKylinCubeDescFileForSystemCube(String output, CubeDesc cubeDesc) throws IOException {
        this.saveSystemCubeMetadataToFile(output + D_CUBE_DESC + cubeDesc.getName() + ".json", cubeDesc, CubeDescManager.CUBE_DESC_SERIALIZER);
    }

    private void generateKylinProjectFileForSystemCube(String output, ProjectInstance projectInstance) throws IOException {
        this.saveSystemCubeMetadataToFile(output + D_PROJECT + projectInstance.getName() + ".json", projectInstance, CubeDescManager.CUBE_DESC_SERIALIZER);
    }

    private <T extends RootPersistentEntity> void saveSystemCubeMetadataToFile(String fileName, T metadata, Serializer serializer) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(buf);
        serializer.serialize(metadata, dout);
        dout.close();
        buf.close();
        this.saveToFile(fileName, buf.toString());
    }

    private void saveToFile(String fileName, String contents) throws IOException {
        File parentDir = new File(fileName).getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(fileName));){
            bufferedWriter.append(contents);
        }
    }

    static {
        OptionBuilder.withArgName((String)"owner");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify the owner who creates the metadata");
        OPTION_OWNER = OptionBuilder.create((String)"owner");
        OptionBuilder.withArgName((String)"inputConfig");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify the input configuration file");
        OPTION_INPUT_CONFIG = OptionBuilder.create((String)"inputConfig");
        OptionBuilder.withArgName((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Specify the output where the generated metadata will be saved");
        OPTION_OUTPUT = OptionBuilder.create((String)"output");
    }
}

