/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceTool;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.ZipFileUtils;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.RealizationRegistry;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.storage.hybrid.HybridManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeMetaIngester
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(CubeMetaIngester.class);
    private static final Option OPTION_SRC;
    private static final Option OPTION_PROJECT;
    private static final Option OPTION_FORCE_INGEST;
    private static final Option OPTION_OVERWRITE_TABLES;
    private KylinConfig kylinConfig;
    private MetadataManager metadataManager;
    private ProjectManager projectManager;
    private CubeManager cubeManager;
    private CubeDescManager cubeDescManager;
    private RealizationRegistry realizationRegistry;
    Set<String> requiredResources = Sets.newLinkedHashSet();
    private String targetProjectName;
    private boolean overwriteTables = false;
    private boolean forceIngest = false;

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_SRC);
        options.addOption(OPTION_PROJECT);
        options.addOption(OPTION_FORCE_INGEST);
        options.addOption(OPTION_OVERWRITE_TABLES);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.metadataManager = MetadataManager.getInstance((KylinConfig)this.kylinConfig);
        this.projectManager = ProjectManager.getInstance((KylinConfig)this.kylinConfig);
        this.cubeManager = CubeManager.getInstance((KylinConfig)this.kylinConfig);
        this.cubeDescManager = CubeDescManager.getInstance((KylinConfig)this.kylinConfig);
        this.realizationRegistry = RealizationRegistry.getInstance((KylinConfig)this.kylinConfig);
        if (optionsHelper.hasOption(OPTION_FORCE_INGEST)) {
            this.forceIngest = Boolean.valueOf(optionsHelper.getOptionValue(OPTION_FORCE_INGEST));
        }
        if (optionsHelper.hasOption(OPTION_OVERWRITE_TABLES)) {
            this.overwriteTables = Boolean.valueOf(optionsHelper.getOptionValue(OPTION_OVERWRITE_TABLES));
        }
        this.targetProjectName = optionsHelper.getOptionValue(OPTION_PROJECT);
        String srcPath = optionsHelper.getOptionValue(OPTION_SRC);
        if (!srcPath.endsWith(".zip")) {
            throw new IllegalArgumentException(OPTION_SRC.getArgName() + " has to be a zip file");
        }
        File zipFile = new File(srcPath);
        if (zipFile.isDirectory() || !zipFile.exists()) {
            throw new IllegalArgumentException(OPTION_SRC.getArgName() + " file does does exist");
        }
        File tempFolder = File.createTempFile("_unzip", "folder");
        tempFolder.deleteOnExit();
        tempFolder.delete();
        tempFolder.mkdir();
        ZipFileUtils.decompressZipfileToDirectory((String)srcPath, (File)tempFolder);
        if (tempFolder.list().length != 1) {
            throw new IllegalStateException(Arrays.toString(tempFolder.list()));
        }
        this.injest(tempFolder.listFiles()[0].getAbsoluteFile());
    }

    private void injest(File metaRoot) throws IOException {
        KylinConfig srcConfig = KylinConfig.createInstanceFromUri((String)metaRoot.getAbsolutePath());
        MetadataManager srcMetadataManager = MetadataManager.getInstance((KylinConfig)srcConfig);
        HybridManager srcHybridManager = HybridManager.getInstance((KylinConfig)srcConfig);
        CubeManager srcCubeManager = CubeManager.getInstance((KylinConfig)srcConfig);
        CubeDescManager srcCubeDescManager = CubeDescManager.getInstance((KylinConfig)srcConfig);
        this.checkAndMark(srcMetadataManager, srcHybridManager, srcCubeManager, srcCubeDescManager);
        ResourceTool.copy((KylinConfig)srcConfig, (KylinConfig)this.kylinConfig, (List)Lists.newArrayList(this.requiredResources));
        this.metadataManager.reload();
        for (TableDesc tableDesc : srcMetadataManager.listAllTables(null)) {
            logger.info("add " + tableDesc + " to " + this.targetProjectName);
            this.projectManager.addTableDescToProject(Lists.newArrayList((Object[])new String[]{tableDesc.getIdentity()}).toArray(new String[0]), this.targetProjectName);
        }
        for (CubeInstance cube : srcCubeManager.listAllCubes()) {
            logger.info("add " + cube + " to " + this.targetProjectName);
            this.projectManager.updateModelToProject(cube.getModel().getName(), this.targetProjectName);
            this.projectManager.moveRealizationToProject(RealizationType.CUBE, cube.getName(), this.targetProjectName, null);
        }
    }

    private void checkAndMark(MetadataManager srcMetadataManager, HybridManager srcHybridManager, CubeManager srcCubeManager, CubeDescManager srcCubeDescManager) {
        TableDesc existing;
        if (srcHybridManager.listHybridInstances().size() > 0) {
            throw new IllegalStateException("Does not support ingest hybrid yet");
        }
        ProjectInstance targetProject = this.projectManager.getProject(this.targetProjectName);
        if (targetProject == null) {
            throw new IllegalStateException("Target project does not exist in target metadata: " + this.targetProjectName);
        }
        for (TableDesc tableDesc : srcMetadataManager.listAllTables(null)) {
            existing = this.metadataManager.getTableDesc(tableDesc.getIdentity(), this.targetProjectName);
            if (existing != null && !existing.equals((Object)tableDesc)) {
                logger.info("Table {} already has a different version in target metadata store", (Object)tableDesc.getIdentity());
                logger.info("Existing version: " + existing);
                logger.info("New version: " + tableDesc);
                if (!this.forceIngest && !this.overwriteTables) {
                    throw new IllegalStateException("table already exists with a different version: " + tableDesc.getIdentity() + ". Consider adding -overwriteTables option to force overwriting (with caution)");
                }
                logger.warn("Overwriting the old table desc: " + tableDesc.getIdentity());
            }
            this.requiredResources.add(tableDesc.getResourcePath());
        }
        for (DataModelDesc dataModelDesc : srcMetadataManager.listDataModels()) {
            existing = this.metadataManager.getDataModelDesc(dataModelDesc.getName());
            if (existing != null) {
                if (!this.forceIngest) {
                    throw new IllegalStateException("Already exist a model called " + dataModelDesc.getName());
                }
                logger.warn("Overwriting the old model desc: " + dataModelDesc.getName());
            }
            this.requiredResources.add(DataModelDesc.concatResourcePath((String)dataModelDesc.getName()));
        }
        for (CubeDesc cubeDesc : srcCubeDescManager.listAllDesc()) {
            existing = this.cubeDescManager.getCubeDesc(cubeDesc.getName());
            if (existing != null) {
                if (!this.forceIngest) {
                    throw new IllegalStateException("Already exist a cube desc called " + cubeDesc.getName());
                }
                logger.warn("Overwriting the old cube desc: " + cubeDesc.getName());
            }
            this.requiredResources.add(CubeDesc.concatResourcePath((String)cubeDesc.getName()));
        }
        for (CubeInstance cube : srcCubeManager.listAllCubes()) {
            existing = this.cubeManager.getCube(cube.getName());
            if (existing != null) {
                if (!this.forceIngest) {
                    throw new IllegalStateException("Already exist a cube called " + cube.getName());
                }
                logger.warn("Overwriting the old cube: " + cube.getName());
            }
            this.requiredResources.add(CubeInstance.concatResourcePath((String)cube.getName()));
        }
    }

    public static void main(String[] args) {
        CubeMetaIngester extractor = new CubeMetaIngester();
        extractor.execute(args);
    }

    static {
        OptionBuilder.withArgName((String)"srcPath");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"specify the path to the extracted cube metadata zip file");
        OPTION_SRC = OptionBuilder.create((String)"srcPath");
        OptionBuilder.withArgName((String)"project");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"specify the target project for the new cubes");
        OPTION_PROJECT = OptionBuilder.create((String)"project");
        OptionBuilder.withArgName((String)"forceIngest");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"skip the target cube, model and table check and ingest by force. Use in caution because it might break existing cubes! Suggest to backup metadata store first");
        OPTION_FORCE_INGEST = OptionBuilder.create((String)"forceIngest");
        OptionBuilder.withArgName((String)"overwriteTables");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"If table meta conflicts, overwrite the one in metadata store with the one in srcPath. Use in caution because it might break existing cubes! Suggest to backup metadata store first");
        OPTION_OVERWRITE_TABLES = OptionBuilder.create((String)"overwriteTables");
    }
}

