/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.restclient.RestClient;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.dict.lookup.SnapshotManager;
import org.apache.kylin.dict.lookup.SnapshotTable;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.tool.CubeMigrationCheckCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeMigrationCLI {
    private static final Logger logger = LoggerFactory.getLogger(CubeMigrationCLI.class);
    private List<Opt> operations;
    protected KylinConfig srcConfig;
    protected KylinConfig dstConfig;
    private ResourceStore srcStore;
    private ResourceStore dstStore;
    private FileSystem hdfsFS;
    private HBaseAdmin hbaseAdmin;
    public static final String ACL_INFO_FAMILY = "i";
    private static final String ACL_TABLE_NAME = "_acl";
    private static final String ACL_INFO_FAMILY_PARENT_COLUMN = "p";

    public static void main(String[] args) throws IOException, InterruptedException {
        CubeMigrationCLI cli = new CubeMigrationCLI();
        if (args.length != 8) {
            cli.usage();
            System.exit(1);
        }
        cli.moveCube(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
    }

    protected void usage() {
        System.out.println("Usage: CubeMigrationCLI srcKylinConfigUri dstKylinConfigUri cubeName projectName copyAclOrNot purgeOrNot overwriteIfExists realExecute");
        System.out.println(" srcKylinConfigUri: The KylinConfig of the cube\u2019s source \ndstKylinConfigUri: The KylinConfig of the cube\u2019s new home \ncubeName: the name of cube to be migrated. \nprojectName: The target project in the target environment.(Make sure it exist) \ncopyAclOrNot: true or false: whether copy cube ACL to target environment. \npurgeOrNot: true or false: whether purge the cube from src server after the migration. \noverwriteIfExists: overwrite cube if it already exists in the target environment. \nrealExecute: if false, just print the operations to take, if true, do the real migration. \n");
    }

    public void moveCube(KylinConfig srcCfg, KylinConfig dstCfg, String cubeName, String projectName, String copyAcl, String purgeAndDisable, String overwriteIfExists, String realExecute) throws IOException, InterruptedException {
        this.srcConfig = srcCfg;
        this.srcStore = ResourceStore.getStore((KylinConfig)this.srcConfig);
        this.dstConfig = dstCfg;
        this.dstStore = ResourceStore.getStore((KylinConfig)this.dstConfig);
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)this.srcConfig);
        CubeInstance cube = cubeManager.getCube(cubeName);
        logger.info("cube to be moved is : " + cubeName);
        if (cube.getStatus() != RealizationStatusEnum.READY) {
            throw new IllegalStateException("Cannot migrate cube that is not in READY state.");
        }
        for (CubeSegment segment : cube.getSegments()) {
            if (segment.getStatus() == SegmentStatusEnum.READY) continue;
            throw new IllegalStateException("At least one segment is not in READY state");
        }
        this.checkAndGetHbaseUrl();
        Configuration conf = HBaseConnection.getCurrentHBaseConfiguration();
        this.hbaseAdmin = new HBaseAdmin(conf);
        this.hdfsFS = HadoopUtil.getWorkingFileSystem();
        this.operations = new ArrayList<Opt>();
        this.copyFilesInMetaStore(cube, overwriteIfExists);
        this.renameFoldersInHdfs(cube);
        this.changeHtableHost(cube);
        this.addCubeAndModelIntoProject(cube, cubeName, projectName);
        if (Boolean.parseBoolean(copyAcl)) {
            this.copyACL(cube, projectName);
        }
        if (Boolean.parseBoolean(purgeAndDisable)) {
            this.purgeAndDisable(cubeName);
        }
        if (realExecute.equalsIgnoreCase("true")) {
            this.doOpts();
            this.checkMigrationSuccess(this.dstConfig, cubeName, true);
            this.updateMeta(this.dstConfig);
        } else {
            this.showOpts();
        }
    }

    public void moveCube(String srcCfgUri, String dstCfgUri, String cubeName, String projectName, String copyAcl, String purgeAndDisable, String overwriteIfExists, String realExecute) throws IOException, InterruptedException {
        this.moveCube(KylinConfig.createInstanceFromUri((String)srcCfgUri), KylinConfig.createInstanceFromUri((String)dstCfgUri), cubeName, projectName, copyAcl, purgeAndDisable, overwriteIfExists, realExecute);
    }

    public void checkMigrationSuccess(KylinConfig kylinConfig, String cubeName, Boolean ifFix) throws IOException {
        CubeMigrationCheckCLI checkCLI = new CubeMigrationCheckCLI(kylinConfig, ifFix);
        checkCLI.execute(cubeName);
    }

    private void checkAndGetHbaseUrl() {
        StorageURL srcMetadataUrl = this.srcConfig.getMetadataUrl();
        StorageURL dstMetadataUrl = this.dstConfig.getMetadataUrl();
        logger.info("src metadata url is " + srcMetadataUrl);
        logger.info("dst metadata url is " + dstMetadataUrl);
        if (!"hbase".equals(srcMetadataUrl.getScheme()) || !"hbase".equals(dstMetadataUrl.getScheme())) {
            throw new IllegalStateException("Both metadata urls should be hbase metadata url");
        }
    }

    protected void renameFoldersInHdfs(CubeInstance cube) throws IOException {
        for (CubeSegment segment : cube.getSegments()) {
            String jobUuid = segment.getLastBuildJobID();
            String src = JobBuilderSupport.getJobWorkingDir((String)this.srcConfig.getHdfsWorkingDirectory(), (String)jobUuid);
            String tgt = JobBuilderSupport.getJobWorkingDir((String)this.dstConfig.getHdfsWorkingDirectory(), (String)jobUuid);
            this.operations.add(new Opt(OptType.RENAME_FOLDER_IN_HDFS, new Object[]{src, tgt}));
        }
    }

    protected void changeHtableHost(CubeInstance cube) {
        if (cube.getDescriptor().getEngineType() != 2) {
            return;
        }
        for (CubeSegment segment : cube.getSegments()) {
            this.operations.add(new Opt(OptType.CHANGE_HTABLE_HOST, new Object[]{segment.getStorageLocationIdentifier()}));
        }
    }

    private void copyACL(CubeInstance cube, String projectName) {
        this.operations.add(new Opt(OptType.COPY_ACL, new Object[]{cube.getUuid(), cube.getDescriptor().getModel().getUuid(), projectName}));
    }

    private void copyFilesInMetaStore(CubeInstance cube, String overwriteIfExists) throws IOException {
        ArrayList<String> metaItems = new ArrayList<String>();
        HashSet<String> dictAndSnapshot = new HashSet<String>();
        this.listCubeRelatedResources(cube, metaItems, dictAndSnapshot);
        if (this.dstStore.exists(cube.getResourcePath()) && !overwriteIfExists.equalsIgnoreCase("true")) {
            throw new IllegalStateException("The cube named " + cube.getName() + " already exists on target metadata store. Use overwriteIfExists to overwrite it");
        }
        for (String item : metaItems) {
            this.operations.add(new Opt(OptType.COPY_FILE_IN_META, new Object[]{item}));
        }
        for (String item : dictAndSnapshot) {
            this.operations.add(new Opt(OptType.COPY_DICT_OR_SNAPSHOT, new Object[]{item, cube.getName()}));
        }
    }

    private void addCubeAndModelIntoProject(CubeInstance srcCube, String cubeName, String projectName) throws IOException {
        String projectResPath = ProjectInstance.concatResourcePath((String)projectName);
        if (!this.dstStore.exists(projectResPath)) {
            throw new IllegalStateException("The target project " + projectName + " does not exist");
        }
        this.operations.add(new Opt(OptType.ADD_INTO_PROJECT, new Object[]{srcCube, cubeName, projectName}));
    }

    private void purgeAndDisable(String cubeName) throws IOException {
        this.operations.add(new Opt(OptType.PURGE_AND_DISABLE, new Object[]{cubeName}));
    }

    protected void listCubeRelatedResources(CubeInstance cube, List<String> metaResource, Set<String> dictAndSnapshot) throws IOException {
        CubeDesc cubeDesc = cube.getDescriptor();
        metaResource.add(cube.getResourcePath());
        metaResource.add(cubeDesc.getResourcePath());
        metaResource.add(DataModelDesc.concatResourcePath((String)cubeDesc.getModelName()));
        for (TableRef tableRef : cubeDesc.getModel().getAllTables()) {
            metaResource.add(TableDesc.concatResourcePath((String)tableRef.getTableIdentity()));
            metaResource.add(TableExtDesc.concatResourcePath((String)tableRef.getTableIdentity()));
        }
        for (CubeSegment segment : cube.getSegments()) {
            metaResource.add(segment.getStatisticsResourcePath());
            dictAndSnapshot.addAll(segment.getSnapshotPaths());
            dictAndSnapshot.addAll(segment.getDictionaryPaths());
        }
    }

    protected void addOpt(OptType type, Object[] params) {
        this.operations.add(new Opt(type, params));
    }

    private void showOpts() {
        for (int i = 0; i < this.operations.size(); ++i) {
            this.showOpt(this.operations.get(i));
        }
    }

    private void showOpt(Opt opt) {
        logger.info("Operation: " + opt.toString());
    }

    private void doOpts() throws IOException, InterruptedException {
        try {
            for (int index = 0; index < this.operations.size(); ++index) {
                logger.info("Operation index :" + index);
                this.doOpt(this.operations.get(index));
            }
        }
        catch (Exception e) {
            logger.error("error met", (Throwable)e);
            logger.info("Try undoing previous changes");
            for (int i = index; i >= 0; --i) {
                try {
                    this.undo(this.operations.get(i));
                    continue;
                }
                catch (Exception ee) {
                    logger.error("error met ", (Throwable)e);
                    logger.info("Continue undoing...");
                }
            }
            throw new RuntimeException("Cube moving failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doOpt(Opt opt) throws IOException, InterruptedException {
        logger.info("Executing operation: " + opt.toString());
        switch (opt.type) {
            case CHANGE_HTABLE_HOST: {
                String tableName = (String)opt.params[0];
                System.out.println("CHANGE_HTABLE_HOST, table name: " + tableName);
                HTableDescriptor desc = this.hbaseAdmin.getTableDescriptor(TableName.valueOf((String)tableName));
                this.hbaseAdmin.disableTable(tableName);
                desc.setValue("KYLIN_HOST", this.dstConfig.getMetadataUrlPrefix());
                this.hbaseAdmin.modifyTable(tableName, desc);
                this.hbaseAdmin.enableTable(tableName);
                logger.info("CHANGE_HTABLE_HOST is completed");
                return;
            }
            case COPY_FILE_IN_META: {
                String item = (String)opt.params[0];
                RawResource res = this.srcStore.getResource(item);
                this.dstStore.putResource(item, res.inputStream, res.timestamp);
                res.inputStream.close();
                logger.info("Item " + item + " is copied");
                return;
            }
            case COPY_DICT_OR_SNAPSHOT: {
                String item = (String)opt.params[0];
                if (item.toLowerCase().endsWith(".dict")) {
                    DictionaryManager dstDictMgr = DictionaryManager.getInstance((KylinConfig)this.dstConfig);
                    DictionaryManager srcDicMgr = DictionaryManager.getInstance((KylinConfig)this.srcConfig);
                    DictionaryInfo dictSrc = srcDicMgr.getDictionaryInfo(item);
                    long ts = dictSrc.getLastModified();
                    dictSrc.setLastModified(0L);
                    Dictionary dictObj = dictSrc.getDictionaryObject().copyToAnotherMeta(this.srcConfig, this.dstConfig);
                    DictionaryInfo dictSaved = dstDictMgr.trySaveNewDict(dictObj, dictSrc);
                    dictSrc.setLastModified(ts);
                    if (dictSaved == dictSrc) {
                        logger.info("Item " + item + " is copied");
                        return;
                    }
                    String cubeName = (String)opt.params[1];
                    String cubeResPath = CubeInstance.concatResourcePath((String)cubeName);
                    JsonSerializer cubeSerializer = new JsonSerializer(CubeInstance.class);
                    CubeInstance cube = (CubeInstance)this.dstStore.getResource(cubeResPath, CubeInstance.class, (Serializer)cubeSerializer);
                    Iterator i$ = cube.getSegments().iterator();
                    block11: while (true) {
                        if (!i$.hasNext()) {
                            this.dstStore.putResource(cubeResPath, (RootPersistentEntity)cube, (Serializer)cubeSerializer);
                            logger.info("Item " + item + " is dup, instead " + dictSaved.getResourcePath() + " is reused");
                            return;
                        }
                        CubeSegment segment = (CubeSegment)i$.next();
                        Iterator iterator = segment.getDictionaries().entrySet().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block11;
                            Map.Entry entry = iterator.next();
                            if (!((String)entry.getValue()).equalsIgnoreCase(item)) continue;
                            entry.setValue(dictSaved.getResourcePath());
                        }
                        break;
                    }
                }
                if (!item.toLowerCase().endsWith(".snapshot")) {
                    logger.error("unknown item found: " + item);
                    logger.info("ignore it");
                    return;
                }
                SnapshotManager dstSnapMgr = SnapshotManager.getInstance((KylinConfig)this.dstConfig);
                SnapshotManager srcSnapMgr = SnapshotManager.getInstance((KylinConfig)this.srcConfig);
                SnapshotTable snapSrc = srcSnapMgr.getSnapshotTable(item);
                long ts = snapSrc.getLastModified();
                snapSrc.setLastModified(0L);
                SnapshotTable snapSaved = dstSnapMgr.trySaveNewSnapshot(snapSrc);
                snapSrc.setLastModified(ts);
                if (snapSaved == snapSrc) {
                    logger.info("Item " + item + " is copied");
                    return;
                }
                String cubeName = (String)opt.params[1];
                String cubeResPath = CubeInstance.concatResourcePath((String)cubeName);
                JsonSerializer cubeSerializer = new JsonSerializer(CubeInstance.class);
                CubeInstance cube = (CubeInstance)this.dstStore.getResource(cubeResPath, CubeInstance.class, (Serializer)cubeSerializer);
                Iterator i$ = cube.getSegments().iterator();
                block13: while (true) {
                    if (!i$.hasNext()) {
                        this.dstStore.putResource(cubeResPath, (RootPersistentEntity)cube, (Serializer)cubeSerializer);
                        logger.info("Item " + item + " is dup, instead " + snapSaved.getResourcePath() + " is reused");
                        return;
                    }
                    CubeSegment segment = (CubeSegment)i$.next();
                    Iterator i$2 = segment.getSnapshots().entrySet().iterator();
                    while (true) {
                        if (!i$2.hasNext()) continue block13;
                        Map.Entry entry = i$2.next();
                        if (!((String)entry.getValue()).equalsIgnoreCase(item)) continue;
                        entry.setValue(snapSaved.getResourcePath());
                    }
                    break;
                }
            }
            case RENAME_FOLDER_IN_HDFS: {
                String srcPath = (String)opt.params[0];
                String dstPath = (String)opt.params[1];
                this.renameHDFSPath(srcPath, dstPath);
                logger.info("HDFS Folder renamed from " + srcPath + " to " + dstPath);
                return;
            }
            case ADD_INTO_PROJECT: {
                CubeInstance srcCube = (CubeInstance)opt.params[0];
                String cubeName = (String)opt.params[1];
                String projectName = (String)opt.params[2];
                String modelName = srcCube.getDescriptor().getModelName();
                String projectResPath = ProjectInstance.concatResourcePath((String)projectName);
                JsonSerializer projectSerializer = new JsonSerializer(ProjectInstance.class);
                ProjectInstance project = (ProjectInstance)this.dstStore.getResource(projectResPath, ProjectInstance.class, (Serializer)projectSerializer);
                Iterator i$ = srcCube.getModel().getAllTables().iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        project.addModel(modelName);
                        project.removeRealization(RealizationType.CUBE, cubeName);
                        project.addRealizationEntry(RealizationType.CUBE, cubeName);
                        this.dstStore.putResource(projectResPath, (RootPersistentEntity)project, (Serializer)projectSerializer);
                        logger.info("Project instance for " + projectName + " is corrected");
                        return;
                    }
                    TableRef tableRef = (TableRef)i$.next();
                    project.addTable(tableRef.getTableIdentity());
                }
            }
            case COPY_ACL: {
                String cubeId = (String)opt.params[0];
                String modelId = (String)opt.params[1];
                String projectName = (String)opt.params[2];
                String projectResPath = ProjectInstance.concatResourcePath((String)projectName);
                JsonSerializer projectSerializer = new JsonSerializer(ProjectInstance.class);
                ProjectInstance project = (ProjectInstance)this.dstStore.getResource(projectResPath, ProjectInstance.class, (Serializer)projectSerializer);
                String projUUID = project.getUuid();
                Table srcAclHtable = null;
                Table destAclHtable = null;
                try {
                    srcAclHtable = HBaseConnection.get((StorageURL)this.srcConfig.getStorageUrl()).getTable(TableName.valueOf((String)(this.srcConfig.getMetadataUrlPrefix() + ACL_TABLE_NAME)));
                    destAclHtable = HBaseConnection.get((StorageURL)this.dstConfig.getStorageUrl()).getTable(TableName.valueOf((String)(this.dstConfig.getMetadataUrlPrefix() + ACL_TABLE_NAME)));
                    Result result = srcAclHtable.get(new Get(Bytes.toBytes((String)cubeId)));
                    if (result.listCells() != null) {
                        for (Cell cell : result.listCells()) {
                            void var16_60;
                            byte[] family = CellUtil.cloneFamily((Cell)cell);
                            byte[] column = CellUtil.cloneQualifier((Cell)cell);
                            byte[] byArray = CellUtil.cloneValue((Cell)cell);
                            if (Bytes.toString((byte[])family).equals(ACL_INFO_FAMILY) && Bytes.toString((byte[])column).equals(ACL_INFO_FAMILY_PARENT_COLUMN)) {
                                String string = "{\"id\":\"" + projUUID + "\",\"type\":\"org.apache.kylin.metadata.project.ProjectInstance\"}";
                                byte[] byArray2 = Bytes.toBytes((String)string);
                            }
                            Put put = new Put(Bytes.toBytes((String)cubeId));
                            put.add(family, column, (byte[])var16_60);
                            destAclHtable.put(put);
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(srcAclHtable);
                    IOUtils.closeQuietly(destAclHtable);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)srcAclHtable);
                IOUtils.closeQuietly((Closeable)destAclHtable);
                return;
            }
            case PURGE_AND_DISABLE: {
                String cubeName = (String)opt.params[0];
                String cubeResPath = CubeInstance.concatResourcePath((String)cubeName);
                JsonSerializer cubeSerializer = new JsonSerializer(CubeInstance.class);
                CubeInstance cube = (CubeInstance)this.srcStore.getResource(cubeResPath, CubeInstance.class, (Serializer)cubeSerializer);
                cube.getSegments().clear();
                cube.setStatus(RealizationStatusEnum.DISABLED);
                this.srcStore.putResource(cubeResPath, (RootPersistentEntity)cube, (Serializer)cubeSerializer);
                logger.info("Cube " + cubeName + " is purged and disabled in " + this.srcConfig.getMetadataUrl());
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undo(Opt opt) throws IOException, InterruptedException {
        logger.info("Undo operation: " + opt.toString());
        switch (opt.type) {
            case CHANGE_HTABLE_HOST: {
                String tableName = (String)opt.params[0];
                HTableDescriptor desc = this.hbaseAdmin.getTableDescriptor(TableName.valueOf((String)tableName));
                this.hbaseAdmin.disableTable(tableName);
                desc.setValue("KYLIN_HOST", this.srcConfig.getMetadataUrlPrefix());
                this.hbaseAdmin.modifyTable(tableName, desc);
                this.hbaseAdmin.enableTable(tableName);
                break;
            }
            case COPY_FILE_IN_META: {
                logger.info("Undo for COPY_FILE_IN_META is ignored");
                break;
            }
            case COPY_DICT_OR_SNAPSHOT: {
                logger.info("Undo for COPY_DICT_OR_SNAPSHOT is ignored");
                break;
            }
            case RENAME_FOLDER_IN_HDFS: {
                String srcPath = (String)opt.params[1];
                String dstPath = (String)opt.params[0];
                if (!this.hdfsFS.exists(new Path(srcPath)) || this.hdfsFS.exists(new Path(dstPath))) break;
                this.renameHDFSPath(srcPath, dstPath);
                logger.info("HDFS Folder renamed from " + srcPath + " to " + dstPath);
                break;
            }
            case ADD_INTO_PROJECT: {
                logger.info("Undo for ADD_INTO_PROJECT is ignored");
                break;
            }
            case COPY_ACL: {
                String cubeId = (String)opt.params[0];
                String modelId = (String)opt.params[1];
                Table destAclHtable = null;
                try {
                    destAclHtable = HBaseConnection.get((StorageURL)this.dstConfig.getStorageUrl()).getTable(TableName.valueOf((String)(this.dstConfig.getMetadataUrlPrefix() + ACL_TABLE_NAME)));
                    destAclHtable.delete(new Delete(Bytes.toBytes((String)cubeId)));
                    destAclHtable.delete(new Delete(Bytes.toBytes((String)modelId)));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(destAclHtable);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)destAclHtable);
                break;
            }
            case PURGE_AND_DISABLE: {
                logger.info("Undo for PURGE_AND_DISABLE is not supported");
                break;
            }
        }
    }

    private void updateMeta(KylinConfig config) {
        String[] nodes;
        for (String node : nodes = config.getRestServers()) {
            RestClient restClient = new RestClient(node);
            try {
                logger.info("update meta cache for " + node);
                restClient.wipeCache("all", Broadcaster.Event.UPDATE.getType(), "all");
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
    }

    private void renameHDFSPath(String srcPath, String dstPath) throws IOException, InterruptedException {
        int nRetry = 0;
        int sleepTime = 5000;
        while (!this.hdfsFS.rename(new Path(srcPath), new Path(dstPath))) {
            if (++nRetry > 3) {
                throw new InterruptedException("Cannot rename folder " + srcPath + " to folder " + dstPath);
            }
            Thread.sleep(sleepTime * nRetry * nRetry);
        }
    }

    private class Opt {
        private OptType type;
        private Object[] params;

        private Opt(OptType type, Object[] params) {
            this.type = type;
            this.params = params;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.type).append(":");
            for (Object s : this.params) {
                sb.append(s).append(", ");
            }
            return sb.toString();
        }
    }

    protected static enum OptType {
        COPY_FILE_IN_META,
        COPY_DICT_OR_SNAPSHOT,
        RENAME_FOLDER_IN_HDFS,
        ADD_INTO_PROJECT,
        CHANGE_HTABLE_HOST,
        COPY_ACL,
        PURGE_AND_DISABLE;

    }
}

