/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.tool.AbstractInfoExtractor;
import org.apache.kylin.tool.util.ToolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinLogExtractor
extends AbstractInfoExtractor {
    private static final Logger logger = LoggerFactory.getLogger(KylinLogExtractor.class);
    private static final int DEFAULT_LOG_PERIOD = 3;
    private static final Option OPTION_LOG_PERIOD;
    KylinConfig config;

    public KylinLogExtractor() {
        this.packageType = "logs";
        this.options.addOption(OPTION_LOG_PERIOD);
        this.config = KylinConfig.getInstanceFromEnv();
    }

    private void beforeExtract() {
        logger.info("Start to reload metadata from diagnosis.");
        CubeManager.clearCache();
        CubeManager.getInstance((KylinConfig)this.config);
        CubeDescManager.clearCache();
        CubeDescManager.getInstance((KylinConfig)this.config);
        MetadataManager.clearCache();
        MetadataManager.getInstance((KylinConfig)this.config);
        ProjectManager.clearCache();
        ProjectManager.getInstance((KylinConfig)this.config);
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        int logPeriod;
        this.beforeExtract();
        int n = logPeriod = optionsHelper.hasOption(OPTION_LOG_PERIOD) ? Integer.valueOf(optionsHelper.getOptionValue(OPTION_LOG_PERIOD)) : 3;
        if (logPeriod < 1) {
            logger.warn("No logs to extract.");
            return;
        }
        logger.info("Start to extract kylin logs in {} days", (Object)logPeriod);
        ArrayList logDirs = Lists.newArrayList();
        logDirs.add(new File(KylinConfig.getKylinHome(), "logs"));
        String kylinVersion = ToolUtil.decideKylinMajorVersionFromCommitFile();
        if (kylinVersion != null && kylinVersion.equals("1.3")) {
            logDirs.add(new File(KylinConfig.getKylinHome(), "tomcat/logs"));
        }
        ArrayList requiredLogFiles = Lists.newArrayList();
        long logThresholdTime = System.currentTimeMillis() - (long)(logPeriod * 24 * 3600 * 1000);
        for (File kylinLogDir : logDirs) {
            File[] allLogFiles = kylinLogDir.listFiles();
            if (allLogFiles == null || allLogFiles.length == 0) {
                return;
            }
            for (File logFile : allLogFiles) {
                if (logFile.lastModified() <= logThresholdTime) continue;
                requiredLogFiles.add(logFile);
            }
        }
        for (File logFile : requiredLogFiles) {
            logger.info("Log file:" + logFile.getAbsolutePath());
            if (!logFile.exists()) continue;
            FileUtils.copyFileToDirectory((File)logFile, (File)exportDir);
        }
    }

    static {
        OptionBuilder.withArgName((String)"logPeriod");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"specify how many days of kylin logs to extract. Default 3.");
        OPTION_LOG_PERIOD = OptionBuilder.create((String)"logPeriod");
    }
}

