/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.RMHAUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.engine.mr.HadoopUtil;
import org.apache.kylin.tool.AbstractInfoExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobTaskCounterExtractor
extends AbstractInfoExtractor {
    private String mrJobId;
    private String yarnUrl;
    private static final Logger logger = LoggerFactory.getLogger(JobTaskCounterExtractor.class);

    public JobTaskCounterExtractor(String mrJobId) {
        this.mrJobId = mrJobId;
        this.yarnUrl = this.getRestCheckUrl();
    }

    private String getRestCheckUrl() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String yarnStatusCheckUrl = config.getYarnStatusCheckUrl();
        Pattern pattern = Pattern.compile("(http://)(.*):.*");
        if (yarnStatusCheckUrl != null) {
            Matcher m = pattern.matcher(yarnStatusCheckUrl);
            m.matches();
            this.yarnUrl = m.group(1) + m.group(2) + ":19888";
            return this.yarnUrl;
        }
        logger.info("kylin.job.yarn.app.rest.check.status.url is not set read from hadoop configuration");
        Configuration conf = HadoopUtil.getCurrentConfiguration();
        String rmWebHost = HAUtil.getConfValueForRMInstance((String)"yarn.resourcemanager.webapp.address", (String)"0.0.0.0:8088", (Configuration)conf);
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            YarnConfiguration yarnConf = new YarnConfiguration(conf);
            String active = RMHAUtils.findActiveRMHAId((YarnConfiguration)yarnConf);
            rmWebHost = HAUtil.getConfValueForRMInstance((String)HAUtil.addSuffix((String)"yarn.resourcemanager.webapp.address", (String)active), (String)"0.0.0.0:8088", (Configuration)yarnConf);
        }
        if (StringUtils.isEmpty((String)rmWebHost)) {
            return null;
        }
        if (!rmWebHost.startsWith("http://") && !rmWebHost.startsWith("https://")) {
            rmWebHost = "http://" + rmWebHost;
        }
        Matcher m = pattern.matcher(rmWebHost);
        m.matches();
        return m.group(1) + m.group(2) + ":19888";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHttpResponse(String url) {
        HttpClient client = new HttpClient();
        String response = null;
        while (response == null) {
            GetMethod get = new GetMethod(url);
            try {
                get.addRequestHeader("accept", "application/json");
                client.executeMethod((HttpMethod)get);
                response = get.getResponseBodyAsString();
            }
            catch (Exception e) {
                logger.warn("Failed to fetch http response" + e);
            }
            finally {
                get.releaseConnection();
            }
        }
        return response;
    }

    protected void executeExtract(File exportDir) {
        try {
            String taskUrl = this.yarnUrl + "/ws/v1/history/mapreduce/jobs/" + this.mrJobId + "/tasks/";
            String tasksResponse = this.getHttpResponse(taskUrl);
            JsonNode tasks = new ObjectMapper().readTree(tasksResponse).path("tasks").path("task");
            String maxReduceId = null;
            String maxMapId = null;
            long maxMapElapsedTime = 0L;
            long maxReduceElapsedTime = 0L;
            for (JsonNode node : tasks) {
                if (node.get("type").textValue().equals("MAP") && node.get("elapsedTime").longValue() >= maxMapElapsedTime) {
                    maxMapElapsedTime = node.get("elapsedTime").longValue();
                    maxMapId = node.get("id").textValue();
                }
                if (!node.get("type").textValue().equals("REDUCE") || node.get("elapsedTime").longValue() < maxReduceElapsedTime) continue;
                maxReduceElapsedTime = node.get("elapsedTime").longValue();
                maxReduceId = node.get("id").textValue();
            }
            this.extractTaskCounterFile(maxMapId, exportDir, taskUrl);
            this.extractTaskCounterFile(maxReduceId, exportDir, taskUrl);
        }
        catch (Exception e) {
            logger.warn("Failed to get mr tasks rest response" + e);
        }
    }

    private void extractTaskCounterFile(String taskId, File exportDir, String taskUrl) throws IOException {
        try {
            String response = this.getHttpResponse(taskUrl + taskId + "/counters");
            FileUtils.writeStringToFile((File)new File(exportDir, taskId + ".json"), (String)response, (Charset)Charset.defaultCharset());
        }
        catch (Exception e) {
            logger.warn("Failed to get task counters rest response" + e);
        }
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        this.executeExtract(exportDir);
    }
}

