/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationRegistry;
import org.apache.kylin.tool.AbstractInfoExtractor;
import org.apache.kylin.tool.CubeMetaExtractor;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseUsageExtractor
extends AbstractInfoExtractor {
    private static final Logger logger = LoggerFactory.getLogger(CubeMetaExtractor.class);
    private static final Option OPTION_CUBE;
    private static final Option OPTION_PROJECT;
    private List<String> htables = Lists.newArrayList();
    private Configuration conf;
    private CubeManager cubeManager;
    private RealizationRegistry realizationRegistry;
    private KylinConfig kylinConfig;
    private ProjectManager projectManager;

    public HBaseUsageExtractor() {
        this.packageType = "hbase";
        OptionGroup realizationOrProject = new OptionGroup();
        realizationOrProject.addOption(OPTION_CUBE);
        realizationOrProject.addOption(OPTION_PROJECT);
        realizationOrProject.setRequired(true);
        this.options.addOptionGroup(realizationOrProject);
        this.conf = HBaseConfiguration.create();
    }

    public static void main(String[] args) {
        HBaseUsageExtractor extractor = new HBaseUsageExtractor();
        extractor.execute(args);
    }

    private String getHBaseMasterUrl() throws IOException, KeeperException {
        String host = this.conf.get("hbase.master.info.bindAddress");
        if (host.equals("0.0.0.0")) {
            host = MasterAddressTracker.getMasterAddress((ZooKeeperWatcher)new ZooKeeperWatcher(this.conf, null, null)).getHostname();
        }
        String port = this.conf.get("hbase.master.info.port");
        return "http://" + host + ":" + port + "/";
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.cubeManager = CubeManager.getInstance((KylinConfig)this.kylinConfig);
        this.realizationRegistry = RealizationRegistry.getInstance((KylinConfig)this.kylinConfig);
        this.projectManager = ProjectManager.getInstance((KylinConfig)this.kylinConfig);
        if (optionsHelper.hasOption(OPTION_PROJECT)) {
            String projectNames = optionsHelper.getOptionValue(OPTION_PROJECT);
            for (String projectName : projectNames.split(",")) {
                ProjectInstance projectInstance = this.projectManager.getProject(projectName);
                if (projectInstance == null) {
                    throw new IllegalArgumentException("Project " + projectName + " does not exist");
                }
                List realizationEntries = projectInstance.getRealizationEntries();
                for (RealizationEntry realizationEntry : realizationEntries) {
                    this.retrieveResourcePath(this.getRealization(realizationEntry));
                }
            }
        } else if (optionsHelper.hasOption(OPTION_CUBE)) {
            String cubeNames = optionsHelper.getOptionValue(OPTION_CUBE);
            for (String cubeName : cubeNames.split(",")) {
                IRealization realization = this.cubeManager.getRealization(cubeName);
                if (realization == null) {
                    throw new IllegalArgumentException("No cube found with name of " + cubeName);
                }
                this.retrieveResourcePath(realization);
            }
        }
        this.extractCommonInfo(exportDir);
        this.extractHTables(exportDir);
    }

    private void extractHTables(File dest) throws IOException {
        logger.info("These htables are going to be extracted:");
        for (String htable : this.htables) {
            logger.info(htable + "(required)");
        }
        File tableDir = new File(dest, "table");
        FileUtils.forceMkdir((File)tableDir);
        for (String htable : this.htables) {
            try {
                URL srcUrl = new URL(this.getHBaseMasterUrl() + "table.jsp?name=" + htable);
                File destFile = new File(tableDir, htable + ".html");
                FileUtils.copyURLToFile((URL)srcUrl, (File)destFile);
            }
            catch (Exception e) {
                logger.warn("HTable " + htable + "info fetch failed: ", (Throwable)e);
            }
        }
    }

    private void extractCommonInfo(File dest) throws IOException {
        logger.info("The hbase master info/conf are going to be extracted...");
        try {
            File masterDir = new File(dest, "master");
            FileUtils.forceMkdir((File)masterDir);
            URL srcMasterUrl = new URL(this.getHBaseMasterUrl() + "master-status");
            File masterDestFile = new File(masterDir, "master-status.html");
            FileUtils.copyURLToFile((URL)srcMasterUrl, (File)masterDestFile);
        }
        catch (Exception e) {
            logger.warn("HBase Master status fetch failed: ", (Throwable)e);
        }
        try {
            File confDir = new File(dest, "conf");
            FileUtils.forceMkdir((File)confDir);
            URL srcConfUrl = new URL(this.getHBaseMasterUrl() + "conf");
            File destConfFile = new File(confDir, "hbase-conf.xml");
            FileUtils.copyURLToFile((URL)srcConfUrl, (File)destConfFile);
        }
        catch (Exception e) {
            logger.warn("HBase conf fetch failed: ", (Throwable)e);
        }
        try {
            File jmxDir = new File(dest, "jmx");
            FileUtils.forceMkdir((File)jmxDir);
            URL srcJmxUrl = new URL(this.getHBaseMasterUrl() + "jmx");
            File jmxDestFile = new File(jmxDir, "jmx.html");
            FileUtils.copyURLToFile((URL)srcJmxUrl, (File)jmxDestFile);
        }
        catch (Exception e) {
            logger.warn("HBase JMX fetch failed: ", (Throwable)e);
        }
        try {
            File hdfsDir = new File(dest, "hdfs");
            FileUtils.forceMkdir((File)hdfsDir);
            CliCommandExecutor cliCommandExecutor = this.kylinConfig.getCliCommandExecutor();
            String output = (String)cliCommandExecutor.execute("hadoop fs -ls -R " + this.conf.get("hbase.rootdir") + "/data/default/KYLIN_*").getSecond();
            FileUtils.writeStringToFile((File)new File(hdfsDir, "hdfs-files.list"), (String)output, (Charset)Charset.defaultCharset());
            output = (String)cliCommandExecutor.execute("hadoop fs -ls -R " + this.conf.get("hbase.rootdir") + "/data/default/kylin_*").getSecond();
            FileUtils.writeStringToFile((File)new File(hdfsDir, "hdfs-files.list"), (String)output, (Charset)Charset.defaultCharset(), (boolean)true);
        }
        catch (Exception e) {
            logger.warn("HBase hdfs status fetch failed: ", (Throwable)e);
        }
    }

    private IRealization getRealization(RealizationEntry realizationEntry) {
        return this.realizationRegistry.getRealization(realizationEntry.getType(), realizationEntry.getRealization());
    }

    private void retrieveResourcePath(IRealization realization) {
        logger.info("Deal with realization {} of type {}", (Object)realization.getName(), (Object)realization.getType());
        if (realization instanceof CubeInstance) {
            CubeInstance cube = (CubeInstance)realization;
            for (CubeSegment segment : cube.getSegments()) {
                this.addHTable(segment.getStorageLocationIdentifier());
            }
        } else {
            logger.warn("Unknown realization type: " + realization.getType());
        }
    }

    private void addHTable(String record) {
        logger.info("adding required resource {}", (Object)record);
        this.htables.add(record);
    }

    static {
        OptionBuilder.withArgName((String)"cube");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify which cube to extract");
        OPTION_CUBE = OptionBuilder.create((String)"cube");
        OptionBuilder.withArgName((String)"project");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify realizations in which project to extract");
        OPTION_PROJECT = OptionBuilder.create((String)"project");
    }
}

