/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.ResourceTool;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.streaming.StreamingConfig;
import org.apache.kylin.engine.streaming.StreamingManager;
import org.apache.kylin.job.dao.ExecutableDao;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.exception.PersistentException;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.badquery.BadQueryHistoryManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationRegistry;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.source.kafka.config.KafkaConfig;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.apache.kylin.storage.hybrid.HybridManager;
import org.apache.kylin.tool.AbstractInfoExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeMetaExtractor
extends AbstractInfoExtractor {
    private static final Logger logger = LoggerFactory.getLogger(CubeMetaExtractor.class);
    private static final Option OPTION_CUBE;
    private static final Option OPTION_HYBRID;
    private static final Option OPTION_PROJECT;
    private static final Option OPTION_INCLUDE_SEGMENTS;
    private static final Option OPTION_INCLUDE_JOB;
    private static final Option OPTION_INCLUDE_ONLY_JOB_OUTPUT;
    private static final Option OPTION_INCLUDE_SEGMENT_DETAILS;
    private KylinConfig kylinConfig;
    private MetadataManager metadataManager;
    private ProjectManager projectManager;
    private HybridManager hybridManager;
    private CubeManager cubeManager;
    private StreamingManager streamingManager;
    private CubeDescManager cubeDescManager;
    private ExecutableDao executableDao;
    private RealizationRegistry realizationRegistry;
    private BadQueryHistoryManager badQueryHistoryManager;
    private boolean includeSegments;
    private boolean includeJobs;
    private boolean includeSegmentDetails;
    private boolean onlyJobOutput;
    private Set<String> requiredResources = Sets.newLinkedHashSet();
    private Set<String> optionalResources = Sets.newLinkedHashSet();
    private Set<CubeInstance> cubesToTrimAndSave = Sets.newLinkedHashSet();

    public CubeMetaExtractor() {
        this.packageType = "cubemeta";
        OptionGroup realizationOrProject = new OptionGroup();
        realizationOrProject.addOption(OPTION_CUBE);
        realizationOrProject.addOption(OPTION_PROJECT);
        realizationOrProject.addOption(OPTION_HYBRID);
        realizationOrProject.setRequired(true);
        this.options.addOptionGroup(realizationOrProject);
        this.options.addOption(OPTION_INCLUDE_SEGMENTS);
        this.options.addOption(OPTION_INCLUDE_JOB);
        this.options.addOption(OPTION_INCLUDE_SEGMENT_DETAILS);
        this.options.addOption(OPTION_INCLUDE_ONLY_JOB_OUTPUT);
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        this.includeSegments = optionsHelper.hasOption(OPTION_INCLUDE_SEGMENTS) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_SEGMENTS)) : true;
        this.includeJobs = optionsHelper.hasOption(OPTION_INCLUDE_JOB) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_JOB)) : false;
        this.includeSegmentDetails = optionsHelper.hasOption(OPTION_INCLUDE_SEGMENT_DETAILS) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_SEGMENT_DETAILS)) : false;
        this.onlyJobOutput = optionsHelper.hasOption(OPTION_INCLUDE_ONLY_JOB_OUTPUT) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_INCLUDE_ONLY_JOB_OUTPUT)) : true;
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.metadataManager = MetadataManager.getInstance((KylinConfig)this.kylinConfig);
        this.projectManager = ProjectManager.getInstance((KylinConfig)this.kylinConfig);
        this.hybridManager = HybridManager.getInstance((KylinConfig)this.kylinConfig);
        this.cubeManager = CubeManager.getInstance((KylinConfig)this.kylinConfig);
        this.cubeDescManager = CubeDescManager.getInstance((KylinConfig)this.kylinConfig);
        this.executableDao = ExecutableDao.getInstance((KylinConfig)this.kylinConfig);
        this.realizationRegistry = RealizationRegistry.getInstance((KylinConfig)this.kylinConfig);
        this.badQueryHistoryManager = BadQueryHistoryManager.getInstance((KylinConfig)this.kylinConfig);
        if (optionsHelper.hasOption(OPTION_PROJECT)) {
            String projectNames = optionsHelper.getOptionValue(OPTION_PROJECT);
            for (String projectName : projectNames.split(",")) {
                ProjectInstance projectInstance = this.projectManager.getProject(projectName);
                if (projectInstance == null) {
                    throw new IllegalArgumentException("Project " + projectName + " does not exist");
                }
                this.addRequired(projectInstance.getResourcePath());
                List realizationEntries = projectInstance.getRealizationEntries();
                for (RealizationEntry realizationEntry : realizationEntries) {
                    this.retrieveResourcePath(this.getRealization(realizationEntry));
                }
                List modelDescs = this.metadataManager.getModels(projectName);
                for (DataModelDesc modelDesc : modelDescs) {
                    this.addRequired(DataModelDesc.concatResourcePath((String)modelDesc.getName()));
                }
                this.addOptional(this.badQueryHistoryManager.getBadQueriesForProject(projectName).getResourcePath());
            }
        } else if (optionsHelper.hasOption(OPTION_CUBE)) {
            String cubeNames = optionsHelper.getOptionValue(OPTION_CUBE);
            for (String cubeName : cubeNames.split(",")) {
                IRealization realization = this.cubeManager.getRealization(cubeName);
                if (realization == null) {
                    throw new IllegalArgumentException("No cube found with name of " + cubeName);
                }
                this.retrieveResourcePath(realization);
            }
        } else if (optionsHelper.hasOption(OPTION_HYBRID)) {
            String hybridNames = optionsHelper.getOptionValue(OPTION_HYBRID);
            for (String hybridName : hybridNames.split(",")) {
                IRealization realization = this.hybridManager.getRealization(hybridName);
                if (realization == null) {
                    throw new IllegalArgumentException("No hybrid found with name of" + hybridName);
                }
                this.retrieveResourcePath(realization);
            }
        }
        this.executeExtraction(exportDir.getAbsolutePath());
    }

    private void executeExtraction(String dest) {
        logger.info("The resource paths going to be extracted:");
        for (String s : this.requiredResources) {
            logger.info(s + "(required)");
        }
        for (String s : this.optionalResources) {
            logger.info(s + "(optional)");
        }
        for (CubeInstance cube : this.cubesToTrimAndSave) {
            logger.info("Cube {} will be trimmed and extracted", (Object)cube);
        }
        try {
            KylinConfig srcConfig = KylinConfig.getInstanceFromEnv();
            KylinConfig dstConfig = KylinConfig.createInstanceFromUri((String)dest);
            ResourceTool.copy((KylinConfig)srcConfig, (KylinConfig)dstConfig, (List)Lists.newArrayList(this.requiredResources));
            for (String r : this.optionalResources) {
                try {
                    ResourceTool.copy((KylinConfig)srcConfig, (KylinConfig)dstConfig, (List)Lists.newArrayList((Object[])new String[]{r}));
                }
                catch (Exception e) {
                    logger.warn("Exception when copying optional resource {}. May be caused by resource missing. skip it.", (Object)r);
                }
            }
            ResourceStore dstStore = ResourceStore.getStore((KylinConfig)dstConfig);
            for (CubeInstance cube : this.cubesToTrimAndSave) {
                CubeInstance trimmedCube = CubeInstance.getCopyOf((CubeInstance)cube);
                trimmedCube.getSegments().clear();
                trimmedCube.setUuid(cube.getUuid());
                dstStore.putResource(trimmedCube.getResourcePath(), (RootPersistentEntity)trimmedCube, CubeManager.CUBE_SERIALIZER);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception", e);
        }
    }

    private IRealization getRealization(RealizationEntry realizationEntry) {
        return this.realizationRegistry.getRealization(realizationEntry.getType(), realizationEntry.getRealization());
    }

    private void dealWithStreaming(CubeInstance cube) {
        this.streamingManager = StreamingManager.getInstance((KylinConfig)this.kylinConfig);
        for (StreamingConfig streamingConfig : this.streamingManager.listAllStreaming()) {
            if (streamingConfig.getName() == null || !streamingConfig.getName().equalsIgnoreCase(cube.getFactTable())) continue;
            this.addRequired(StreamingConfig.concatResourcePath((String)streamingConfig.getName()));
            this.addRequired(KafkaConfig.concatResourcePath((String)streamingConfig.getName()));
        }
    }

    private void retrieveResourcePath(IRealization realization) {
        if (realization == null) {
            return;
        }
        logger.info("Deal with realization {} of type {}", (Object)realization.getName(), (Object)realization.getType());
        if (realization instanceof CubeInstance) {
            CubeInstance cube = (CubeInstance)realization;
            String descName = cube.getDescName();
            CubeDesc cubeDesc = this.cubeDescManager.getCubeDesc(descName);
            String modelName = cubeDesc.getModelName();
            DataModelDesc modelDesc = this.metadataManager.getDataModelDesc(modelName);
            this.dealWithStreaming(cube);
            for (String tableName : modelDesc.getAllTables()) {
                this.addRequired(TableDesc.concatResourcePath((String)tableName));
                this.addOptional(TableDesc.concatExdResourcePath((String)tableName));
            }
            this.addRequired(DataModelDesc.concatResourcePath((String)modelDesc.getName()));
            this.addRequired(CubeDesc.concatResourcePath((String)cubeDesc.getName()));
            if (this.includeSegments) {
                this.addRequired(CubeInstance.concatResourcePath((String)cube.getName()));
                for (CubeSegment segment : cube.getSegments(SegmentStatusEnum.READY)) {
                    this.addRequired(CubeSegment.getStatisticsResourcePath((String)cube.getName(), (String)segment.getUuid()));
                    if (this.includeSegmentDetails) {
                        for (String dictPat : segment.getDictionaryPaths()) {
                            this.addRequired(dictPat);
                        }
                        for (String snapshotPath : segment.getSnapshotPaths()) {
                            this.addRequired(snapshotPath);
                        }
                    }
                    if (!this.includeJobs) continue;
                    String lastJobId = segment.getLastBuildJobID();
                    if (StringUtils.isEmpty((CharSequence)lastJobId)) {
                        throw new RuntimeException("No job exist for segment :" + segment);
                    }
                    try {
                        ExecutablePO executablePO;
                        if (this.onlyJobOutput) {
                            executablePO = this.executableDao.getJob(lastJobId);
                            this.addRequired("/execute_output/" + lastJobId);
                            continue;
                        }
                        executablePO = this.executableDao.getJob(lastJobId);
                        this.addRequired("/execute/" + lastJobId);
                        this.addRequired("/execute_output/" + lastJobId);
                        for (ExecutablePO task : executablePO.getTasks()) {
                            this.addRequired("/execute/" + task.getUuid());
                            this.addRequired("/execute_output/" + task.getUuid());
                        }
                    }
                    catch (PersistentException e) {
                        throw new RuntimeException("PersistentException", e);
                    }
                }
            } else {
                if (this.includeJobs) {
                    logger.warn("It's useless to set includeJobs to true when includeSegments is set to false");
                }
                this.cubesToTrimAndSave.add(cube);
            }
        } else if (realization instanceof HybridInstance) {
            HybridInstance hybridInstance = (HybridInstance)realization;
            this.addRequired(HybridInstance.concatResourcePath((String)hybridInstance.getName()));
            for (IRealization iRealization : hybridInstance.getRealizations()) {
                if (iRealization.getType() != RealizationType.CUBE) {
                    throw new RuntimeException("Hybrid " + iRealization.getName() + " contains non cube child " + iRealization.getName() + " with type " + iRealization.getType());
                }
                this.retrieveResourcePath(iRealization);
            }
        } else {
            logger.warn("Unknown realization type: " + realization.getType());
        }
    }

    private void addRequired(String record) {
        logger.info("adding required resource {}", (Object)record);
        this.requiredResources.add(record);
    }

    private void addOptional(String record) {
        logger.info("adding optional resource {}", (Object)record);
        this.optionalResources.add(record);
    }

    public static void main(String[] args) {
        CubeMetaExtractor extractor = new CubeMetaExtractor();
        extractor.execute(args);
    }

    static {
        OptionBuilder.withArgName((String)"cube");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify which cube to extract");
        OPTION_CUBE = OptionBuilder.create((String)"cube");
        OptionBuilder.withArgName((String)"hybrid");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify which hybrid to extract");
        OPTION_HYBRID = OptionBuilder.create((String)"hybrid");
        OptionBuilder.withArgName((String)"project");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify realizations in which project to extract");
        OPTION_PROJECT = OptionBuilder.create((String)"project");
        OptionBuilder.withArgName((String)"includeSegments");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"set this to true if want extract the segments info. Default true");
        OPTION_INCLUDE_SEGMENTS = OptionBuilder.create((String)"includeSegments");
        OptionBuilder.withArgName((String)"includeJobs");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"set this to true if want to extract job info/outputs too. Default false");
        OPTION_INCLUDE_JOB = OptionBuilder.create((String)"includeJobs");
        OptionBuilder.withArgName((String)"onlyOutput");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"when include jobs, onlt extract output of job. Default true");
        OPTION_INCLUDE_ONLY_JOB_OUTPUT = OptionBuilder.create((String)"onlyOutput");
        OptionBuilder.withArgName((String)"includeSegmentDetails");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"set this to true if want to extract segment details too, such as dict, tablesnapshot. Default false");
        OPTION_INCLUDE_SEGMENT_DETAILS = OptionBuilder.create((String)"includeSegmentDetails");
    }
}

