/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.ZipFileUtils;
import org.apache.kylin.tool.util.ToolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInfoExtractor
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInfoExtractor.class);
    private static final Option OPTION_DEST;
    private static final Option OPTION_COMPRESS;
    private static final Option OPTION_SUBMODULE;
    private static final String DEFAULT_PACKAGE_TYPE = "base";
    private static final String[] COMMIT_SHA1_FILES;
    protected final Options options = new Options();
    protected String packageType;
    protected File exportDir;

    public AbstractInfoExtractor() {
        this.options.addOption(OPTION_DEST);
        this.options.addOption(OPTION_COMPRESS);
        this.options.addOption(OPTION_SUBMODULE);
        this.packageType = DEFAULT_PACKAGE_TYPE;
    }

    @Override
    protected Options getOptions() {
        return this.options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        boolean isSubmodule;
        String exportDest = optionsHelper.getOptionValue(this.options.getOption("destDir"));
        boolean shouldCompress = optionsHelper.hasOption(OPTION_COMPRESS) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_COMPRESS)) : true;
        boolean bl = isSubmodule = optionsHelper.hasOption(OPTION_SUBMODULE) ? Boolean.valueOf(optionsHelper.getOptionValue(OPTION_SUBMODULE)) : false;
        if (StringUtils.isEmpty((String)exportDest)) {
            throw new RuntimeException("destDir is not set, exit directly without extracting");
        }
        if (!exportDest.endsWith("/")) {
            exportDest = exportDest + "/";
        }
        String packageName = this.packageType.toLowerCase() + "_" + new SimpleDateFormat("YYYY_MM_dd_HH_mm_ss").format(new Date());
        if (new File(exportDest).exists()) {
            exportDest = exportDest + packageName + "/";
        }
        this.exportDir = new File(exportDest);
        if (!isSubmodule) {
            this.dumpBasicDiagInfo();
        }
        this.executeExtract(optionsHelper, this.exportDir);
        if (shouldCompress) {
            File tempZipFile = File.createTempFile(this.packageType + "_", ".zip");
            ZipFileUtils.compressZipFile(this.exportDir.getAbsolutePath(), tempZipFile.getAbsolutePath());
            FileUtils.cleanDirectory((File)this.exportDir);
            File zipFile = new File(this.exportDir, packageName + ".zip");
            FileUtils.moveFile((File)tempZipFile, (File)zipFile);
            exportDest = zipFile.getAbsolutePath();
            this.exportDir = new File(exportDest);
        }
        if (!isSubmodule) {
            StringBuffer output = new StringBuffer();
            output.append("\n========================================");
            output.append("\nDump " + this.packageType + " package locates at: \n" + this.exportDir.getAbsolutePath());
            output.append("\n========================================");
            logger.info(output.toString());
        }
    }

    private void dumpBasicDiagInfo() throws IOException {
        try {
            for (String commitSHA1File : COMMIT_SHA1_FILES) {
                if (!new File(commitSHA1File).exists()) continue;
                FileUtils.copyFileToDirectory((File)new File(KylinConfig.getKylinHome(), commitSHA1File), (File)this.exportDir);
            }
        }
        catch (IOException e) {
            logger.warn("Failed to copy commit_SHA1 file.", (Throwable)e);
        }
        String output = KylinVersion.getKylinClientInformation() + "\n";
        FileUtils.writeStringToFile((File)new File(this.exportDir, "kylin_env"), (String)output);
        StringBuilder basicSb = new StringBuilder();
        basicSb.append("MetaStoreID: ").append(ToolUtil.getHBaseMetaStoreId()).append("\n");
        basicSb.append("PackageType: ").append(this.packageType.toUpperCase()).append("\n");
        FileUtils.writeStringToFile((File)new File(this.exportDir, "info"), (String)basicSb.toString());
    }

    protected abstract void executeExtract(OptionsHelper var1, File var2) throws Exception;

    public String getExportDest() {
        return this.exportDir.getAbsolutePath();
    }

    static {
        OptionBuilder.withArgName((String)"destDir");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"specify the dest dir to save the related information");
        OPTION_DEST = OptionBuilder.create((String)"destDir");
        OptionBuilder.withArgName((String)"compress");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"specify whether to compress the output with zip. Default true.");
        OPTION_COMPRESS = OptionBuilder.create((String)"compress");
        OptionBuilder.withArgName((String)"submodule");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"specify whether this is a submodule of other CLI tool");
        OPTION_SUBMODULE = OptionBuilder.create((String)"submodule");
        COMMIT_SHA1_FILES = new String[]{"commit_SHA1", "commit.sha1"};
    }
}

