/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.ByteArrayWritable;
import org.apache.kylin.engine.mr.HadoopUtil;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.steps.KVGTRecordWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceFileCuboidWriter
extends KVGTRecordWriter {
    private static final Logger logger = LoggerFactory.getLogger(SequenceFileCuboidWriter.class);
    private SequenceFile.Writer writer = null;

    public SequenceFileCuboidWriter(CubeDesc cubeDesc, CubeSegment segment) {
        super(cubeDesc, segment);
        try {
            this.initiate();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initiate() throws IOException {
        if (this.writer == null) {
            JobBuilderSupport jobBuilderSupport = new JobBuilderSupport(this.cubeSegment, "SYSTEM");
            String cuboidRoot = jobBuilderSupport.getCuboidRootPath(this.cubeSegment);
            Path cuboidPath = new Path(cuboidRoot);
            FileSystem fs = HadoopUtil.getFileSystem(cuboidRoot);
            try {
                if (fs.exists(cuboidPath)) {
                    fs.delete(cuboidPath, true);
                }
                fs.mkdirs(cuboidPath);
            }
            finally {
                IOUtils.closeQuietly((Closeable)fs);
            }
            Path cuboidFile = new Path(cuboidPath, "data.seq");
            logger.debug("Cuboid is written to " + cuboidFile);
            this.writer = SequenceFile.createWriter((Configuration)HadoopUtil.getCurrentConfiguration(), (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)cuboidFile), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(Text.class)});
        }
    }

    @Override
    protected void writeAsKeyValue(ByteArrayWritable key, ByteArrayWritable value) throws IOException {
        Text outputValue = new Text();
        Text outputKey = new Text();
        outputKey.set(key.array(), key.offset(), key.length());
        outputValue.set(value.array(), value.offset(), value.length());
        this.writer.append((Writable)outputKey, (Writable)outputValue);
    }

    @Override
    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.hflush();
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((Closeable)this.writer);
    }
}

