/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.inmemcubing.CompoundCuboidWriter;
import org.apache.kylin.cube.inmemcubing.ICuboidWriter;
import org.apache.kylin.engine.mr.HadoopUtil;
import org.apache.kylin.engine.mr.common.CuboidStatsUtil;
import org.apache.kylin.engine.streaming.IStreamingOutput;
import org.apache.kylin.measure.hllc.HyperLogLogPlusCounter;
import org.apache.kylin.metadata.model.IBuildable;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.steps.CubeHTableUtil;
import org.apache.kylin.storage.hbase.steps.HBaseCuboidWriter;
import org.apache.kylin.storage.hbase.steps.SequenceFileCuboidWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseStreamingOutput
implements IStreamingOutput {
    private static final Logger logger = LoggerFactory.getLogger(HBaseStreamingOutput.class);

    @Override
    public ICuboidWriter getCuboidWriter(IBuildable buildable) {
        try {
            CubeSegment cubeSegment = (CubeSegment)buildable;
            HTableInterface hTable = this.createHTable(cubeSegment);
            ArrayList cuboidWriters = Lists.newArrayList();
            cuboidWriters.add(new HBaseCuboidWriter(cubeSegment, hTable));
            cuboidWriters.add(new SequenceFileCuboidWriter(cubeSegment.getCubeDesc(), cubeSegment));
            return new CompoundCuboidWriter(cuboidWriters);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to get ICuboidWriter", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void output(IBuildable buildable, Map<Long, HyperLogLogPlusCounter> samplingResult) {
        try {
            CubeSegment cubeSegment = (CubeSegment)buildable;
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            Configuration conf = HadoopUtil.getCurrentConfiguration();
            Path outputPath = new Path("file:///tmp/kylin/cuboidstatistics/" + UUID.randomUUID().toString());
            CuboidStatsUtil.writeCuboidStatistics(conf, outputPath, samplingResult, 100);
            FSDataInputStream inputStream = null;
            try {
                inputStream = FileSystem.getLocal((Configuration)conf).open(new Path(outputPath, "cuboid_statistics.seq"));
                ResourceStore.getStore(kylinConfig).putResource(cubeSegment.getStatisticsResourcePath(), (InputStream)inputStream, System.currentTimeMillis());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                FileSystem.getLocal((Configuration)conf).delete(outputPath, true);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            FileSystem.getLocal((Configuration)conf).delete(outputPath, true);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to write sampling result", e);
        }
    }

    private HTableInterface createHTable(CubeSegment cubeSegment) throws IOException {
        String hTableName = cubeSegment.getStorageLocationIdentifier();
        CubeHTableUtil.createHTable(cubeSegment, null);
        HTableInterface hTable = HBaseConnection.get(KylinConfig.getInstanceFromEnv().getStorageUrl()).getTable(hTableName);
        logger.info("hTable:" + hTableName + " for segment:" + cubeSegment.getName() + " created!");
        return hTable;
    }
}

