/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.ii.coprocessor.endpoint;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.dimension.DictionaryDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.FixedLenDimEnc;
import org.apache.kylin.dimension.IDimensionEncodingMap;
import org.apache.kylin.invertedindex.index.TableRecordInfoDigest;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorRowType;

public class LocalDictionary
implements IDimensionEncodingMap {
    private CoprocessorRowType type;
    private Dictionary<?>[] colDictMap;
    private TableRecordInfoDigest recordInfo;
    private Map<TblColRef, DimensionEncoding> encMap;

    public LocalDictionary(Dictionary<?>[] colDictMap, CoprocessorRowType type, TableRecordInfoDigest recordInfo) {
        this.colDictMap = colDictMap;
        this.type = type;
        this.recordInfo = recordInfo;
        this.encMap = Maps.newHashMap();
    }

    @Override
    public DimensionEncoding get(TblColRef col) {
        DimensionEncoding result = this.encMap.get(col);
        if (result == null) {
            Dictionary<String> dict = this.getDictionary(col);
            if (dict == null) {
                int idx = this.type.getColIndexByTblColRef(col);
                int len = this.recordInfo.length(idx);
                result = new FixedLenDimEnc(len);
            } else {
                result = new DictionaryDimEnc(dict);
            }
            this.encMap.put(col, result);
        }
        return result;
    }

    @Override
    public Dictionary<String> getDictionary(TblColRef col) {
        int idx = this.type.getColIndexByTblColRef(col);
        return this.colDictMap[idx];
    }
}

