/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.ii.coprocessor.endpoint;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.FixedLenDimEnc;
import org.apache.kylin.dimension.IDimensionEncodingMap;
import org.apache.kylin.invertedindex.index.TableRecordInfo;
import org.apache.kylin.invertedindex.index.TableRecordInfoDigest;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorRowType;

public class ClearTextDictionary
implements IDimensionEncodingMap {
    private final Map<TblColRef, DimensionEncoding> encMap = Maps.newHashMap();

    public ClearTextDictionary(TableRecordInfoDigest digest, CoprocessorRowType coprocessorRowType) {
        for (Map.Entry<TblColRef, Integer> entry : coprocessorRowType.columnIdxMap.entrySet()) {
            this.encMap.put(entry.getKey(), new FixedLenDimEnc(digest.length(entry.getValue())));
        }
    }

    public ClearTextDictionary(TableRecordInfo tableRecordInfo) {
        TableRecordInfoDigest digest = tableRecordInfo.getDigest();
        for (int i = 0; i < tableRecordInfo.getColumns().size(); ++i) {
            this.encMap.put(tableRecordInfo.getColumns().get(i), new FixedLenDimEnc(digest.length(i)));
        }
    }

    @Override
    public DimensionEncoding get(TblColRef col) {
        return this.encMap.get(col);
    }

    @Override
    public Dictionary<String> getDictionary(TblColRef col) {
        return null;
    }
}

