/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.ii.coprocessor.endpoint;

import it.uniroma3.mat.extendedset.intset.ConciseSet;
import it.uniroma3.mat.extendedset.intset.IntSet;
import java.util.List;
import org.apache.kylin.dimension.Dictionary;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;

public class BitMapFilterEvaluator {
    BitMapProvider provider;

    public BitMapFilterEvaluator(BitMapProvider bitMapProvider) {
        this.provider = bitMapProvider;
    }

    public ConciseSet evaluate(TupleFilter filter) {
        if (filter == null) {
            return null;
        }
        if (filter instanceof LogicalTupleFilter) {
            return this.evalLogical((LogicalTupleFilter)filter);
        }
        if (filter instanceof CompareTupleFilter) {
            return this.evalCompare((CompareTupleFilter)filter);
        }
        if (filter instanceof ConstantTupleFilter && !filter.evaluate(null, null)) {
            return new ConciseSet();
        }
        return null;
    }

    private ConciseSet evalCompare(CompareTupleFilter filter) {
        switch (filter.getOperator()) {
            case ISNULL: {
                return this.evalCompareIsNull(filter);
            }
            case ISNOTNULL: {
                return this.evalCompareIsNotNull(filter);
            }
            case EQ: {
                return this.evalCompareEqual(filter);
            }
            case NEQ: {
                return this.evalCompareNotEqual(filter);
            }
            case IN: {
                return this.evalCompareIn(filter);
            }
            case NOTIN: {
                return this.evalCompareNotIn(filter);
            }
            case LT: {
                return this.evalCompareLT(filter);
            }
            case LTE: {
                return this.evalCompareLTE(filter);
            }
            case GT: {
                return this.evalCompareGT(filter);
            }
            case GTE: {
                return this.evalCompareGTE(filter);
            }
        }
        throw new IllegalStateException("Unsupported operator " + (Object)((Object)filter.getOperator()));
    }

    private ConciseSet evalCompareLT(CompareTupleFilter filter) {
        int id = Dictionary.stringToDictId((String)filter.getFirstValue());
        return this.collectRange(filter.getColumn(), null, id - 1);
    }

    private ConciseSet evalCompareLTE(CompareTupleFilter filter) {
        int id = Dictionary.stringToDictId((String)filter.getFirstValue());
        return this.collectRange(filter.getColumn(), null, id);
    }

    private ConciseSet evalCompareGT(CompareTupleFilter filter) {
        int id = Dictionary.stringToDictId((String)filter.getFirstValue());
        return this.collectRange(filter.getColumn(), id + 1, null);
    }

    private ConciseSet evalCompareGTE(CompareTupleFilter filter) {
        int id = Dictionary.stringToDictId((String)filter.getFirstValue());
        return this.collectRange(filter.getColumn(), id, null);
    }

    private ConciseSet collectRange(TblColRef column, Integer startId, Integer endId) {
        return this.provider.getBitMap(column, startId, endId);
    }

    private ConciseSet evalCompareEqual(CompareTupleFilter filter) {
        int id = Dictionary.stringToDictId((String)filter.getFirstValue());
        ConciseSet bitMap = this.provider.getBitMap(filter.getColumn(), id, id);
        if (bitMap == null) {
            return null;
        }
        return bitMap.clone();
    }

    private ConciseSet evalCompareNotEqual(CompareTupleFilter filter) {
        ConciseSet set = this.evalCompareEqual(filter);
        this.not(set);
        this.dropNull(set, filter);
        return set;
    }

    private ConciseSet evalCompareIn(CompareTupleFilter filter) {
        ConciseSet set = new ConciseSet();
        for (Object value : filter.getValues()) {
            int id = Dictionary.stringToDictId((String)value);
            ConciseSet bitMap = this.provider.getBitMap(filter.getColumn(), id, id);
            if (bitMap == null) {
                return null;
            }
            set.addAll((IntSet)bitMap);
        }
        return set;
    }

    private ConciseSet evalCompareNotIn(CompareTupleFilter filter) {
        ConciseSet set = this.evalCompareIn(filter);
        this.not(set);
        this.dropNull(set, filter);
        return set;
    }

    private void dropNull(ConciseSet set, CompareTupleFilter filter) {
        if (set == null) {
            return;
        }
        ConciseSet nullSet = this.evalCompareIsNull(filter);
        set.removeAll((IntSet)nullSet);
    }

    private ConciseSet evalCompareIsNull(CompareTupleFilter filter) {
        ConciseSet bitMap = this.provider.getBitMap(filter.getColumn(), null, null);
        if (bitMap == null) {
            return null;
        }
        return bitMap.clone();
    }

    private ConciseSet evalCompareIsNotNull(CompareTupleFilter filter) {
        ConciseSet set = this.evalCompareIsNull(filter);
        this.not(set);
        return set;
    }

    private ConciseSet evalLogical(LogicalTupleFilter filter) {
        List<? extends TupleFilter> children = filter.getChildren();
        switch (filter.getOperator()) {
            case AND: {
                return this.evalLogicalAnd(children);
            }
            case OR: {
                return this.evalLogicalOr(children);
            }
            case NOT: {
                return this.evalLogicalNot(children);
            }
        }
        throw new IllegalStateException("Unsupported operator " + (Object)((Object)filter.getOperator()));
    }

    private ConciseSet evalLogicalAnd(List<? extends TupleFilter> children) {
        ConciseSet set = new ConciseSet();
        this.not(set);
        for (TupleFilter tupleFilter : children) {
            ConciseSet t = this.evaluate(tupleFilter);
            if (t == null) continue;
            set.retainAll((IntSet)t);
        }
        return set;
    }

    private ConciseSet evalLogicalOr(List<? extends TupleFilter> children) {
        ConciseSet set = new ConciseSet();
        for (TupleFilter tupleFilter : children) {
            ConciseSet t = this.evaluate(tupleFilter);
            if (t == null) {
                return null;
            }
            set.addAll((IntSet)t);
        }
        return set;
    }

    private ConciseSet evalLogicalNot(List<? extends TupleFilter> children) {
        ConciseSet set = this.evaluate(children.get(0));
        this.not(set);
        return set;
    }

    private void not(ConciseSet set) {
        if (set == null) {
            return;
        }
        set.add(this.provider.getRecordCount());
        set.complement();
    }

    public static void main(String[] args) {
        ConciseSet s = new ConciseSet();
        s.add(5);
        s.complement();
        System.out.println(s);
    }

    public static interface BitMapProvider {
        public ConciseSet getBitMap(TblColRef var1, Integer var2, Integer var3);

        public int getRecordCount();

        public int getMaxValueId(TblColRef var1);
    }
}

