/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.ii;

import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.security.User;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.invertedindex.IIInstance;
import org.apache.kylin.invertedindex.IIManager;
import org.apache.kylin.storage.hbase.util.IIDeployCoprocessorCLI;

public class IICreateHTableJob
extends AbstractHadoopJob {
    public int run(String[] args) throws Exception {
        Options options = new Options();
        try (HBaseAdmin admin = null;){
            String hbaseDefaultCC;
            options.addOption(OPTION_II_NAME);
            options.addOption(OPTION_HTABLE_NAME);
            this.parseOptions(options, args);
            String tableName = this.getOptionValue(OPTION_HTABLE_NAME);
            String iiName = this.getOptionValue(OPTION_II_NAME);
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            IIManager iiManager = IIManager.getInstance(config);
            IIInstance ii = iiManager.getII(iiName);
            short sharding = ii.getDescriptor().getSharding();
            Configuration conf = HBaseConfiguration.create((Configuration)this.getConf());
            admin = new HBaseAdmin(conf);
            if (admin.tableExists(tableName)) {
                if (admin.isTableEnabled(tableName)) {
                    logger.info("Table " + tableName + " already exists and is enabled, no need to create.");
                    int n = 0;
                    return n;
                }
                logger.error("Table " + tableName + " is disabled, couldn't append data");
                int n = 1;
                return n;
            }
            HTableDescriptor tableDesc = new HTableDescriptor(TableName.valueOf((String)tableName));
            HColumnDescriptor cf = new HColumnDescriptor("f");
            cf.setMaxVersions(1);
            switch (hbaseDefaultCC = config.getHbaseDefaultCompressionCodec().toLowerCase()) {
                case "snappy": {
                    logger.info("hbase will use snappy to compress data");
                    cf.setCompressionType(Compression.Algorithm.SNAPPY);
                    break;
                }
                case "lzo": {
                    logger.info("hbase will use lzo to compress data");
                    cf.setCompressionType(Compression.Algorithm.LZO);
                    break;
                }
                case "gz": 
                case "gzip": {
                    logger.info("hbase will use gzip to compress data");
                    cf.setCompressionType(Compression.Algorithm.GZ);
                    break;
                }
                case "lz4": {
                    logger.info("hbase will use lz4 to compress data");
                    cf.setCompressionType(Compression.Algorithm.LZ4);
                    break;
                }
                default: {
                    logger.info("hbase will not user any compression codec to compress data");
                }
            }
            cf.setDataBlockEncoding(DataBlockEncoding.FAST_DIFF);
            tableDesc.addFamily(cf);
            tableDesc.setValue("KYLIN_HOST", config.getMetadataUrlPrefix());
            tableDesc.setValue("CREATION_TIME", String.valueOf(System.currentTimeMillis()));
            tableDesc.setValue("SPLIT_POLICY", DisabledRegionSplitPolicy.class.getName());
            if (User.isHBaseSecurityEnabled((Configuration)conf)) {
                tableDesc.addCoprocessor("org.apache.hadoop.hbase.security.access.SecureBulkLoadEndpoint");
            }
            IIDeployCoprocessorCLI.deployCoprocessor(tableDesc);
            byte[][] splitKeys = this.getSplits(sharding);
            if (splitKeys.length == 0) {
                splitKeys = null;
            }
            admin.createTable(tableDesc, splitKeys);
            if (splitKeys != null) {
                for (int i = 0; i < splitKeys.length; ++i) {
                    logger.info("split key " + i + ": " + BytesUtil.toHex(splitKeys[i]));
                }
            }
            logger.info("create hbase table " + tableName + " done.");
            int n = 0;
            return n;
        }
    }

    private byte[][] getSplits(int shard) {
        byte[][] result = new byte[shard - 1][];
        for (int i = 1; i < shard; ++i) {
            byte[] split = new byte[2];
            BytesUtil.writeUnsigned(i, split, 0, 2);
            result[i - 1] = split;
        }
        return result;
    }
}

